/*
 * Decompiled with CFR 0.152.
 */
package alexsocol.asjlib.render;

import alexsocol.asjlib.ASJUtilities;
import alexsocol.asjlib.ExtensionsClientKt;
import alexsocol.asjlib.ExtensionsKt;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import kotlin.streams.jdk8.StreamsKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResource;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.opengl.GL11;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 ;2\u00020\u0001:\u0001;B\t\b\u0012\u00a2\u0006\u0004\b\u0002\u0010\u0003B\u0019\b\u0012\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0002\u0010\u0007J\u001a\u0010\u0014\u001a\u00020\u00002\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0002J(\u0010\u0018\u001a\u00020\u000f2\u000e\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u000fH\u0002J(\u0010\u0018\u001a\u00020\u001d2\u000e\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J0\u0010\u001e\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010 \u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020\u001dH\u0002JP\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020&2\u0016\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\u000f0(j\b\u0012\u0004\u0012\u00020\u000f`)2\u0006\u0010*\u001a\u00020\u000f2\u0006\u0010+\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020\u001dH\u0002J \u0010,\u001a\u00020\u000f2\u0006\u0010-\u001a\u00020\u000f2\u0006\u0010.\u001a\u00020\u000f2\u0006\u0010/\u001a\u000200H\u0002J \u00101\u001a\u00020\u000f2\u0006\u00102\u001a\u00020\u000f2\u0006\u00103\u001a\u00020\u000f2\u0006\u0010/\u001a\u000200H\u0002J8\u00104\u001a\u00020\u001d2\u0016\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\u000f0(j\b\u0012\u0004\u0012\u00020\u000f`)2\u0006\u00105\u001a\u00020&2\u0006\u0010!\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020\u001dH\u0002J\u0006\u00106\u001a\u00020\u000fJ\u0006\u00107\u001a\u00020$J\u0012\u00108\u001a\u0004\u0018\u0001092\u0006\u0010:\u001a\u00020\u0001H\u0002R\u001a\u0010\b\u001a\u00020\tX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u0006<"}, d2={"Lalexsocol/asjlib/render/ResourceLocationAnimated;", "Lnet/minecraft/util/ResourceLocation;", "<init>", "()V", "mod", "", "path", "(Ljava/lang/String;Ljava/lang/String;)V", "frameList", "", "getFrameList", "()[I", "setFrameList", "([I)V", "framerate", "", "getFramerate", "()I", "setFramerate", "(I)V", "init", "metaStream", "Ljava/io/InputStream;", "imageStream", "getMeta", "meta", "", "marker", "default", "", "loadImage", "h", "interpolationFrames", "blur", "clamp", "doInterpolation", "", "prev", "Ljava/awt/image/BufferedImage;", "cur", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "step", "last", "interpolateColor", "color1", "color2", "fraction", "", "interpolateChannel", "channel1", "channel2", "put", "part", "getCurrentFrame", "bind", "getResourceSafe", "Lnet/minecraft/client/resources/IResource;", "loc", "Companion", "1.7.10-ASJCore"})
@SourceDebugExtension(value={"SMAP\nResourceLocationAnimated.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResourceLocationAnimated.kt\nalexsocol/asjlib/render/ResourceLocationAnimated\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,139:1\n295#2,2:140\n295#2,2:142\n*S KotlinDebug\n*F\n+ 1 ResourceLocationAnimated.kt\nalexsocol/asjlib/render/ResourceLocationAnimated\n*L\n34#1:140,2\n36#1:142,2\n*E\n"})
public final class ResourceLocationAnimated
extends ResourceLocation {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public int[] frameList;
    private int framerate = 1;
    @NotNull
    private static final String MARKER_BLUR = "blur=";
    @NotNull
    private static final String MARKER_CLAMP = "clamp=";
    @NotNull
    private static final String MARKER_FRAMERATE = "framerate=";
    @NotNull
    private static final String MARKER_HEIGHT = "height=";
    @NotNull
    private static final String MARKER_INTERPOLATION_STEPS = "interpolation=";

    @NotNull
    public final int[] getFrameList() {
        if (this.frameList != null) {
            return this.frameList;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"frameList");
        return null;
    }

    public final void setFrameList(@NotNull int[] nArray) {
        Intrinsics.checkNotNullParameter((Object)nArray, (String)"<set-?>");
        this.frameList = nArray;
    }

    public final int getFramerate() {
        return this.framerate;
    }

    public final void setFramerate(int n) {
        this.framerate = n;
    }

    private ResourceLocationAnimated() {
        super("textures/entity/steve.png");
        this.setFrameList(new int[0]);
    }

    private ResourceLocationAnimated(String mod, String path) {
        super(mod, path);
        IResource iResource = this.getResourceSafe(new ResourceLocation(this.resourceDomain, this.resourcePath + ".meta"));
        InputStream inputStream = iResource != null ? iResource.getInputStream() : null;
        InputStream inputStream2 = ExtensionsClientKt.getMc().getResourceManager().getResource((ResourceLocation)this).getInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream2, (String)"getInputStream(...)");
        this.init(inputStream, inputStream2);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final ResourceLocationAnimated init(InputStream metaStream, InputStream imageStream) {
        v0 /* !! */  = metaStream;
        if (v0 /* !! */  == null) ** GOTO lbl-1000
        var4_3 = v0 /* !! */ ;
        var5_4 = Charsets.UTF_8;
        var6_5 = new InputStreamReader(var4_3, var5_4);
        var7_6 = 8192;
        v0 /* !! */  = (var6_5 instanceof BufferedReader != false ? (BufferedReader)var6_5 : new BufferedReader(var6_5, var7_6)).lines();
        if (v0 /* !! */  != null) {
            v1 = StreamsKt.toList((Stream)v0 /* !! */ );
        } else lbl-1000:
        // 2 sources

        {
            v1 = null;
        }
        meta = v1;
        this.framerate = this.getMeta(meta, "framerate=", 1);
        this.setFrameList(this.loadImage(this.getMeta(meta, "height=", 0), imageStream, this.getMeta((List<String>)meta, "interpolation=", 1), this.getMeta((List<String>)meta, "blur=", false), this.getMeta((List<String>)meta, "clamp=", false)));
        return this;
    }

    private final int getMeta(List<String> meta, String marker, int n) {
        List<String> list;
        block5: {
            block4: {
                Object v1;
                block3: {
                    list = meta;
                    if (list == null) break block4;
                    Iterable $this$firstOrNull$iv = list;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        String it = (String)element$iv;
                        boolean bl = false;
                        if (!StringsKt.startsWith$default((String)it, (String)marker, (boolean)false, (int)2, null)) continue;
                        v1 = element$iv;
                        break block3;
                    }
                    v1 = null;
                }
                if ((list = (String)v1) != null) break block5;
            }
            list = marker + n;
        }
        return Integer.parseInt(StringsKt.replace$default((String)((Object)list), (String)marker, (String)"", (boolean)false, (int)4, null));
    }

    private final boolean getMeta(List<String> meta, String marker, boolean bl) {
        List<String> list;
        block5: {
            block4: {
                Object v1;
                block3: {
                    list = meta;
                    if (list == null) break block4;
                    Iterable $this$firstOrNull$iv = list;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        String it = (String)element$iv;
                        boolean bl2 = false;
                        if (!StringsKt.startsWith$default((String)it, (String)marker, (boolean)false, (int)2, null)) continue;
                        v1 = element$iv;
                        break block3;
                    }
                    v1 = null;
                }
                if ((list = (String)v1) != null) break block5;
            }
            list = marker + bl;
        }
        return Boolean.parseBoolean(StringsKt.replace$default((String)((Object)list), (String)marker, (String)"", (boolean)false, (int)4, null));
    }

    private final int[] loadImage(int h, InputStream imageStream, int interpolationFrames, boolean blur, boolean clamp) {
        BufferedImage image = ImageIO.read(imageStream);
        int height = h == 0 ? image.getWidth() : h;
        ArrayList<Integer> frameList = new ArrayList<Integer>();
        BufferedImage first = null;
        BufferedImage prev = null;
        boolean interpolate = interpolationFrames > 1;
        IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)0, (int)image.getHeight())), (int)height);
        int i2 = intProgression.getFirst();
        int n = intProgression.getLast();
        int n2 = intProgression.getStep();
        if (n2 > 0 && i2 <= n || n2 < 0 && n <= i2) {
            while (true) {
                BufferedImage part = image.getSubimage(0, i2, image.getWidth(), height);
                if (interpolate) {
                    if (first == null) {
                        prev = first = part;
                        BufferedImage bufferedImage = first;
                        Intrinsics.checkNotNull((Object)bufferedImage);
                        this.put(frameList, bufferedImage, blur, clamp);
                    } else {
                        BufferedImage bufferedImage = prev;
                        Intrinsics.checkNotNull((Object)bufferedImage);
                        Intrinsics.checkNotNull((Object)part);
                        this.doInterpolation(bufferedImage, part, frameList, interpolationFrames, false, blur, clamp);
                        prev = part;
                    }
                } else {
                    Intrinsics.checkNotNull((Object)part);
                    this.put(frameList, part, blur, clamp);
                }
                if (i2 == n) break;
                i2 += n2;
            }
        }
        if (interpolate) {
            BufferedImage bufferedImage = prev;
            Intrinsics.checkNotNull(bufferedImage);
            BufferedImage bufferedImage2 = first;
            Intrinsics.checkNotNull(bufferedImage2);
            this.doInterpolation(bufferedImage, bufferedImage2, frameList, interpolationFrames, true, blur, clamp);
        }
        return CollectionsKt.toIntArray((Collection)frameList);
    }

    private final void doInterpolation(BufferedImage prev, BufferedImage cur, ArrayList<Integer> frameList, int step, boolean last, boolean blur, boolean clamp) {
        double fraction = 1.0 / (double)step;
        int width = cur.getWidth();
        int height = cur.getHeight();
        for (int i2 = 1; i2 < step; ++i2) {
            BufferedImage interstep = new BufferedImage(width, height, cur.getType());
            for (int u = 0; u < width; ++u) {
                for (int v = 0; v < height; ++v) {
                    interstep.setRGB(u, v, this.interpolateColor(prev.getRGB(u, v), cur.getRGB(u, v), fraction * (double)i2));
                }
            }
            this.put(frameList, interstep, blur, clamp);
        }
        if (!last) {
            this.put(frameList, cur, blur, clamp);
        }
    }

    private final int interpolateColor(int color1, int color2, double fraction) {
        Color c1 = new Color(color1, true);
        Color c2 = new Color(color2, true);
        return new Color(this.interpolateChannel(c1.getRed(), c2.getRed(), fraction), this.interpolateChannel(c1.getGreen(), c2.getGreen(), fraction), this.interpolateChannel(c1.getBlue(), c2.getBlue(), fraction), this.interpolateChannel(c1.getAlpha(), c2.getAlpha(), fraction)).getRGB();
    }

    private final int interpolateChannel(int channel1, int channel2, double fraction) {
        return ExtensionsKt.getI((double)(channel2 - channel1) * fraction + (double)channel1);
    }

    private final boolean put(ArrayList<Integer> frameList, BufferedImage part, boolean blur, boolean clamp) {
        return frameList.add(TextureUtil.uploadTextureImageAllocate((int)GL11.glGenTextures(), (BufferedImage)part, (boolean)blur, (boolean)clamp));
    }

    public final int getCurrentFrame() {
        if (ASJUtilities.isServer()) {
            return 0;
        }
        WorldClient worldClient = ExtensionsClientKt.getMc().theWorld;
        return this.getFrameList()[ExtensionsKt.getI((worldClient != null ? worldClient.getTotalWorldTime() : 0L) % (long)(this.framerate * this.getFrameList().length) / (long)this.framerate)];
    }

    public final void bind() {
        if (ASJUtilities.isClient()) {
            GL11.glBindTexture((int)3553, (int)this.getCurrentFrame());
        }
    }

    private final IResource getResourceSafe(ResourceLocation loc) {
        IResource iResource;
        try {
            iResource = ExtensionsClientKt.getMc().getResourceManager().getResource(loc);
        }
        catch (Throwable e) {
            ASJUtilities.error("Error loading " + loc, e);
            iResource = null;
        }
        return iResource;
    }

    public /* synthetic */ ResourceLocationAnimated(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    public /* synthetic */ ResourceLocationAnimated(String mod, String path, DefaultConstructorMarker $constructor_marker) {
        this(mod, path);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rJ\u0016\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lalexsocol/asjlib/render/ResourceLocationAnimated$Companion;", "", "<init>", "()V", "MARKER_BLUR", "", "MARKER_CLAMP", "MARKER_FRAMERATE", "MARKER_HEIGHT", "MARKER_INTERPOLATION_STEPS", "custom", "Lalexsocol/asjlib/render/ResourceLocationAnimated;", "metaStream", "Ljava/io/InputStream;", "imageStream", "local", "mod", "path", "1.7.10-ASJCore"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ResourceLocationAnimated custom(@NotNull InputStream metaStream, @NotNull InputStream imageStream) {
            Intrinsics.checkNotNullParameter((Object)metaStream, (String)"metaStream");
            Intrinsics.checkNotNullParameter((Object)imageStream, (String)"imageStream");
            ResourceLocationAnimated rla = new ResourceLocationAnimated(null);
            if (ASJUtilities.isClient()) {
                rla.init(metaStream, imageStream);
            }
            return rla;
        }

        @NotNull
        public final ResourceLocationAnimated local(@NotNull String mod, @NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)mod, (String)"mod");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            if (ASJUtilities.isServer()) {
                return new ResourceLocationAnimated(null);
            }
            return new ResourceLocationAnimated(mod, path, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

