/*
 * Decompiled with CFR 0.152.
 */
package alexsocol.asjlib.render;

import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Matrix;
import org.lwjgl.util.vector.Matrix4f;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\b&\u0018\u0000 $2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001$B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u0016\u001a\u00020\u0017H&J#\u0010\u0018\u001a\u00020\u00172\u0016\u0010\u0019\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00130\u0012\"\u0004\u0018\u00010\u0013\u00a2\u0006\u0002\u0010\u001aJ\u001f\u0010\u001b\u001a\u00020\u00172\u0010\u0010\u001c\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00130\u0012H\u0016\u00a2\u0006\u0002\u0010\u001aJ\u0006\u0010\u001d\u001a\u00020\u0017J\b\u0010\u001e\u001a\u00020\u0017H&J\u0011\u0010\u001f\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\u0000H\u0096\u0002J\u0013\u0010!\u001a\u00020\"2\b\u0010 \u001a\u0004\u0018\u00010\u0013H\u0096\u0002J\b\u0010#\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR-\u0010\u000e\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\u0011\u0012\u000e\u0012\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00130\u00120\u00100\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006%"}, d2={"Lalexsocol/asjlib/render/ShadedObject;", "", "shaderID", "", "materialID", "texture", "Lnet/minecraft/util/ResourceLocation;", "<init>", "(IILnet/minecraft/util/ResourceLocation;)V", "getShaderID", "()I", "getMaterialID", "getTexture", "()Lnet/minecraft/util/ResourceLocation;", "translations", "Ljava/util/ArrayList;", "Lkotlin/Pair;", "Lorg/lwjgl/util/vector/Matrix4f;", "", "", "getTranslations", "()Ljava/util/ArrayList;", "preRender", "", "addTranslation", "additionalData", "([Ljava/lang/Object;)V", "drawMesh", "data", "doRender", "postRender", "compareTo", "other", "equals", "", "hashCode", "Companion", "1.7.10-ASJCore"})
public abstract class ShadedObject
implements Comparable<ShadedObject> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int shaderID;
    private final int materialID;
    @Nullable
    private final ResourceLocation texture;
    @NotNull
    private final ArrayList<Pair<Matrix4f, Object[]>> translations;
    private static final FloatBuffer usableBuffer = BufferUtils.createFloatBuffer((int)32);

    public ShadedObject(int shaderID, int materialID, @Nullable ResourceLocation texture) {
        this.shaderID = shaderID;
        this.materialID = materialID;
        this.texture = texture;
        this.translations = new ArrayList();
    }

    public final int getShaderID() {
        return this.shaderID;
    }

    public final int getMaterialID() {
        return this.materialID;
    }

    @Nullable
    public final ResourceLocation getTexture() {
        return this.texture;
    }

    @NotNull
    public final ArrayList<Pair<Matrix4f, Object[]>> getTranslations() {
        return this.translations;
    }

    public abstract void preRender();

    public final void addTranslation(Object ... additionalData) {
        Intrinsics.checkNotNullParameter((Object)additionalData, (String)"additionalData");
        GL11.glGetFloat((int)2982, (FloatBuffer)usableBuffer);
        Matrix matrix = new Matrix4f().load(usableBuffer);
        Intrinsics.checkNotNull((Object)matrix, (String)"null cannot be cast to non-null type org.lwjgl.util.vector.Matrix4f");
        this.translations.add((Pair<Matrix4f, Object[]>)TuplesKt.to((Object)((Matrix4f)matrix), (Object)additionalData));
        usableBuffer.clear();
    }

    public void drawMesh(@NotNull Object[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
    }

    public final void doRender() {
        GL11.glMatrixMode((int)5888);
        GL11.glPushMatrix();
        Iterator<Pair<Matrix4f, Object[]>> iterator = this.translations.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<Pair<Matrix4f, Object[]>> iterator2 = iterator;
        while (iterator2.hasNext()) {
            Pair<Matrix4f, Object[]> pair;
            Intrinsics.checkNotNullExpressionValue(iterator2.next(), (String)"next(...)");
            Matrix4f translation = (Matrix4f)pair.component1();
            Object[] data = (Object[])pair.component2();
            GL11.glLoadIdentity();
            translation.store(usableBuffer);
            usableBuffer.flip();
            GL11.glMultMatrix((FloatBuffer)usableBuffer);
            usableBuffer.clear();
            this.drawMesh(data);
        }
        GL11.glPopMatrix();
    }

    public abstract void postRender();

    @Override
    public int compareTo(@NotNull ShadedObject other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (this.shaderID < other.shaderID) {
            return -1;
        }
        if (this.shaderID > other.shaderID) {
            return 1;
        }
        if (this.materialID < other.materialID) {
            return -1;
        }
        return this.materialID > other.materialID ? 1 : 0;
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof ShadedObject ? this.compareTo((ShadedObject)other) == 0 : super.equals(other);
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.shaderID, this.materialID, this.texture};
        return Objects.hash(objectArray);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lalexsocol/asjlib/render/ShadedObject$Companion;", "", "<init>", "()V", "usableBuffer", "Ljava/nio/FloatBuffer;", "kotlin.jvm.PlatformType", "1.7.10-ASJCore"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

