/*
 * Decompiled with CFR 0.152.
 */
package com.KAIIIAK.superwrapper;

import com.KAIIIAK.KASMLib.KASMLib;
import com.KAIIIAK.classManipulators.SomeUtil;
import com.KAIIIAK.superwrapper.McpToSrg;
import com.KAIIIAK.superwrapper.SuperWrapper;
import com.KAIIIAK.superwrapper.SuperWrapperTransformerContainer;
import cpw.mods.fml.relauncher.FMLLaunchHandler;
import cpw.mods.fml.relauncher.SideOnly;
import gloomyfolken.hooklib.asm.HookLogger;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.launchwrapper.IClassTransformer;
import org.apache.commons.io.IOUtils;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class SuperWrapperTransformer
implements IClassTransformer {
    private static final String SIDEONLY_DESC = Type.getDescriptor(SideOnly.class);
    private static final String SIDE = FMLLaunchHandler.side().name();
    public static final String SUPERWRAPPER_DESC = Type.getDescriptor(SuperWrapper.class);
    public static HookLogger logger = new HookLogger.Log4JLogger("SuperWrapper");
    public static List<SuperWrapperTransformerContainer> registeredContainers = new ArrayList<SuperWrapperTransformerContainer>();

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (basicClass == null) {
            return null;
        }
        ClassReader classReader = new ClassReader(basicClass);
        ClassNode classNode = new ClassNode();
        classReader.accept((ClassVisitor)classNode, 0);
        ClassWriter classWriter = new ClassWriter(classReader, 0);
        long cng = 0L;
        for (SuperWrapperTransformerContainer container : registeredContainers) {
            try {
                if (container.containerClassName.equals(classNode.name)) {
                    if (classNode.methods == null) {
                        throw new IllegalArgumentException(String.format("SuperWrapper container %s must have at least one SuperWrapper method", classNode.name));
                    }
                    logger.debug("Patching SuperWrapper container " + transformedName);
                    for (MethodNode methodNode : classNode.methods) {
                        if (!this.isMethodTheSameAsInContainer(methodNode, container)) continue;
                        logger.debug("Patching SuperWrapper " + methodNode.name);
                        Type methodType = Type.getMethodType((String)methodNode.desc);
                        InsnList newInstructions = new InsnList();
                        Type[] argumentTypes = methodType.getArgumentTypes();
                        for (int i2 = 0; i2 < argumentTypes.length; ++i2) {
                            newInstructions.add((AbstractInsnNode)new VarInsnNode(argumentTypes[i2].getOpcode(21), i2));
                        }
                        newInstructions.add((AbstractInsnNode)new MethodInsnNode(182, container.targetClass.getInternalName(), container.getInsertMethodName(), container.getInsertMethodDesc(), false));
                        if (methodType.getReturnType() == Type.VOID_TYPE) {
                            newInstructions.add((AbstractInsnNode)new InsnNode(177));
                        } else {
                            newInstructions.add((AbstractInsnNode)new InsnNode(methodType.getReturnType().getOpcode(172)));
                        }
                        methodNode.instructions.clear();
                        methodNode.instructions.add(newInstructions);
                        ++cng;
                    }
                    continue;
                }
                if (!classNode.name.equals(container.targetClass.getInternalName())) continue;
                logger.debug("Injecting synthetic super bridge " + container.getInsertMethodName() + " to " + classNode.name);
                if (classNode.methods == null) {
                    classNode.methods = new ArrayList();
                }
                MethodNode newMethod = new MethodNode(1, container.getInsertMethodName(), container.getInsertMethodDesc(), container.signatureForInsetMethod, container.exceptionsForInsetMethod);
                InsnList instructions = newMethod.instructions = new InsnList();
                instructions.add((AbstractInsnNode)new VarInsnNode(container.targetClass.getOpcode(21), 0));
                for (int i3 = 0; i3 < container.targetMethodArgs.length; ++i3) {
                    instructions.add((AbstractInsnNode)new VarInsnNode(container.targetMethodArgs[i3].getOpcode(21), i3 + 1));
                }
                String targetMethod = McpToSrg.getTargetMethodMatchingNameAndDesc(classNode.methods, container.targetMethod, container.getInsertMethodDesc());
                instructions.add((AbstractInsnNode)new MethodInsnNode(container.callThis ? 183 : 182, container.targetClass.getInternalName(), targetMethod, container.getInsertMethodDesc(), false));
                if (container.targetMethodRet == Type.VOID_TYPE) {
                    instructions.add((AbstractInsnNode)new InsnNode(177));
                } else {
                    instructions.add((AbstractInsnNode)new InsnNode(container.targetMethodRet.getOpcode(172)));
                }
                classNode.methods.add(newMethod);
                ++cng;
            }
            catch (Exception e) {
                logger.error("Exception while transforming class " + transformedName, e);
                throw e;
            }
        }
        if (cng > 0L) {
            logger.debug("Trying to make " + cng + " changes in " + name + "(" + transformedName + ")");
            try {
                File file;
                classNode.accept((ClassVisitor)classWriter);
                byte[] bytes = classWriter.toByteArray();
                if (KASMLib.has2DumpChangedClasses) {
                    file = new File("ASJCoreDumpClasses/SuperWrapper/" + transformedName.replaceAll("\\.", "/") + ".class");
                    file.getParentFile().mkdirs();
                    IOUtils.write((byte[])bytes, (OutputStream)Files.newOutputStream(file.toPath(), new OpenOption[0]));
                }
                if (KASMLib.has2DumpUnchangedClasses) {
                    file = new File("ASJCoreDumpClasses/SuperWrapper/" + transformedName.replaceAll("\\.", "/") + "UNCHANGED.class");
                    file.getParentFile().mkdirs();
                    IOUtils.write((byte[])basicClass, (OutputStream)Files.newOutputStream(file.toPath(), new OpenOption[0]));
                }
                return bytes;
            }
            catch (Exception e) {
                logger.error("Exception while making changes in class " + transformedName, e);
                throw new RuntimeException(e);
            }
        }
        return basicClass;
    }

    private boolean isMethodTheSameAsInContainer(MethodNode methodNode, SuperWrapperTransformerContainer container) {
        return methodNode.name.equals(container.methodName) && this.hasSuperWrapperAnnotation(methodNode) && methodNode.desc.equals(container.desc);
    }

    private boolean hasSuperWrapperAnnotation(MethodNode methodNode) {
        return this.containsAnnotation(methodNode.visibleAnnotations) || this.containsAnnotation(methodNode.invisibleAnnotations);
    }

    private boolean containsAnnotation(List<AnnotationNode> annotations) {
        if (annotations != null) {
            for (AnnotationNode annotationNode : annotations) {
                if (!SUPERWRAPPER_DESC.equals(annotationNode.desc)) continue;
                return true;
            }
        }
        return false;
    }

    public static void registerSuperWrapperContainer(String clazz) {
        try {
            SuperWrapperTransformer.registerSuperWrapperContainer(IOUtils.toByteArray((InputStream)SuperWrapperTransformer.class.getResourceAsStream('/' + clazz.replace('.', '/') + ".class")));
        }
        catch (IOException e) {
            logger.error("Cannot parse SuperWrappers container " + clazz, e);
            throw new RuntimeException(e);
        }
    }

    private static void registerSuperWrapperContainer(byte[] clazzBytes) {
        try {
            ClassReader classReader = new ClassReader(clazzBytes);
            ClassNode classNode = new ClassNode();
            classReader.accept((ClassVisitor)classNode, 0);
            if (classNode.methods == null) {
                throw new IllegalArgumentException(String.format("SuperWrapper container %s must have at least one SuperWrapper method", classNode.name));
            }
            boolean found = false;
            for (MethodNode methodNode : classNode.methods) {
                Object targetSide;
                AnnotationNode sideOnlyAnnotation;
                boolean containsAnnotation = false;
                String signatureFromAnnotation = null;
                String targetMethodFromAnnotation = null;
                List exceptionsFromAnnotation = null;
                String methodPostfixFromAnnotation = null;
                String methodPrefixFromAnnotation = null;
                Boolean callThis = true;
                ArrayList annotations = new ArrayList();
                if (methodNode.visibleAnnotations != null) {
                    annotations.addAll(methodNode.visibleAnnotations);
                }
                if (methodNode.invisibleAnnotations != null) {
                    annotations.addAll(methodNode.invisibleAnnotations);
                }
                if ((sideOnlyAnnotation = (AnnotationNode)annotations.stream().filter(it -> SIDEONLY_DESC.equals(it.desc)).findFirst().orElse(null)) != null && !SIDE.equals(targetSide = ((String[])sideOnlyAnnotation.values.get(1))[1])) {
                    logger.debug("Skipping SuperWrapper method " + methodNode.name + methodNode.desc + " for invalid side " + (String)targetSide);
                    continue;
                }
                targetSide = annotations.iterator();
                while (targetSide.hasNext()) {
                    AnnotationNode annotationNode = (AnnotationNode)targetSide.next();
                    if (!SUPERWRAPPER_DESC.equals(annotationNode.desc)) continue;
                    if ((methodNode.access & 8) != 8) {
                        throw new IllegalArgumentException(String.format("SuperWrapper method %s$%s must be static!", classNode.name, methodNode.name));
                    }
                    if (annotationNode.values != null) {
                        Map<String, Object> annotationArgs = SomeUtil.convertListToMap(annotationNode.values);
                        if (annotationArgs.containsKey("targetMethod")) {
                            targetMethodFromAnnotation = (String)annotationArgs.get("targetMethod");
                        }
                        if (annotationArgs.containsKey("methodNamePrefix")) {
                            methodPrefixFromAnnotation = (String)annotationArgs.get("methodNamePrefix");
                        }
                        if (annotationArgs.containsKey("methodNamePostfix")) {
                            methodPostfixFromAnnotation = (String)annotationArgs.get("methodNamePostfix");
                        }
                        if (annotationArgs.containsKey("exceptions")) {
                            exceptionsFromAnnotation = (List)annotationArgs.get("exceptions");
                        }
                        if (annotationArgs.containsKey("signature")) {
                            signatureFromAnnotation = (String)annotationArgs.get("signature");
                        }
                        if (annotationArgs.containsKey("callThis")) {
                            callThis = (Boolean)annotationArgs.get("callThis");
                        }
                    }
                    containsAnnotation = true;
                    break;
                }
                if (!containsAnnotation) continue;
                Type methodType = Type.getMethodType((String)methodNode.desc);
                Type[] argTypes = methodType.getArgumentTypes();
                if (argTypes.length == 0) {
                    throw new IllegalArgumentException(String.format("SuperWrapper method %s$%s must have target class as first argument!", classNode.name, methodNode.name));
                }
                Type[] newDescTypes = new Type[argTypes.length - 1];
                System.arraycopy(argTypes, 1, newDescTypes, 0, newDescTypes.length);
                Type newDescReturnType = methodType.getReturnType();
                SuperWrapperTransformerContainer container = new SuperWrapperTransformerContainer(classNode.name, argTypes[0], methodNode.name, newDescTypes, newDescReturnType);
                container.setPrefixForInsertMethod(methodPrefixFromAnnotation == null ? "Super__" : methodPrefixFromAnnotation);
                container.setPostfixForInsertMethod(methodPostfixFromAnnotation == null ? "__Wrapper" : methodPostfixFromAnnotation);
                container.setSignatureForInsertMethod((String)(signatureFromAnnotation != null ? signatureFromAnnotation : (methodNode.signature == null ? null : methodNode.signature.replaceFirst("\\(L" + container.targetClass.getInternalName() + ";", "("))));
                container.setExceptionsForInsetMethod(exceptionsFromAnnotation != null ? exceptionsFromAnnotation : methodNode.exceptions);
                container.setCallThis(callThis);
                container.setDesc(methodNode.desc);
                container.setTargetMethod(targetMethodFromAnnotation != null ? targetMethodFromAnnotation : methodNode.name);
                registeredContainers.add(container);
                found = true;
            }
            if (!found) {
                throw new IllegalArgumentException(String.format("SuperWrapper container %s must have at least one SuperWrapper method", classNode.name));
            }
        }
        catch (Exception e) {
            logger.error("Cannot parse SuperWrappers container's bytes", e);
            throw e;
        }
    }
}

