/*
 * Decompiled with CFR 0.152.
 */
package gloomyfolken.hooklib.asm;

import gloomyfolken.hooklib.asm.ClassMetadataReader;
import gloomyfolken.hooklib.asm.HookInjectorClassVisitor;
import gloomyfolken.hooklib.asm.HookInjectorFactory;
import gloomyfolken.hooklib.asm.HookInjectorMethodVisitor;
import gloomyfolken.hooklib.asm.HookPriority;
import gloomyfolken.hooklib.asm.ReturnCondition;
import gloomyfolken.hooklib.asm.ReturnValue;
import gloomyfolken.hooklib.asm.TypeHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class AsmHook
implements Cloneable,
Comparable<AsmHook> {
    public static final HookInjectorFactory ON_ENTER_FACTORY = HookInjectorFactory.MethodEnter.INSTANCE;
    public static final HookInjectorFactory ON_EXIT_FACTORY = HookInjectorFactory.MethodExit.INSTANCE;
    private String targetClassName;
    private String targetMethodName;
    private List<Type> targetMethodParameters = new ArrayList<Type>(2);
    private Type targetMethodReturnType;
    private String hooksClassName;
    private String hookMethodName;
    private List<Integer> transmittableVariableIds = new ArrayList<Integer>(2);
    private List<Type> hookMethodParameters = new ArrayList<Type>(2);
    private Type hookMethodReturnType = Type.VOID_TYPE;
    private boolean hasReturnValueParameter;
    private ReturnCondition returnCondition = ReturnCondition.NEVER;
    private ReturnValue returnValue = ReturnValue.VOID;
    private Object primitiveConstant;
    private HookInjectorFactory injectorFactory = ON_ENTER_FACTORY;
    private HookPriority priority = HookPriority.NORMAL;
    private String targetMethodDescription;
    private String hookMethodDescription;
    private String returnMethodName;
    private String returnMethodDescription;
    private boolean isAbstract;
    private boolean isStatic;
    private String superClass;
    private boolean createMethod;
    private boolean isMandatory;

    public static Builder newBuilder() {
        AsmHook asmHook = new AsmHook();
        asmHook.getClass();
        return asmHook.new Builder();
    }

    protected String getTargetClassName() {
        return this.targetClassName;
    }

    protected boolean isTargetMethod(String name, String desc) {
        return (this.targetMethodReturnType == null && desc.startsWith(this.targetMethodDescription) || desc.equals(this.targetMethodDescription)) && name.equals(this.targetMethodName);
    }

    protected boolean isAbstract() {
        return this.isAbstract;
    }

    protected boolean isStatic() {
        return this.isStatic;
    }

    protected String getSuperClass() {
        return this.superClass;
    }

    protected boolean getCreateMethod() {
        return this.createMethod;
    }

    protected boolean isMandatory() {
        return this.isMandatory;
    }

    protected HookInjectorFactory getInjectorFactory() {
        return this.injectorFactory;
    }

    protected void createMethod(HookInjectorClassVisitor classVisitor, boolean isStatic, boolean isAbstract, String superClass) {
        if (isStatic && isAbstract) {
            throw new IllegalArgumentException("Cannot make static abstract class");
        }
        ClassMetadataReader.MethodReference superMethod = classVisitor.transformer.classMetadataReader.findVirtualMethod(this.getTargetClassInternalName(), this.targetMethodName, this.targetMethodDescription);
        int access = 1;
        if (isStatic) {
            access |= 8;
        } else if (isAbstract) {
            access |= 0x400;
        }
        MethodVisitor mv = classVisitor.visitMethod(access, superMethod == null ? this.targetMethodName : superMethod.name, this.targetMethodDescription, null, null);
        if (!(mv instanceof HookInjectorMethodVisitor)) {
            throw new IllegalArgumentException("Hook injector not created");
        }
        HookInjectorMethodVisitor inj = (HookInjectorMethodVisitor)mv;
        if (!isAbstract) {
            inj.visitCode();
            if (superClass.length() > 0) {
                inj.visitVarInsn(25, 0);
                String[] superClassInfoList = superClass.split("\\.");
                if (superClassInfoList.length == 1) {
                    inj.visitMethodInsn(183, superClass, "<init>", "()V", false);
                } else if (superClassInfoList.length == 2) {
                    inj.visitMethodInsn(183, superClassInfoList[0], "<init>", superClassInfoList[1], false);
                } else {
                    if (superClassInfoList.length == 3) {
                        throw new IllegalArgumentException("superClass arguments count must not be odd");
                    }
                    if (superClassInfoList.length > 3) {
                        if ((superClassInfoList.length & 1) == 0) {
                            for (int i2 = 0; i2 < superClassInfoList.length - 2; i2 += 2) {
                                if (i2 + 2 == superClassInfoList.length - 1) {
                                    throw new IllegalArgumentException("? superClass is not correct ?");
                                }
                                inj.visitVarInsn(Integer.parseInt(superClassInfoList[i2 + 1]), Integer.parseInt(superClassInfoList[i2 + 2]));
                            }
                            inj.visitMethodInsn(183, superClassInfoList[0], "<init>", superClassInfoList[superClassInfoList.length - 1], false);
                        } else {
                            throw new IllegalArgumentException("superClass is not even");
                        }
                    }
                }
            }
            inj.visitLabel(new Label());
            if (superMethod == null) {
                this.injectDefaultValue(inj, this.targetMethodReturnType);
            } else {
                this.injectSuperCall(inj, superMethod);
            }
            this.injectReturn(inj, this.targetMethodReturnType);
            inj.visitLabel(new Label());
            inj.visitMaxs(0, 0);
        }
        inj.visitEnd();
    }

    private String getTargetClassInternalName() {
        return this.targetClassName.replace('.', '/');
    }

    private void injectDefaultValue(HookInjectorMethodVisitor inj, Type targetMethodReturnType) {
        switch (targetMethodReturnType.getSort()) {
            case 0: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                inj.visitInsn(3);
                break;
            }
            case 6: {
                inj.visitInsn(11);
                break;
            }
            case 7: {
                inj.visitInsn(9);
                break;
            }
            case 8: {
                inj.visitInsn(14);
                break;
            }
            default: {
                inj.visitInsn(1);
            }
        }
    }

    private void injectSuperCall(HookInjectorMethodVisitor inj, ClassMetadataReader.MethodReference method) {
        int variableId = 0;
        for (int i2 = 0; i2 <= this.targetMethodParameters.size(); ++i2) {
            Type parameterType = i2 == 0 ? TypeHelper.getType(this.targetClassName) : this.targetMethodParameters.get(i2 - 1);
            this.injectLoad(inj, parameterType, variableId);
            if (parameterType.getSort() == 8 || parameterType.getSort() == 7) {
                variableId += 2;
                continue;
            }
            ++variableId;
        }
        inj.visitMethodInsn(183, method.owner, method.name, method.desc, false);
    }

    private void injectReturn(HookInjectorMethodVisitor inj, Type targetMethodReturnType) {
        if (targetMethodReturnType == Type.INT_TYPE || targetMethodReturnType == Type.SHORT_TYPE || targetMethodReturnType == Type.BOOLEAN_TYPE || targetMethodReturnType == Type.BYTE_TYPE || targetMethodReturnType == Type.CHAR_TYPE) {
            inj.visitInsn(172);
        } else if (targetMethodReturnType == Type.LONG_TYPE) {
            inj.visitInsn(173);
        } else if (targetMethodReturnType == Type.FLOAT_TYPE) {
            inj.visitInsn(174);
        } else if (targetMethodReturnType == Type.DOUBLE_TYPE) {
            inj.visitInsn(175);
        } else if (targetMethodReturnType == Type.VOID_TYPE) {
            inj.visitInsn(177);
        } else {
            inj.visitInsn(176);
        }
    }

    private void injectLoad(HookInjectorMethodVisitor inj, Type parameterType, int variableId) {
        int opcode = parameterType == Type.INT_TYPE || parameterType == Type.BYTE_TYPE || parameterType == Type.CHAR_TYPE || parameterType == Type.BOOLEAN_TYPE || parameterType == Type.SHORT_TYPE ? 21 : (parameterType == Type.LONG_TYPE ? 22 : (parameterType == Type.FLOAT_TYPE ? 23 : (parameterType == Type.DOUBLE_TYPE ? 24 : 25)));
        inj.visitVarInsn(opcode, variableId);
    }

    protected void inject(HookInjectorMethodVisitor inj) {
        Type targetMethodReturnType = inj.methodType.getReturnType();
        int returnLocalId = -1;
        if (this.hasReturnValueParameter) {
            returnLocalId = inj.newLocal(targetMethodReturnType);
            inj.visitVarInsn(targetMethodReturnType.getOpcode(54), returnLocalId);
        }
        int hookResultLocalId = -1;
        if (this.hasHookMethod()) {
            this.injectInvokeStatic(inj, returnLocalId, this.hookMethodName, this.hookMethodDescription);
            if (this.returnValue == ReturnValue.HOOK_RETURN_VALUE || this.returnCondition.requiresCondition) {
                hookResultLocalId = inj.newLocal(this.hookMethodReturnType);
                inj.visitVarInsn(this.hookMethodReturnType.getOpcode(54), hookResultLocalId);
            }
        }
        if (this.returnCondition != ReturnCondition.NEVER) {
            Label label = inj.newLabel();
            if (this.returnCondition != ReturnCondition.ALWAYS) {
                inj.visitVarInsn(this.hookMethodReturnType.getOpcode(21), hookResultLocalId);
                if (this.returnCondition == ReturnCondition.ON_TRUE) {
                    inj.visitJumpInsn(153, label);
                } else if (this.returnCondition == ReturnCondition.ON_NULL) {
                    inj.visitJumpInsn(199, label);
                } else if (this.returnCondition == ReturnCondition.ON_NOT_NULL) {
                    inj.visitJumpInsn(198, label);
                }
            }
            if (this.returnValue == ReturnValue.NULL) {
                inj.visitInsn(1);
            } else if (this.returnValue == ReturnValue.PRIMITIVE_CONSTANT) {
                inj.visitLdcInsn(this.primitiveConstant);
            } else if (this.returnValue == ReturnValue.HOOK_RETURN_VALUE) {
                inj.visitVarInsn(this.hookMethodReturnType.getOpcode(21), hookResultLocalId);
            } else if (this.returnValue == ReturnValue.ANOTHER_METHOD_RETURN_VALUE) {
                String returnMethodDescription = this.returnMethodDescription;
                if (returnMethodDescription.endsWith(")")) {
                    returnMethodDescription = returnMethodDescription + targetMethodReturnType.getDescriptor();
                }
                this.injectInvokeStatic(inj, returnLocalId, this.returnMethodName, returnMethodDescription);
            }
            this.injectReturn(inj, targetMethodReturnType);
            inj.visitLabel(label);
        }
        if (this.hasReturnValueParameter) {
            this.injectLoad(inj, targetMethodReturnType, returnLocalId);
        }
    }

    private boolean hasHookMethod() {
        return this.hookMethodName != null && this.hooksClassName != null;
    }

    private void injectInvokeStatic(HookInjectorMethodVisitor inj, int returnLocalId, String name, String desc) {
        for (int i2 = 0; i2 < this.hookMethodParameters.size(); ++i2) {
            Type parameterType = this.hookMethodParameters.get(i2);
            int variableId = this.transmittableVariableIds.get(i2);
            if (inj.isStatic) {
                if (variableId == 0) {
                    inj.visitInsn(1);
                    continue;
                }
                if (variableId > 0) {
                    --variableId;
                }
            }
            if (variableId == -1) {
                variableId = returnLocalId;
            }
            this.injectLoad(inj, parameterType, variableId);
        }
        inj.visitMethodInsn(184, this.getHookClassInternalName(), name, desc, false);
    }

    private String getHookClassInternalName() {
        return this.hooksClassName.replace('.', '/');
    }

    public String getPatchedMethodName() {
        return this.targetClassName + '#' + this.targetMethodName + this.targetMethodDescription;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("AsmHook: ");
        sb.append(this.targetClassName).append('#').append(this.targetMethodName);
        sb.append(this.targetMethodDescription);
        sb.append(" -> ");
        sb.append(this.hooksClassName).append('#').append(this.hookMethodName);
        sb.append(this.hookMethodDescription);
        sb.append(", ReturnCondition=").append((Object)this.returnCondition);
        sb.append(", ReturnValue=").append((Object)this.returnValue);
        if (this.returnValue == ReturnValue.PRIMITIVE_CONSTANT) {
            sb.append(", Constant=").append(this.primitiveConstant);
        }
        sb.append(", InjectorFactory: ").append(this.injectorFactory.getClass().getName());
        sb.append(", CreateMethod = ").append(this.createMethod);
        return sb.toString();
    }

    @Override
    public int compareTo(AsmHook o) {
        if (this.injectorFactory.isPriorityInverted && o.injectorFactory.isPriorityInverted) {
            return this.priority.ordinal() > o.priority.ordinal() ? -1 : 1;
        }
        if (!this.injectorFactory.isPriorityInverted && !o.injectorFactory.isPriorityInverted) {
            return this.priority.ordinal() > o.priority.ordinal() ? 1 : -1;
        }
        return this.injectorFactory.isPriorityInverted ? 1 : -1;
    }

    public class Builder
    extends AsmHook {
        private Builder() {
        }

        public Builder setTargetClass(String className) {
            AsmHook.this.targetClassName = className;
            return this;
        }

        public Builder setTargetMethod(String methodName) {
            AsmHook.this.targetMethodName = methodName;
            return this;
        }

        public Builder addTargetMethodParameters(String ... parameterTypeNames) {
            Type[] types = new Type[parameterTypeNames.length];
            for (int i2 = 0; i2 < parameterTypeNames.length; ++i2) {
                types[i2] = TypeHelper.getType(parameterTypeNames[i2]);
            }
            return this.addTargetMethodParameters(types);
        }

        public Builder addTargetMethodParameters(Type ... parameterTypes) {
            AsmHook.this.targetMethodParameters.addAll(Arrays.asList(parameterTypes));
            return this;
        }

        public Builder setTargetMethodReturnType(String returnType) {
            return this.setTargetMethodReturnType(TypeHelper.getType(returnType));
        }

        public Builder setTargetMethodReturnType(Type returnType) {
            AsmHook.this.targetMethodReturnType = returnType;
            return this;
        }

        public Builder setHookClass(String className) {
            AsmHook.this.hooksClassName = className;
            return this;
        }

        public Builder setHookMethod(String methodName) {
            AsmHook.this.hookMethodName = methodName;
            return this;
        }

        public Builder addHookMethodParameter(String parameterTypeName, int variableId) {
            return this.addHookMethodParameter(TypeHelper.getType(parameterTypeName), variableId);
        }

        public Builder addHookMethodParameter(Type parameterType, int variableId) {
            if (!AsmHook.this.hasHookMethod()) {
                throw new IllegalStateException("Hook method is not specified, so can not append parameter to its parameters list.");
            }
            AsmHook.this.hookMethodParameters.add(parameterType);
            AsmHook.this.transmittableVariableIds.add(variableId);
            return this;
        }

        public Builder addThisToHookMethodParameters() {
            if (!AsmHook.this.hasHookMethod()) {
                throw new IllegalStateException("Hook method is not specified, so can not append parameter to its parameters list.");
            }
            AsmHook.this.hookMethodParameters.add(TypeHelper.getType(AsmHook.this.targetClassName));
            AsmHook.this.transmittableVariableIds.add(0);
            return this;
        }

        public Builder addReturnValueToHookMethodParameters() {
            if (!AsmHook.this.hasHookMethod()) {
                throw new IllegalStateException("Hook method is not specified, so can not append parameter to its parameters list.");
            }
            if (AsmHook.this.targetMethodReturnType == Type.VOID_TYPE) {
                throw new IllegalStateException("Target method's return type is void, it does not make sense to transmit its return value to hook method.");
            }
            AsmHook.this.hookMethodParameters.add(AsmHook.this.targetMethodReturnType);
            AsmHook.this.transmittableVariableIds.add(-1);
            AsmHook.this.hasReturnValueParameter = true;
            return this;
        }

        public Builder setReturnCondition(ReturnCondition condition) {
            Type returnType;
            if (condition.requiresCondition && AsmHook.this.hookMethodName == null) {
                throw new IllegalArgumentException("Hook method is not specified, so can not use return condition that depends on hook method.");
            }
            AsmHook.this.returnCondition = condition;
            switch (condition) {
                case NEVER: 
                case ALWAYS: {
                    returnType = Type.VOID_TYPE;
                    break;
                }
                case ON_TRUE: {
                    returnType = Type.BOOLEAN_TYPE;
                    break;
                }
                default: {
                    returnType = Type.getType(Object.class);
                }
            }
            AsmHook.this.hookMethodReturnType = returnType;
            return this;
        }

        public Builder setReturnValue(ReturnValue value) {
            if (AsmHook.this.returnCondition == ReturnCondition.NEVER) {
                throw new IllegalStateException("Current return condition is ReturnCondition.NEVER, so it does not make sense to specify the return value.");
            }
            Type returnType = AsmHook.this.targetMethodReturnType;
            if (value != ReturnValue.VOID && returnType == Type.VOID_TYPE) {
                throw new IllegalArgumentException("Target method return value is void, so it does not make sense to return anything else.");
            }
            if (value == ReturnValue.VOID && returnType != Type.VOID_TYPE) {
                throw new IllegalArgumentException("Target method return value is not void, so it is impossible to return VOID.");
            }
            if (value == ReturnValue.PRIMITIVE_CONSTANT && returnType != null && !this.isPrimitive(returnType)) {
                throw new IllegalArgumentException("Target method return value is not a primitive, so it is impossible to return PRIVITIVE_CONSTANT.");
            }
            if (value == ReturnValue.NULL && returnType != null && this.isPrimitive(returnType)) {
                throw new IllegalArgumentException("Target method return value is a primitive, so it is impossible to return NULL.");
            }
            if (value == ReturnValue.HOOK_RETURN_VALUE && !AsmHook.this.hasHookMethod()) {
                throw new IllegalArgumentException("Hook method is not specified, so can not use return value that depends on hook method.");
            }
            AsmHook.this.returnValue = value;
            if (value == ReturnValue.HOOK_RETURN_VALUE) {
                AsmHook.this.hookMethodReturnType = AsmHook.this.targetMethodReturnType;
            }
            return this;
        }

        private boolean isPrimitive(Type type2) {
            return type2.getSort() > 0 && type2.getSort() < 9;
        }

        public Type getHookMethodReturnType() {
            return AsmHook.this.hookMethodReturnType;
        }

        protected void setHookMethodReturnType(Type type2) {
            AsmHook.this.hookMethodReturnType = type2;
        }

        public Builder setPrimitiveConstant(Object constant) {
            if (AsmHook.this.returnValue != ReturnValue.PRIMITIVE_CONSTANT) {
                throw new IllegalStateException("Return value is not PRIMITIVE_CONSTANT, so it does not make senceto specify that constant.");
            }
            Type returnType = AsmHook.this.targetMethodReturnType;
            if (returnType == Type.BOOLEAN_TYPE && !(constant instanceof Boolean) || returnType == Type.CHAR_TYPE && !(constant instanceof Character) || returnType == Type.BYTE_TYPE && !(constant instanceof Byte) || returnType == Type.SHORT_TYPE && !(constant instanceof Short) || returnType == Type.INT_TYPE && !(constant instanceof Integer) || returnType == Type.LONG_TYPE && !(constant instanceof Long) || returnType == Type.FLOAT_TYPE && !(constant instanceof Float) || returnType == Type.DOUBLE_TYPE && !(constant instanceof Double)) {
                throw new IllegalArgumentException("Given object class does not math target method return type.");
            }
            AsmHook.this.primitiveConstant = constant;
            return this;
        }

        public Builder setReturnMethod(String methodName) {
            if (AsmHook.this.returnValue != ReturnValue.ANOTHER_METHOD_RETURN_VALUE) {
                throw new IllegalStateException("Return value is not ANOTHER_METHOD_RETURN_VALUE, so it does not make sence to specify that method.");
            }
            AsmHook.this.returnMethodName = methodName;
            return this;
        }

        public Builder setInjectorFactory(HookInjectorFactory factory) {
            AsmHook.this.injectorFactory = factory;
            return this;
        }

        public Builder setIsStatic(boolean isStatic) {
            AsmHook.this.isStatic = isStatic;
            return this;
        }

        public Builder setIsAbstract(boolean isAbstract) {
            AsmHook.this.isAbstract = isAbstract;
            return this;
        }

        public Builder setSuperClass(String superClass) {
            AsmHook.this.superClass = superClass;
            return this;
        }

        public Builder setPriority(HookPriority priority) {
            AsmHook.this.priority = priority;
            return this;
        }

        public Builder setCreateMethod(boolean createMethod) {
            AsmHook.this.createMethod = createMethod;
            return this;
        }

        public Builder setMandatory(boolean isMandatory) {
            AsmHook.this.isMandatory = isMandatory;
            return this;
        }

        public AsmHook build() {
            AsmHook hook = AsmHook.this;
            if (hook.createMethod && hook.targetMethodReturnType == null) {
                hook.targetMethodReturnType = hook.hookMethodReturnType;
            }
            hook.targetMethodDescription = this.getMethodDesc(hook.targetMethodReturnType, hook.targetMethodParameters);
            if (hook.hasHookMethod()) {
                hook.hookMethodDescription = Type.getMethodDescriptor((Type)hook.hookMethodReturnType, (Type[])hook.hookMethodParameters.toArray(new Type[0]));
            }
            if (hook.returnValue == ReturnValue.ANOTHER_METHOD_RETURN_VALUE) {
                hook.returnMethodDescription = this.getMethodDesc(hook.targetMethodReturnType, hook.hookMethodParameters);
            }
            try {
                hook = (AsmHook)AsmHook.this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
            if (hook.targetClassName == null) {
                throw new IllegalStateException("Target class name is not specified. Call setTargetClassName() before build().");
            }
            if (hook.targetMethodName == null) {
                throw new IllegalStateException("Target method name is not specified. Call setTargetMethodName() before build().");
            }
            if (hook.returnValue == ReturnValue.PRIMITIVE_CONSTANT && hook.primitiveConstant == null) {
                throw new IllegalStateException("Return value is PRIMITIVE_CONSTANT, but the constant is not specified. Call setReturnValue() before build().");
            }
            if (hook.returnValue == ReturnValue.ANOTHER_METHOD_RETURN_VALUE && hook.returnMethodName == null) {
                throw new IllegalStateException("Return value is ANOTHER_METHOD_RETURN_VALUE, but the method is not specified. Call setReturnMethod() before build().");
            }
            if (!(hook.injectorFactory instanceof HookInjectorFactory.MethodExit) && hook.hasReturnValueParameter) {
                throw new IllegalStateException("Can not pass return value to hook method because hook location is not return insn.");
            }
            return hook;
        }

        private String getMethodDesc(Type returnType, List<Type> paramTypes) {
            Type[] paramTypesArray = paramTypes.toArray(new Type[0]);
            if (returnType == null) {
                String voidDesc = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])paramTypesArray);
                return voidDesc.substring(0, voidDesc.length() - 1);
            }
            return Type.getMethodDescriptor((Type)returnType, (Type[])paramTypesArray);
        }
    }
}

