/*
 * Decompiled with CFR 0.152.
 */
package gloomyfolken.hooklib.asm;

import alexsocol.patcher.PatcherConfigHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.logging.log4j.LogManager;

public interface HookLogger {
    public void trace(String var1);

    public void debug(String var1);

    public void warning(String var1);

    public void severe(String var1);

    public void severe(String var1, Throwable var2);

    default public void error(String message) {
        this.severe(message);
    }

    default public void error(String message, Throwable cause) {
        this.severe(message, cause);
    }

    public static class Log4JLogger
    implements HookLogger {
        private final org.apache.logging.log4j.Logger logger;

        public Log4JLogger(String loggerName) {
            this.logger = LogManager.getLogger((String)loggerName);
        }

        @Override
        public void trace(String message) {
            if (PatcherConfigHandler.INSTANCE.getLogTrace()) {
                this.logger.info(message);
            }
        }

        @Override
        public void debug(String message) {
            if (PatcherConfigHandler.INSTANCE.getLogDebug()) {
                this.logger.info(message);
            }
        }

        @Override
        public void warning(String message) {
            this.logger.warn(message);
        }

        @Override
        public void severe(String message) {
            this.logger.error(message);
        }

        @Override
        public void severe(String message, Throwable cause) {
            this.logger.error(message, cause);
        }
    }

    public static class VanillaLogger
    implements HookLogger {
        private Logger logger;

        public VanillaLogger(Logger logger) {
            this.logger = logger;
        }

        @Override
        public void trace(String message) {
            if (PatcherConfigHandler.INSTANCE.getLogTrace()) {
                this.logger.finest(message);
            }
        }

        @Override
        public void debug(String message) {
            if (PatcherConfigHandler.INSTANCE.getLogDebug()) {
                this.logger.fine(message);
            }
        }

        @Override
        public void warning(String message) {
            this.logger.warning(message);
        }

        @Override
        public void severe(String message) {
            this.logger.severe(message);
        }

        @Override
        public void severe(String message, Throwable cause) {
            this.logger.log(Level.SEVERE, message, cause);
        }
    }

    public static class SystemOutLogger
    implements HookLogger {
        @Override
        public void trace(String message) {
            if (PatcherConfigHandler.INSTANCE.getLogTrace()) {
                System.out.println("[TRACE] " + message);
            }
        }

        @Override
        public void debug(String message) {
            if (PatcherConfigHandler.INSTANCE.getLogDebug()) {
                System.out.println("[DEBUG] " + message);
            }
        }

        @Override
        public void warning(String message) {
            System.out.println("[WARNING] " + message);
        }

        @Override
        public void severe(String message) {
            System.out.println("[SEVERE] " + message);
        }

        @Override
        public void severe(String message, Throwable cause) {
            this.severe(message);
            cause.printStackTrace();
        }
    }
}

