/*
 * Decompiled with CFR 0.152.
 */
package ru.vamig.worldengine;

import alexsocol.patcher.PatcherConfigHandler;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.Loader;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.BiomeDictionary;
import ru.vamig.worldengine.WE_ChunkProvider;
import ru.vamig.worldengine.WE_PerlinNoise;
import ru.vamig.worldengine.additions.WE_CreateChunkGen_InXYZ;
import ru.vamig.worldengine.additions.WE_CreateChunkGen_InXZ;
import ru.vamig.worldengine.standardcustomgen.WE_BiomeLayer;
import ru.vamig.worldengine.standardcustomgen.WE_GrassGen;
import ru.vamig.worldengine.standardcustomgen.WE_LakeGen;
import ru.vamig.worldengine.standardcustomgen.WE_SnowGen;
import ru.vamig.worldengine.standardcustomgen.WE_WorldTreeGen;

public abstract class WE_Biome
extends BiomeGenBase {
    public static final HashMap<String, WE_Biome> biomeList = new HashMap();
    public final String serializationName;
    public final List<WE_CreateChunkGen_InXZ> createChunkGen_InXZ_List = new ArrayList<WE_CreateChunkGen_InXZ>();
    public final List<WE_CreateChunkGen_InXYZ> createChunkGen_InXYZ_List = new ArrayList<WE_CreateChunkGen_InXYZ>();
    public final List<IWorldGenerator> decorateChunkGen_List = new ArrayList<IWorldGenerator>();
    public int id;
    public double biomeMinValueOnMap = -1.0;
    public double biomeMaxValueOnMap = 1.0;
    public double biomePersistence = 1.0;
    public double biomeScaleX = 1.0;
    public double biomeScaleY = 1.0;
    public int biomeNumberOfOctaves = 1;
    public int biomeSurfaceHeight = 63;
    public int biomeInterpolateQuality = 16;
    public int grassColor = 9551193;
    public EnumSet<BiomeDictionary.Type> typeList = EnumSet.noneOf(BiomeDictionary.Type.class);

    public WE_Biome(double minMapValue, double maxMapValue, double persistence, int numOctaves, double sx, double sy, int height, int interpolateQuality) {
        this();
        this.biomeMinValueOnMap = minMapValue;
        this.biomeMaxValueOnMap = maxMapValue;
        this.biomePersistence = persistence;
        this.biomeNumberOfOctaves = numOctaves;
        this.biomeScaleX = sx;
        this.biomeScaleY = sy;
        this.biomeSurfaceHeight = height;
        this.biomeInterpolateQuality = interpolateQuality;
    }

    public WE_Biome() {
        super(PatcherConfigHandler.INSTANCE.getWEBiomeID(), false);
        this.setBiomeName("-=|World-Engine|=-");
        this.serializationName = Loader.instance().activeModContainer().getModId() + ":" + ((Object)((Object)this)).getClass().getName();
        biomeList.put(this.serializationName, this);
        WE_BiomeLayer standardBiomeLayers = new WE_BiomeLayer();
        standardBiomeLayers.add(Blocks.dirt, (byte)0, Blocks.stone, (byte)0, -256, 0, -4, -2, true);
        standardBiomeLayers.add((Block)Blocks.grass, (byte)0, Blocks.dirt, (byte)0, -256, 0, -256, 0, false);
        standardBiomeLayers.add(Blocks.bedrock, (byte)0, 0, 2, 0, 0, true);
        this.createChunkGen_InXZ_List.add(standardBiomeLayers);
        this.createChunkGen_InXZ_List.add(new WE_SnowGen());
        this.decorateChunkGen_List.add(new WE_LakeGen());
        WE_WorldTreeGen treeGen = new WE_WorldTreeGen();
        treeGen.add(Blocks.log, 0, (Block)Blocks.leaves, 0, Blocks.sapling, Blocks.vine, Blocks.cocoa, 8, 1, 8, 4, false, false, (byte)2, (byte)0, (byte)0, (byte)1, (byte)2, (byte)1, 1, 12, 4, 0.618, 0.381, 1.0, 1.0);
        this.decorateChunkGen_List.add(treeGen);
        WE_GrassGen grassGen = new WE_GrassGen();
        grassGen.add((Block)Blocks.tallgrass, (byte)1, 8, false, (Block)Blocks.grass, (byte)0);
        grassGen.add((Block)Blocks.tallgrass, (byte)2, 16, false, (Block)Blocks.grass, (byte)0);
        grassGen.add((Block)Blocks.red_flower, (byte)0, 128, false, (Block)Blocks.grass, (byte)0);
        grassGen.add((Block)Blocks.yellow_flower, (byte)0, 128, false, (Block)Blocks.grass, (byte)0);
        grassGen.add((Block)Blocks.deadbush, (byte)0, 512, false, (Block)Blocks.grass, (byte)0);
        grassGen.add(Blocks.waterlily, (byte)0, 256, false, Blocks.water, (byte)0);
        this.decorateChunkGen_List.add(grassGen);
    }

    public static void setBiomeMap(WE_ChunkProvider cp, double persistence, int numOctaves, double sx, double sy) {
        cp.biomemapPersistence = persistence;
        cp.biomemapNumberOfOctaves = numOctaves;
        cp.biomemapScaleX = sx;
        cp.biomemapScaleY = sy;
    }

    public static int addBiomeToGeneration(WE_ChunkProvider cp, WE_Biome biome) {
        if (biome.biomeMaxValueOnMap < biome.biomeMinValueOnMap) {
            double t = biome.biomeMaxValueOnMap;
            biome.biomeMaxValueOnMap = biome.biomeMinValueOnMap;
            biome.biomeMinValueOnMap = t;
        }
        cp.biomesList.add(biome);
        biome.id = cp.biomesList.size();
        if (cp.standardBiomeOnMap == null) {
            cp.standardBiomeOnMap = biome;
        }
        return biome.id;
    }

    public static WE_Biome getBiomeAt(WE_ChunkProvider cp, long x, long z) {
        return WE_Biome.getBiomeAt(cp, (int)x, (int)z);
    }

    public static WE_Biome getBiomeAt(WE_ChunkProvider cp, int x, int z) {
        WE_Biome biome;
        String biomeName;
        String[] stringArray;
        Chunk chunk = null;
        if (cp.world.blockExists(x, 0, z)) {
            chunk = cp.world.getChunkFromBlockCoords(x, z);
            stringArray = chunk.WorldEngine_SubBiomeList;
        } else {
            stringArray = null;
        }
        String[] biomes = stringArray;
        int biomeIndex = (x & 0xF) * 16 + (z & 0xF);
        if (chunk != null && biomes == null) {
            chunk.WorldEngine_SubBiomeList = new String[256];
        }
        if (biomes != null && (biomeName = biomes[biomeIndex]) != null && (biome = biomeList.get(biomeName)) != null) {
            return biome;
        }
        double biomeMapData = WE_PerlinNoise.PerlinNoise2D((long)Math.pow(cp.world.getSeed() * 84L, 6.0), (double)x / cp.biomemapScaleX, (double)z / cp.biomemapScaleX, cp.biomemapPersistence, cp.biomemapNumberOfOctaves) * cp.biomemapScaleY;
        WE_Biome r = null;
        for (int i2 = 0; i2 < cp.biomesList.size(); ++i2) {
            if (!(biomeMapData >= cp.biomesList.get((int)i2).biomeMinValueOnMap) || !(biomeMapData <= cp.biomesList.get((int)i2).biomeMaxValueOnMap)) continue;
            if (r != null) {
                if (!(cp.biomesList.get((int)i2).biomeMaxValueOnMap - cp.biomesList.get((int)i2).biomeMinValueOnMap < r.biomeMaxValueOnMap - r.biomeMinValueOnMap)) continue;
                r = cp.biomesList.get(i2);
                continue;
            }
            r = cp.biomesList.get(i2);
        }
        if (r == null) {
            r = cp.standardBiomeOnMap;
        }
        if (biomes != null) {
            biomes[biomeIndex] = r.serializationName;
        }
        return r;
    }

    public static int getBiggestInterpolationQuality(WE_ChunkProvider cp) {
        int r = 0;
        for (int i2 = 0; i2 < cp.biomesList.size(); ++i2) {
            if (cp.biomesList.get((int)i2).biomeInterpolateQuality <= r) continue;
            r = cp.biomesList.get((int)i2).biomeInterpolateQuality;
        }
        return r;
    }

    public WE_Biome clearSpawn() {
        this.spawnableCaveCreatureList.clear();
        this.spawnableCreatureList.clear();
        this.spawnableMonsterList.clear();
        this.spawnableWaterCreatureList.clear();
        return this;
    }

    public int getBiomeGrassColor(int R, int G, int B) {
        return this.grassColor;
    }

    public int getBiomeFoliageColor(int R, int G, int B) {
        return this.grassColor;
    }

    public boolean isEqualTo(BiomeGenBase biome) {
        return super.isEqualTo(biome);
    }
}

