/*
 * Decompiled with CFR 0.152.
 */
package ru.vamig.worldengine.standardcustomgen;

import cpw.mods.fml.common.IWorldGenerator;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenMinable;

public class WE_OreGenSphere
implements IWorldGenerator {
    public final List<Integer> fieldMinY = new ArrayList<Integer>();
    public final List<Integer> fieldMaxY = new ArrayList<Integer>();
    public final List<Integer> fieldMinRadius = new ArrayList<Integer>();
    public final List<Integer> fieldMaxRadius = new ArrayList<Integer>();
    public final List<Integer> oreInMaxFieldDensity = new ArrayList<Integer>();
    public final List<Integer> chunksForField = new ArrayList<Integer>();
    public final List<WorldGenMinable> oreGen = new ArrayList<WorldGenMinable>();

    public void add(Block oreBlock, byte oreBlockMeta, Block replacingBlock, int oreBlockCountInLode, int p_fieldMinY, int p_fieldMaxY, int p_fieldMinRadius, int p_fieldMaxRadius, int p_oreInMaxFieldDensity, int p_chunksForField) {
        this.oreGen.add(new WorldGenMinable(oreBlock, (int)oreBlockMeta, oreBlockCountInLode, replacingBlock));
        this.fieldMinY.add(p_fieldMinY);
        this.fieldMaxY.add(p_fieldMaxY);
        this.fieldMinRadius.add(p_fieldMinRadius);
        this.fieldMaxRadius.add(p_fieldMaxRadius);
        this.oreInMaxFieldDensity.add(p_oreInMaxFieldDensity);
        this.chunksForField.add(p_chunksForField);
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        for (int i2 = 0; i2 < this.oreGen.size(); ++i2) {
            if (random.nextInt(this.chunksForField.get(i2)) != 0) continue;
            float s = 360.0f / (float)this.oreInMaxFieldDensity.get(i2).intValue();
            int sy = this.fieldMinY.get(i2) + random.nextInt(this.fieldMaxY.get(i2) - this.fieldMinY.get(i2));
            int sx = chunkX * 16 + random.nextInt(16);
            int sz = chunkZ * 16 + random.nextInt(16);
            int r = this.fieldMinRadius.get(i2) + random.nextInt(this.fieldMaxRadius.get(i2) - this.fieldMinRadius.get(i2) + 1);
            for (float v = -90.0f; v <= 90.0f; v += s) {
                for (float h = 0.0f; h <= 359.0f; h += s) {
                    int rc = random.nextInt(r + 1);
                    float px = MathHelper.cos((float)(v * (float)Math.PI / 180.0f)) * MathHelper.sin((float)(h * (float)Math.PI / 180.0f));
                    float pz = MathHelper.cos((float)(v * (float)Math.PI / 180.0f)) * MathHelper.cos((float)(h * (float)Math.PI / 180.0f));
                    float py = MathHelper.sin((float)(v * (float)Math.PI / 180.0f));
                    this.oreGen.get(i2).generate(world, random, sx + MathHelper.floor_float((float)(px * (float)rc)), sy + MathHelper.floor_float((float)(py * (float)rc)), sz + MathHelper.floor_float((float)(pz * (float)rc)));
                }
            }
        }
    }
}

