/*
 * Decompiled with CFR 0.152.
 */
package alexsocol.asjlib.render;

import alexsocol.asjlib.ExtensionsClientKt;
import alexsocol.asjlib.ExtensionsKt;
import alexsocol.asjlib.math.BlockPos;
import alexsocol.asjlib.render.ASJShaderHelper;
import alexsocol.asjlib.render.RenderGlowingLayerBlock;
import com.google.common.collect.HashMultimap;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function6;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.event.RenderWorldEvent;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J@\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J(\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0003H\u0016J\b\u0010\u001f\u001a\u00020\u0003H\u0016J\u0010\u0010 \u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\"H\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0004\u001a\u00020\u00038G\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u001d\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006#"}, d2={"Lalexsocol/asjlib/render/RenderShaderBlock;", "Lcpw/mods/fml/client/registry/ISimpleBlockRenderingHandler;", "shaderId", "", "renderId", "<init>", "(II)V", "getShaderId", "()I", "getRenderIdProp", "cache", "Lcom/google/common/collect/HashMultimap;", "Lalexsocol/asjlib/math/BlockPos;", "getCache", "()Lcom/google/common/collect/HashMultimap;", "renderWorldBlock", "", "world", "Lnet/minecraft/world/IBlockAccess;", "x", "y", "z", "block", "Lnet/minecraft/block/Block;", "modelId", "renderer", "Lnet/minecraft/client/renderer/RenderBlocks;", "renderInventoryBlock", "", "metadata", "shouldRender3DInInventory", "getRenderId", "postRenderWorld", "e", "Lnet/minecraftforge/client/event/RenderWorldEvent$Post;", "1.7.10-ASJCore"})
@SourceDebugExtension(value={"SMAP\nRenderShaderBlock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RenderShaderBlock.kt\nalexsocol/asjlib/render/RenderShaderBlock\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,100:1\n1869#2,2:101\n*S KotlinDebug\n*F\n+ 1 RenderShaderBlock.kt\nalexsocol/asjlib/render/RenderShaderBlock\n*L\n75#1:101,2\n*E\n"})
public final class RenderShaderBlock
implements ISimpleBlockRenderingHandler {
    private final int shaderId;
    private final int renderId;
    @NotNull
    private final HashMultimap<Integer, BlockPos> cache;

    public RenderShaderBlock(int shaderId, int renderId) {
        this.shaderId = shaderId;
        this.renderId = renderId;
        HashMultimap hashMultimap = HashMultimap.create();
        Intrinsics.checkNotNullExpressionValue((Object)hashMultimap, (String)"create(...)");
        this.cache = hashMultimap;
        ExtensionsKt.eventForge(this);
    }

    public final int getShaderId() {
        return this.shaderId;
    }

    @JvmName(name="getRenderIdProp")
    public final int getRenderIdProp() {
        return this.renderId;
    }

    @NotNull
    public final HashMultimap<Integer, BlockPos> getCache() {
        return this.cache;
    }

    public boolean renderWorldBlock(@NotNull IBlockAccess world, int x, int y, int z, @NotNull Block block, int modelId, @NotNull RenderBlocks renderer) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        Intrinsics.checkNotNullParameter((Object)renderer, (String)"renderer");
        this.cache.put((Object)block.getRenderBlockPass(), (Object)new BlockPos(block, x, y, z));
        return true;
    }

    public void renderInventoryBlock(@NotNull Block block, int metadata, int modelId, @NotNull RenderBlocks renderer) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        Intrinsics.checkNotNullParameter((Object)renderer, (String)"renderer");
        Tessellator tes = Tessellator.instance;
        block.setBlockBoundsForItemRender();
        renderer.setRenderBoundsFromBlock(block);
        ExtensionsClientKt.glTranslatef(-0.5f);
        ASJShaderHelper.useShader$default(ASJShaderHelper.INSTANCE, this.shaderId, null, 2, null);
        tes.startDrawingQuads();
        tes.setNormal(0.0f, -1.0f, 0.0f);
        renderer.renderFaceYNeg(block, 0.0, 0.0, 0.0, renderer.getBlockIconFromSideAndMetadata(block, 0, metadata));
        tes.setNormal(0.0f, 1.0f, 0.0f);
        renderer.renderFaceYPos(block, 0.0, 0.0, 0.0, renderer.getBlockIconFromSideAndMetadata(block, 1, metadata));
        tes.setNormal(0.0f, 0.0f, -1.0f);
        renderer.renderFaceZNeg(block, 0.0, 0.0, 0.0, renderer.getBlockIconFromSideAndMetadata(block, 2, metadata));
        tes.setNormal(0.0f, 0.0f, 1.0f);
        renderer.renderFaceZPos(block, 0.0, 0.0, 0.0, renderer.getBlockIconFromSideAndMetadata(block, 3, metadata));
        tes.setNormal(-1.0f, 0.0f, 0.0f);
        renderer.renderFaceXNeg(block, 0.0, 0.0, 0.0, renderer.getBlockIconFromSideAndMetadata(block, 4, metadata));
        tes.setNormal(1.0f, 0.0f, 0.0f);
        renderer.renderFaceXPos(block, 0.0, 0.0, 0.0, renderer.getBlockIconFromSideAndMetadata(block, 5, metadata));
        tes.draw();
        ASJShaderHelper.INSTANCE.releaseShader();
        ExtensionsClientKt.glTranslatef(0.5f);
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return true;
    }

    public int getRenderId() {
        return this.renderId;
    }

    @SubscribeEvent
    public final void postRenderWorld(@NotNull RenderWorldEvent.Post e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (this.cache.isEmpty()) {
            return;
        }
        Set set = this.cache.get((Object)e.pass);
        if (set == null) {
            return;
        }
        Set passCache = set;
        if (passCache.isEmpty()) {
            return;
        }
        ASJShaderHelper.useShader$default(ASJShaderHelper.INSTANCE, this.shaderId, null, 2, null);
        Tessellator tes = Tessellator.instance;
        tes.startDrawingQuads();
        Intrinsics.checkNotNullExpressionValue((Object)ForgeDirection.VALID_DIRECTIONS, (String)"VALID_DIRECTIONS");
        Iterable dirs = ArraysKt.withIndex((Object[])ForgeDirection.VALID_DIRECTIONS);
        Iterable $this$forEach$iv = passCache;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BlockPos blockPos = (BlockPos)element$iv;
            boolean bl = false;
            Block block = blockPos.component1();
            int x = blockPos.component2();
            int y = blockPos.component3();
            int z = blockPos.component4();
            e.renderBlocks.setRenderBoundsFromBlock(block);
            for (IndexedValue indexedValue : dirs) {
                int side = indexedValue.component1();
                ForgeDirection d = (ForgeDirection)indexedValue.component2();
                if (!block.shouldSideBeRendered((IBlockAccess)e.renderer.worldObj, x + d.offsetX, y + d.offsetY, z + d.offsetZ, side)) continue;
                switch (side) {
                    case 0: {
                        tes.setNormal(0.0f, -1.0f, 0.0f);
                        break;
                    }
                    case 1: {
                        tes.setNormal(0.0f, 1.0f, 0.0f);
                        break;
                    }
                    case 2: {
                        tes.setNormal(0.0f, 0.0f, -1.0f);
                        break;
                    }
                    case 3: {
                        tes.setNormal(0.0f, 0.0f, 1.0f);
                        break;
                    }
                    case 4: {
                        tes.setNormal(-1.0f, 0.0f, 0.0f);
                        break;
                    }
                    case 5: {
                        tes.setNormal(1.0f, 0.0f, 0.0f);
                    }
                }
                Function6 function6 = (Function6)RenderGlowingLayerBlock.Companion.getRenderers()[side];
                RenderBlocks renderBlocks = e.renderBlocks;
                Intrinsics.checkNotNullExpressionValue((Object)renderBlocks, (String)"renderBlocks");
                function6.invoke((Object)renderBlocks, (Object)block, (Object)ExtensionsKt.getD(x), (Object)ExtensionsKt.getD(y), (Object)ExtensionsKt.getD(z), (Object)e.renderBlocks.getBlockIcon(block, e.renderBlocks.blockAccess, x, y, z, side));
            }
        }
        tes.draw();
        ASJShaderHelper.INSTANCE.releaseShader();
        passCache.clear();
        this.cache.removeAll((Object)e.pass);
    }
}

