/*
 * Decompiled with CFR 0.152.
 */
package ru.vamig.worldengine;

import alexsocol.patcher.PatcherConfigHandler;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.ChunkProviderGenerate;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import ru.vamig.worldengine.WE_Biome;
import ru.vamig.worldengine.WE_WorldProvider;
import ru.vamig.worldengine.additions.WE_ChunkSmartLight;
import ru.vamig.worldengine.additions.WE_CreateChunkGen;
import ru.vamig.worldengine.additions.WE_CreateChunkGen_InXYZ;
import ru.vamig.worldengine.additions.WE_CreateChunkGen_InXZ;
import ru.vamig.worldengine.additions.WE_GeneratorData;
import ru.vamig.worldengine.standardcustomgen.WE_CaveGen;
import ru.vamig.worldengine.standardcustomgen.WE_LakeGen;
import ru.vamig.worldengine.standardcustomgen.WE_OreGenSphere;
import ru.vamig.worldengine.standardcustomgen.WE_RavineGen;
import ru.vamig.worldengine.standardcustomgen.WE_TerrainGenerator;

public class WE_ChunkProvider
extends ChunkProviderGenerate {
    public final World world;
    public final Random rand;
    public final List<WE_CreateChunkGen> createChunkGen_List = new ArrayList<WE_CreateChunkGen>();
    public final List<WE_CreateChunkGen_InXZ> createChunkGen_InXZ_List = new ArrayList<WE_CreateChunkGen_InXZ>();
    public final List<WE_CreateChunkGen_InXYZ> createChunkGen_InXYZ_List = new ArrayList<WE_CreateChunkGen_InXYZ>();
    public final List<IWorldGenerator> decorateChunkGen_List = new ArrayList<IWorldGenerator>();
    public final List<WE_Biome> biomesList = new ArrayList<WE_Biome>();
    public WE_Biome standardBiomeOnMap;
    public double biomemapPersistence = 1.0;
    public double biomemapScaleX = 1.0;
    public double biomemapScaleY = 1.0;
    public int biomemapNumberOfOctaves = 1;

    public WE_ChunkProvider(WE_WorldProvider wp) {
        super(wp.worldObj, wp.getSeed(), wp.worldObj.getWorldInfo().isMapFeaturesEnabled());
        this.world = wp.worldObj;
        this.rand = new Random(wp.getSeed());
        this.createChunkGen_List.add(new WE_TerrainGenerator());
        this.createChunkGen_List.add(new WE_CaveGen());
        this.createChunkGen_List.add(new WE_RavineGen());
        WE_OreGenSphere standardOres = new WE_OreGenSphere();
        standardOres.add(Blocks.gold_ore, (byte)0, Blocks.stone, 4, 0, 32, 4, 24, 45, 16);
        standardOres.add(Blocks.iron_ore, (byte)0, Blocks.stone, 6, 0, 64, 8, 32, 90, 72);
        standardOres.add(Blocks.coal_ore, (byte)0, Blocks.stone, 6, 32, 128, 16, 48, 60, 56);
        standardOres.add(Blocks.lapis_ore, (byte)0, Blocks.stone, 4, 0, 16, 8, 24, 30, 16);
        standardOres.add(Blocks.diamond_ore, (byte)0, Blocks.stone, 3, 0, 16, 4, 24, 45, 16);
        standardOres.add(Blocks.emerald_ore, (byte)0, Blocks.stone, 2, 0, 16, 4, 24, 45, 24);
        this.decorateChunkGen_List.add(standardOres);
        WE_LakeGen lavaLakes = new WE_LakeGen();
        lavaLakes.lakeBlock = Blocks.lava;
        lavaLakes.fGen = false;
        lavaLakes.maxY = 32;
        this.decorateChunkGen_List.add(lavaLakes);
        wp.genSettings(this);
    }

    public Chunk provideChunk(int chunkX, int chunkZ) {
        long chunk_X = (long)chunkX * 16L;
        long chunk_Z = (long)chunkZ * 16L;
        Block[] chunkBlocks = new Block[65536];
        byte[] chunkBlocksMeta = new byte[65536];
        this.rand.setSeed(this.world.getSeed() * (long)Math.pow(chunkX, 3.0) + (long)Math.pow(chunkZ, 2.0) * 9874L + 7684053L);
        WE_Biome[][] chunkBiomes = new WE_Biome[16][16];
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                chunkBiomes[x][z] = WE_Biome.getBiomeAt(this, chunk_X + (long)x, chunk_Z + (long)z);
            }
        }
        for (WE_CreateChunkGen we_createChunkGen : this.createChunkGen_List) {
            we_createChunkGen.gen(new WE_GeneratorData(this, chunkBlocks, chunkBlocksMeta, chunk_X, chunk_Z, chunkBiomes, 0, 0, 0));
        }
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                for (WE_CreateChunkGen_InXZ we_createChunkGen_inXZ : this.createChunkGen_InXZ_List) {
                    we_createChunkGen_inXZ.gen(new WE_GeneratorData(this, chunkBlocks, chunkBlocksMeta, chunk_X, chunk_Z, chunkBiomes, x, 0, z));
                }
                for (int i2 = 0; i2 < chunkBiomes[x][z].createChunkGen_InXZ_List.size(); ++i2) {
                    chunkBiomes[x][z].createChunkGen_InXZ_List.get(i2).gen(new WE_GeneratorData(this, chunkBlocks, chunkBlocksMeta, chunk_X, chunk_Z, chunkBiomes, x, 0, z));
                }
                for (int y = 255; y >= 0; --y) {
                    for (WE_CreateChunkGen_InXYZ we_createChunkGen_inXYZ : this.createChunkGen_InXYZ_List) {
                        we_createChunkGen_inXYZ.gen(new WE_GeneratorData(this, chunkBlocks, chunkBlocksMeta, chunk_X, chunk_Z, chunkBiomes, x, y, z));
                    }
                    for (int i3 = 0; i3 < chunkBiomes[x][z].createChunkGen_InXYZ_List.size(); ++i3) {
                        chunkBiomes[x][z].createChunkGen_InXYZ_List.get(i3).gen(new WE_GeneratorData(this, chunkBlocks, chunkBlocksMeta, chunk_X, chunk_Z, chunkBiomes, x, y, z));
                    }
                }
            }
        }
        WE_ChunkSmartLight chunk = PatcherConfigHandler.INSTANCE.getWECustomLighting() ? new WE_ChunkSmartLight(this.world, chunkBlocks, chunkBlocksMeta, chunkX, chunkZ) : new Chunk(this.world, chunkBlocks, chunkBlocksMeta, chunkX, chunkZ);
        chunk.generateSkylightMap();
        return chunk;
    }

    public void populate(IChunkProvider chunkProvider, int chunkX, int chunkZ) {
        BlockFalling.fallInstantly = true;
        this.rand.setSeed(this.world.getSeed() * (long)chunkX + (long)Math.pow(chunkZ, 2.0) * 107L + 2394720L);
        MinecraftForge.EVENT_BUS.post((Event)new PopulateChunkEvent.Pre(chunkProvider, this.world, this.rand, chunkX, chunkZ, false));
        for (IWorldGenerator iWorldGenerator : this.decorateChunkGen_List) {
            iWorldGenerator.generate(this.rand, chunkX, chunkZ, this.world, (IChunkProvider)this, (IChunkProvider)this);
        }
        WE_Biome b = WE_Biome.getBiomeAt(this, (long)chunkX * 16L + (long)this.rand.nextInt(16), (long)chunkZ * 16L + (long)this.rand.nextInt(16));
        for (int i2 = 0; i2 < b.decorateChunkGen_List.size(); ++i2) {
            b.decorateChunkGen_List.get(i2).generate(this.rand, chunkX, chunkZ, this.world, (IChunkProvider)this, (IChunkProvider)this);
        }
        MinecraftForge.EVENT_BUS.post((Event)new PopulateChunkEvent.Post(chunkProvider, this.world, this.rand, chunkX, chunkZ, false));
        BlockFalling.fallInstantly = false;
    }

    public List<BiomeGenBase.SpawnListEntry> getPossibleCreatures(EnumCreatureType type2, int x, int y, int z) {
        WE_Biome b = WE_Biome.getBiomeAt(this, x, z);
        return b.getSpawnableList(type2);
    }

    public void genSetBlock(Block[] chunkBlocks, byte[] chunkBlocksMeta, int x, int y, int z, Block block, byte meta) {
        if (x >= 0 && x <= 15 && y >= 0 && y <= 255 && z >= 0 && z <= 15) {
            int i2 = (x * 16 + z) * 256 + y;
            chunkBlocks[i2] = block;
            chunkBlocksMeta[i2] = meta;
        }
    }

    public Block genReturnBlock(Block[] chunkBlocks, int x, int y, int z) {
        if (x >= 0 && x <= 15 && y >= 0 && y <= 255 && z >= 0 && z <= 15) {
            return chunkBlocks[(x * 16 + z) * 256 + y];
        }
        return null;
    }

    public byte genReturnBlockMeta(byte[] chunkBlocksMeta, int x, int y, int z) {
        if (x >= 0 && x <= 15 && y >= 0 && y <= 255 && z >= 0 && z <= 15) {
            return chunkBlocksMeta[(x * 16 + z) * 256 + y];
        }
        return 0;
    }

    public ChunkPosition func_147416_a(World world, String structure, int x, int y, int z) {
        return null;
    }

    public void recreateStructures(int chunkX, int chunkZ) {
    }
}

