/*
 * Decompiled with CFR 0.152.
 */
package ru.vamig.worldengine.standardcustomgen;

import cpw.mods.fml.common.IWorldGenerator;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenMinable;

public class WE_OreGen
implements IWorldGenerator {
    public final List<WorldGenMinableParametrized> oreGen = new ArrayList<WorldGenMinableParametrized>();

    public void add(Block ore, Block replace, int meta, int minVeinSize, int maxVeinSize, int minVeinsPerChunk, int maxVeinsPerChunk, int chanceToSpawn, int minY, int maxY) {
        this.oreGen.add(new WorldGenMinableParametrized(ore, replace, meta, minVeinSize, maxVeinSize, minVeinsPerChunk, maxVeinsPerChunk, chanceToSpawn, minY, maxY));
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        for (WorldGenMinableParametrized wgmp : this.oreGen) {
            if (random.nextInt(101) < 100 - wgmp.chanceToSpawn) continue;
            int veins = WE_OreGen.randInBounds(wgmp.minVeinsPerChunk, wgmp.maxVeinsPerChunk, random);
            for (int i2 = 0; i2 < veins; ++i2) {
                int posX = chunkX * 16 + random.nextInt(16) + 8;
                int posY = WE_OreGen.randInBounds(wgmp.minY, wgmp.maxY, random);
                int posZ = chunkZ * 16 + random.nextInt(16) + 8;
                new WorldGenMinable(wgmp.ore, wgmp.meta, WE_OreGen.randInBounds(wgmp.minVeinSize, wgmp.maxVeinSize, random), wgmp.replace).generate(world, random, posX, posY, posZ);
            }
        }
    }

    public static int randInBounds(int min, int max, Random rand) {
        return rand.nextInt(max - min + 1) + min;
    }

    public static class WorldGenMinableParametrized {
        public final Block ore;
        public final Block replace;
        public final int meta;
        public final int minVeinSize;
        public final int maxVeinSize;
        public final int minVeinsPerChunk;
        public final int maxVeinsPerChunk;
        public final int chanceToSpawn;
        public final int minY;
        public final int maxY;

        public WorldGenMinableParametrized(Block ore, Block replace, int meta, int minVeinSize, int maxVeinSize, int minVeinsPerChunk, int maxVeinsPerChunk, int chanceToSpawn, int minY, int maxY) {
            this.ore = ore;
            this.meta = meta;
            this.replace = replace;
            this.minVeinSize = minVeinSize;
            this.maxVeinSize = maxVeinSize;
            this.minVeinsPerChunk = minVeinsPerChunk;
            this.maxVeinsPerChunk = maxVeinsPerChunk;
            this.chanceToSpawn = chanceToSpawn;
            this.minY = minY;
            this.maxY = maxY;
        }
    }
}

