/*
 * Decompiled with CFR 0.152.
 */
package org.redlance.dima_dencep.mods.rrls.mixins;

import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.FocusableTextWidget;
import net.minecraft.client.gui.screens.LoadingOverlay;
import net.minecraft.client.gui.screens.Overlay;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.resources.ReloadInstance;
import org.redlance.dima_dencep.mods.rrls.ConfigExpectPlatform;
import org.redlance.dima_dencep.mods.rrls.config.Type;
import org.redlance.dima_dencep.mods.rrls.utils.DummyGuiGraphics;
import org.redlance.dima_dencep.mods.rrls.utils.OverlayHelper;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LoadingOverlay.class})
public abstract class LoadingOverlayMixin
extends Overlay {
    @Shadow
    @Final
    private Minecraft minecraft;
    @Unique
    private FocusableTextWidget rrls$textWidget;

    @Shadow
    protected abstract void drawProgressBar(GuiGraphics var1, int var2, int var3, int var4, int var5, float var6);

    @Shadow
    private static int replaceAlpha(int color, int alpha) {
        return 0;
    }

    @Inject(method={"<init>(Lnet/minecraft/client/Minecraft;Lnet/minecraft/server/packs/resources/ReloadInstance;Ljava/util/function/Consumer;Z)V"}, at={@At(value="TAIL")})
    private void rrls$init(Minecraft client, ReloadInstance reload, Consumer<Optional<Throwable>> onFinish, boolean fadeIn, CallbackInfo ci) {
        this.rrls$setState(OverlayHelper.lookupState(client.screen, fadeIn));
        if (ConfigExpectPlatform.type() == Type.TEXT_WITH_BACKGROUND) {
            this.rrls$textWidget = new FocusableTextWidget(1, (Component)Component.literal((String)ConfigExpectPlatform.reloadText()), this.minecraft.font, 12);
        }
    }

    public void rrls$miniRender(GuiGraphics graphics) {
        int i = graphics.guiWidth();
        int j = graphics.guiHeight();
        switch (ConfigExpectPlatform.type()) {
            case PROGRESS: {
                int s = (int)((double)j * 0.8325);
                int r = (int)(Math.min((double)i * 0.75, (double)j) * 0.5);
                this.drawProgressBar(graphics, i / 2 - r, s - 5, i / 2 + r, s + 5, 0.8f);
                break;
            }
            case TEXT: {
                graphics.drawCenteredString(this.minecraft.font, ConfigExpectPlatform.reloadText(), i / 2, 70, ConfigExpectPlatform.rgbProgress() ? ThreadLocalRandom.current().nextInt(0, 0xFFFFFF) : -1);
                break;
            }
            case TEXT_WITH_BACKGROUND: {
                if (this.rrls$textWidget == null) break;
                this.rrls$textWidget.setMaxWidth(i);
                this.rrls$textWidget.setX(i / 2 - this.rrls$textWidget.getWidth() / 2);
                this.rrls$textWidget.setY(j - j / 3);
                if (ConfigExpectPlatform.rgbProgress()) {
                    this.rrls$textWidget.setColor(ThreadLocalRandom.current().nextInt(0, 0xFFFFFF));
                }
                graphics.pose().pushPose();
                graphics.pose().translate(0.0f, 0.0f, 255.0f);
                this.rrls$textWidget.render(graphics, 0, 0, 0.0f);
                graphics.pose().popPose();
            }
        }
    }

    @Inject(method={"render(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/Minecraft;setOverlay(Lnet/minecraft/client/gui/screens/Overlay;)V")})
    public void rrls$onLoadDone(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick, CallbackInfo ci) {
        this.rrls$textWidget = null;
    }

    @Inject(method={"render(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"}, at={@At(value="HEAD")})
    public void rrls$render(GuiGraphics context, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        if (this.rrls$getState() != OverlayHelper.State.DEFAULT) {
            this.rrls$setState(OverlayHelper.lookupState(this.minecraft.screen, this.rrls$getState() != OverlayHelper.State.WAIT));
        }
    }

    @WrapWithCondition(method={"render(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/Screen;render(Lnet/minecraft/client/gui/GuiGraphics;IIF)V")})
    public boolean rrls$screenrender(Screen instance, GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        return !(graphics instanceof DummyGuiGraphics);
    }

    @WrapWithCondition(method={"render(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/Minecraft;setOverlay(Lnet/minecraft/client/gui/screens/Overlay;)V")})
    public boolean rrls$infinityLoading(Minecraft instance, Overlay overlay) {
        return ConfigExpectPlatform.removeOverlayAtEnd();
    }

    @WrapWithCondition(method={"render(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/Screen;init(Lnet/minecraft/client/Minecraft;II)V")})
    public boolean rrls$reinitScreen(Screen instance, Minecraft minecraft, int width, int height) {
        return ConfigExpectPlatform.reInitScreen();
    }

    @WrapOperation(method={"render(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/platform/GlStateManager;_clear(IZ)V", remap=false)})
    public void rrls$_clear(int mask, boolean getError, Operation<Void> original) {
        if (!this.rrls$getState().isRendering()) {
            original.call(new Object[]{mask, getError});
        }
    }

    @WrapOperation(method={"render(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/platform/GlStateManager;_clearColor(FFFF)V", remap=false)})
    public void rrls$_clearColor(float red, float green, float blue, float alpha, Operation<Void> original) {
        if (!this.rrls$getState().isRendering()) {
            original.call(new Object[]{Float.valueOf(red), Float.valueOf(green), Float.valueOf(blue), Float.valueOf(alpha)});
        }
    }

    @WrapOperation(method={"drawProgressBar(Lnet/minecraft/client/gui/GuiGraphics;IIIIF)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/util/FastColor$ARGB32;color(IIII)I")})
    public int rrls$rainbowProgress(int alpha, int red, int green, int blue, Operation<Integer> original) {
        if (ConfigExpectPlatform.rgbProgress() && this.rrls$getState() != OverlayHelper.State.DEFAULT) {
            return LoadingOverlayMixin.replaceAlpha(ThreadLocalRandom.current().nextInt(0, 0xFFFFFF), alpha);
        }
        return (Integer)original.call(new Object[]{alpha, red, green, blue});
    }

    @ModifyConstant(method={"render(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"}, constant={@Constant(floatValue=1000.0f, ordinal=0)}, require=0)
    public float rrls$changeAnimationSpeed(float instance) {
        if (!this.rrls$getState().isRendering()) {
            return ConfigExpectPlatform.animationSpeed();
        }
        return instance;
    }

    public boolean isPauseScreen() {
        return super.isPauseScreen();
    }
}

