/*
 * Decompiled with CFR 0.152.
 */
package org.redlance.dima_dencep.mods.rrls.mixins;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Overlay;
import net.minecraft.client.main.GameConfig;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;
import org.redlance.dima_dencep.mods.rrls.ConfigExpectPlatform;
import org.redlance.dima_dencep.mods.rrls.Rrls;
import org.redlance.dima_dencep.mods.rrls.config.DoubleLoad;
import org.redlance.dima_dencep.mods.rrls.utils.OverlayHelper;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Minecraft.class})
public abstract class MinecraftClientMixin {
    @Shadow
    private boolean gameLoadFinished;

    @Shadow
    protected abstract void addResourcePackLoadFailToast(@Nullable Component var1);

    @Shadow
    protected abstract CompletableFuture<Void> reloadResourcePacks(boolean var1, @Nullable Minecraft.GameLoadCookie var2);

    @Shadow
    protected abstract void onResourceLoadFinished(@Nullable Minecraft.GameLoadCookie var1);

    @Inject(method={"<init>(Lnet/minecraft/client/main/GameConfig;)V"}, at={@At(value="TAIL")})
    public void rrls$init(GameConfig gameConfig, CallbackInfo ci, @Local(ordinal=0) Minecraft.GameLoadCookie gameLoadCookie) {
        if (!ConfigExpectPlatform.hideType().forceClose()) {
            return;
        }
        try {
            this.onResourceLoadFinished(gameLoadCookie);
        }
        catch (Throwable th) {
            Rrls.LOGGER.error("Failed to complete load early!", th);
            this.gameLoadFinished = false;
        }
    }

    @WrapWithCondition(method={"onGameLoadFinished(Lnet/minecraft/client/Minecraft$GameLoadCookie;)V"}, at={@At(value="INVOKE", target="Ljava/lang/Runnable;run()V")})
    public boolean rrls$fixDH(Runnable instance) {
        instance.run();
        return false;
    }

    @Inject(method={"clearResourcePacksOnError(Ljava/lang/Throwable;Lnet/minecraft/network/chat/Component;Lnet/minecraft/client/Minecraft$GameLoadCookie;)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void rrls$onResourceReloadFailure(Throwable throwable, Component errorMessage, Minecraft.GameLoadCookie gameLoadCookie, CallbackInfo ci) {
        if (!ConfigExpectPlatform.resetResources()) {
            ci.cancel();
            Rrls.LOGGER.error("Caught error loading resourcepacks!", throwable);
            if (ConfigExpectPlatform.doubleLoad().isLoad()) {
                this.reloadResourcePacks(ConfigExpectPlatform.doubleLoad() == DoubleLoad.FORCE_LOAD, gameLoadCookie).thenRun(() -> this.addResourcePackLoadFailToast(errorMessage));
            }
        }
    }

    @Inject(method={"clearResourcePacksOnError(Ljava/lang/Throwable;Lnet/minecraft/network/chat/Component;Lnet/minecraft/client/Minecraft$GameLoadCookie;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/Minecraft;reloadResourcePacks(ZLnet/minecraft/client/Minecraft$GameLoadCookie;)Ljava/util/concurrent/CompletableFuture;", shift=At.Shift.BEFORE)}, cancellable=true)
    public void rrls$doubleLoad(Throwable throwable, Component errorMessage, Minecraft.GameLoadCookie gameLoadCookie, CallbackInfo ci) {
        if (!ConfigExpectPlatform.doubleLoad().isLoad()) {
            ci.cancel();
        }
    }

    @ModifyArg(method={"clearResourcePacksOnError(Ljava/lang/Throwable;Lnet/minecraft/network/chat/Component;Lnet/minecraft/client/Minecraft$GameLoadCookie;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/Minecraft;reloadResourcePacks(ZLnet/minecraft/client/Minecraft$GameLoadCookie;)Ljava/util/concurrent/CompletableFuture;", ordinal=0), require=0)
    public boolean rrls$doubleLoad(boolean error) {
        return ConfigExpectPlatform.doubleLoad() == DoubleLoad.FORCE_LOAD;
    }

    @WrapOperation(method={"tick()V", "handleKeybinds()V", "doWorldLoad(Lnet/minecraft/world/level/storage/LevelStorageSource$LevelStorageAccess;Lnet/minecraft/server/packs/repository/PackRepository;Lnet/minecraft/server/WorldStem;Z)V"}, at={@At(value="FIELD", target="Lnet/minecraft/client/Minecraft;overlay:Lnet/minecraft/client/gui/screens/Overlay;")})
    public Overlay rrls$miniRender(Minecraft instance, Operation<Overlay> original) {
        Overlay overlay = (Overlay)original.call(new Object[]{instance});
        if (OverlayHelper.isRenderingState(overlay)) {
            return null;
        }
        return overlay;
    }

    @ModifyReturnValue(method={"getOverlay()Lnet/minecraft/client/gui/screens/Overlay;"}, at={@At(value="RETURN")})
    public Overlay rrls$blockOverlay(Overlay original) {
        if (ConfigExpectPlatform.blockOverlay() && OverlayHelper.isRenderingState(original)) {
            return null;
        }
        return original;
    }
}

