/*
 * Decompiled with CFR 0.152.
 */
package org.redlance.dima_dencep.mods.rrls.mixins.workaround;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiSpriteManager;
import net.minecraft.client.gui.font.FontManager;
import net.minecraft.client.resources.SplashManager;
import net.minecraft.client.resources.language.LanguageManager;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.CloseableResourceManager;
import net.minecraft.server.packs.resources.MultiPackResourceManager;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ReloadInstance;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.Unit;
import net.minecraft.util.profiling.InactiveProfiler;
import net.minecraft.util.profiling.ProfilerFiller;
import org.redlance.dima_dencep.mods.rrls.ConfigExpectPlatform;
import org.redlance.dima_dencep.mods.rrls.Rrls;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ReloadableResourceManager.class})
public class ReloadableResourceManagerMixin {
    @Shadow
    private CloseableResourceManager resources;
    @Unique
    private static final Minecraft RRLS$MINECRAFT = Minecraft.getInstance();
    @Unique
    private final List<PreparableReloadListener> rrls$listeners = Lists.newArrayList();

    @Inject(method={"registerReloadListener(Lnet/minecraft/server/packs/resources/PreparableReloadListener;)V"}, at={@At(value="TAIL")})
    public void rrls$initReloader(PreparableReloadListener listener, CallbackInfo ci) {
        LanguageManager languageManager;
        if (!ConfigExpectPlatform.hideType().forceClose()) {
            return;
        }
        if (listener instanceof FontManager) {
            FontManager fontManager = (FontManager)listener;
            if (!fontManager.fontSets.containsKey(Minecraft.DEFAULT_FONT)) {
                this.rrls$reloadListener((PreparableReloadListener)fontManager, (Executor)RRLS$MINECRAFT, (unused, throwable) -> this.rrls$refreshScreen());
            }
        }
        if (listener instanceof LanguageManager && (languageManager = (LanguageManager)listener).getLanguages().size() <= 1) {
            this.rrls$reloadListener((PreparableReloadListener)languageManager, Util.backgroundExecutor(), (unused, throwable) -> {});
        }
        if (listener instanceof SplashManager) {
            SplashManager splashManager = (SplashManager)listener;
            if (splashManager.splashes.isEmpty()) {
                this.rrls$reloadListener((PreparableReloadListener)splashManager, Util.backgroundExecutor(), (unused, throwable) -> this.rrls$refreshScreen());
            }
        }
        if (listener instanceof GuiSpriteManager) {
            GuiSpriteManager spriteManager = (GuiSpriteManager)listener;
            if (spriteManager.textureAtlas.texturesByName.isEmpty()) {
                this.rrls$reloadListener((PreparableReloadListener)spriteManager, (Executor)RRLS$MINECRAFT, (unused, throwable) -> {});
            }
        }
    }

    @Inject(method={"createReload(Ljava/util/concurrent/Executor;Ljava/util/concurrent/Executor;Ljava/util/concurrent/CompletableFuture;Ljava/util/List;)Lnet/minecraft/server/packs/resources/ReloadInstance;"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/packs/resources/SimpleReloadInstance;create(Lnet/minecraft/server/packs/resources/ResourceManager;Ljava/util/List;Ljava/util/concurrent/Executor;Ljava/util/concurrent/Executor;Ljava/util/concurrent/CompletableFuture;Z)Lnet/minecraft/server/packs/resources/ReloadInstance;")})
    private void rrls$initReloaders(Executor backgroundExecutor, Executor gameExecutor, CompletableFuture<Unit> waitingFor, List<PackResources> resourcePacks, CallbackInfoReturnable<ReloadInstance> cir) {
        for (PreparableReloadListener listener : this.rrls$listeners) {
            this.rrls$reloadListener(listener, (Executor)RRLS$MINECRAFT, (unused, throwable) -> {});
        }
        this.rrls$listeners.clear();
    }

    @Unique
    private void rrls$reloadListener(PreparableReloadListener listener, Executor gameExecutor, BiConsumer<Void, Throwable> action) {
        try {
            if (this.resources.getNamespaces().isEmpty() || this.resources.getNamespaces().size() < 2) {
                this.resources.close();
                Rrls.LOGGER.info("Creating new resource manager!");
                this.resources = new MultiPackResourceManager(PackType.CLIENT_RESOURCES, RRLS$MINECRAFT.getResourcePackRepository().openAllSelected());
            }
            Rrls.LOGGER.info("Quick reload listener '{}'", (Object)listener.getName());
            listener.reload(CompletableFuture::completedFuture, (ResourceManager)((ReloadableResourceManager)this), (ProfilerFiller)InactiveProfiler.INSTANCE, (ProfilerFiller)InactiveProfiler.INSTANCE, (Executor)Util.backgroundExecutor(), gameExecutor).whenCompleteAsync(action, (Executor)Util.backgroundExecutor());
        }
        catch (Throwable th) {
            this.rrls$listeners.add(listener);
            Rrls.LOGGER.warn("Failed to reload {}!", (Object)listener.getName(), (Object)th);
        }
    }

    @Unique
    private void rrls$refreshScreen() {
        if (ConfigExpectPlatform.reInitScreen() && ReloadableResourceManagerMixin.RRLS$MINECRAFT.screen != null) {
            ReloadableResourceManagerMixin.RRLS$MINECRAFT.screen.init(RRLS$MINECRAFT, RRLS$MINECRAFT.getWindow().getGuiScaledWidth(), RRLS$MINECRAFT.getWindow().getGuiScaledHeight());
        }
    }
}

