/*
 * Decompiled with CFR 0.152.
 */
package org.redlance.dima_dencep.mods.rrls.mixins;

import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.blaze3d.systems.CommandEncoder;
import com.mojang.blaze3d.textures.GpuTexture;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.FocusableTextWidget;
import net.minecraft.client.gui.screens.LoadingOverlay;
import net.minecraft.client.gui.screens.Overlay;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.resources.ReloadInstance;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import org.redlance.dima_dencep.mods.rrls.Rrls;
import org.redlance.dima_dencep.mods.rrls.RrlsConfig;
import org.redlance.dima_dencep.mods.rrls.config.Type;
import org.redlance.dima_dencep.mods.rrls.utils.DummyGuiGraphics;
import org.redlance.dima_dencep.mods.rrls.utils.OverlayHelper;
import org.redlance.dima_dencep.mods.rrls.utils.RainbowUtils;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LoadingOverlay.class})
public abstract class LoadingOverlayMixin
extends Overlay {
    @Shadow
    @Final
    private Minecraft minecraft;
    @Shadow
    public float currentProgress;
    @Shadow
    private long fadeOutStart;
    @Shadow
    private long fadeInStart;
    @Unique
    private FocusableTextWidget rrls$textWidget;
    @Unique
    private long rrls$atEndStart = -1L;
    @Unique
    private boolean rrls$isFinished;

    @Shadow
    public abstract void drawProgressBar(GuiGraphics var1, int var2, int var3, int var4, int var5, float var6);

    @Inject(method={"<init>(Lnet/minecraft/client/Minecraft;Lnet/minecraft/server/packs/resources/ReloadInstance;Ljava/util/function/Consumer;Z)V"}, at={@At(value="TAIL")})
    private void rrls$init(Minecraft client, ReloadInstance reload, Consumer<Optional<Throwable>> onFinish, boolean fadeIn, CallbackInfo ci) {
        this.rrls$setState(OverlayHelper.lookupState(client.screen, fadeIn));
        if (RrlsConfig.type() == Type.TEXT_WITH_BACKGROUND) {
            this.rrls$textWidget = new FocusableTextWidget(1, (Component)Component.literal((String)RrlsConfig.reloadText()), this.minecraft.font, 12);
        }
    }

    public void rrls$miniRender(GuiGraphics graphics, float partialTick) {
        int i = graphics.guiWidth();
        int j = graphics.guiHeight();
        long fadeTime = RrlsConfig.interpolateAtEnd() ? this.rrls$atEndStart : this.fadeOutStart;
        float ease = 1.0f;
        if (RrlsConfig.interpolateProgress()) {
            ease -= RrlsConfig.easing().invoke(this.currentProgress, RrlsConfig.easingArg());
        } else if (fadeTime > -1L) {
            float f = (float)(Util.getMillis() - fadeTime) / RrlsConfig.animationSpeed();
            ease -= RrlsConfig.easing().invoke(Mth.clamp((float)f, (float)0.0f, (float)1.0f), RrlsConfig.easingArg());
        }
        if (ease <= 0.0f) {
            this.rrls$isFinished = true;
        }
        int easeAlpha = Mth.ceil((float)Mth.lerp((float)ease, (float)4.0f, (float)255.0f));
        int easeColor = ARGB.color((int)easeAlpha, (int)255, (int)255, (int)255);
        switch (RrlsConfig.type()) {
            case PROGRESS: {
                int s = (int)((double)j * 0.8325);
                int r = (int)(Math.min((double)i * 0.75, (double)j) * 0.5);
                this.drawProgressBar(graphics, i / 2 - r, s - 5, i / 2 + r, s + 5, ease);
                break;
            }
            case TEXT: {
                graphics.drawCenteredString(this.minecraft.font, RrlsConfig.reloadText(), i / 2, 70, RrlsConfig.rgbProgress() ? RainbowUtils.rainbowColor(easeAlpha) : easeColor);
                break;
            }
            case TEXT_WITH_BACKGROUND: {
                if (this.rrls$textWidget == null) break;
                this.rrls$textWidget.setMaxWidth(i);
                this.rrls$textWidget.setX(i / 2 - this.rrls$textWidget.getWidth() / 2);
                this.rrls$textWidget.setY(j - j / 3);
                this.rrls$textWidget.setColor(easeColor);
                if (RrlsConfig.rgbProgress()) {
                    this.rrls$textWidget.setColor(RainbowUtils.rainbowColor(easeAlpha));
                }
                graphics.pose().pushMatrix();
                this.rrls$textWidget.render(graphics, 0, 0, partialTick);
                graphics.pose().popMatrix();
                break;
            }
        }
    }

    public void rrls$resetProgress() {
        this.rrls$isFinished = false;
        this.currentProgress = 0.0f;
        this.rrls$atEndStart = -1L;
        this.fadeOutStart = -1L;
        this.fadeInStart = -1L;
    }

    @WrapWithCondition(method={"render(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/Screen;renderWithTooltipAndSubtitles(Lnet/minecraft/client/gui/GuiGraphics;IIF)V")})
    public boolean rrls$screenrender(Screen instance, GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        return !(graphics instanceof DummyGuiGraphics);
    }

    @WrapWithCondition(method={"render(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/Minecraft;setOverlay(Lnet/minecraft/client/gui/screens/Overlay;)V")})
    public boolean rrls$reinitScreen(Minecraft instance, Overlay loadingGui) {
        boolean isRemoved;
        boolean bl = isRemoved = this.rrls$getState() == OverlayHelper.State.DEFAULT || this.rrls$isFinished;
        if (isRemoved) {
            Rrls.LOGGER.info("Overlay is removed!");
        }
        return isRemoved;
    }

    @WrapWithCondition(method={"tick()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/Screen;init(Lnet/minecraft/client/Minecraft;II)V")})
    public boolean rrls$reinitScreen(Screen instance, Minecraft minecraft, int width, int height) {
        return RrlsConfig.reInitScreen();
    }

    @WrapOperation(method={"render(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/systems/CommandEncoder;clearColorTexture(Lcom/mojang/blaze3d/textures/GpuTexture;I)V", remap=false)})
    public void rrls$_clearColor(CommandEncoder instance, GpuTexture gpuTexture, int i, Operation<Void> original, @Local(argsOnly=true) GuiGraphics graphics) {
        if (graphics instanceof DummyGuiGraphics) {
            return;
        }
        original.call(new Object[]{instance, gpuTexture, i});
    }

    @WrapOperation(method={"drawProgressBar(Lnet/minecraft/client/gui/GuiGraphics;IIIIF)V"}, at={@At(value="INVOKE", target="Ljava/lang/Math;round(F)I")})
    public int rrls$lerp(float i, Operation<Integer> original, @Local(argsOnly=true) float partialTick) {
        if (this.rrls$getState() != OverlayHelper.State.DEFAULT) {
            return (Integer)original.call(new Object[]{Float.valueOf(Mth.lerp((float)partialTick, (float)0.0f, (float)255.0f))});
        }
        return (Integer)original.call(new Object[]{Float.valueOf(i)});
    }

    @WrapOperation(method={"drawProgressBar(Lnet/minecraft/client/gui/GuiGraphics;IIIIF)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/util/ARGB;color(IIII)I")})
    public int rrls$rainbowProgress(int alpha, int red, int green, int blue, Operation<Integer> original, @Local(argsOnly=true) float partialTick) {
        if (RrlsConfig.rgbProgress() && this.rrls$getState() != OverlayHelper.State.DEFAULT) {
            return RainbowUtils.rainbowColor(partialTick);
        }
        return (Integer)original.call(new Object[]{alpha, red, green, blue});
    }

    @Inject(method={"tick()V"}, at={@At(value="FIELD", target="Lnet/minecraft/client/gui/screens/LoadingOverlay;fadeOutStart:J", ordinal=0)})
    public void rrls$interpolateAtEnd(CallbackInfo ci) {
        if (this.rrls$atEndStart == -1L && this.currentProgress >= 0.99999f) {
            this.rrls$atEndStart = Util.getMillis();
        }
    }

    @ModifyConstant(method={"render(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"}, constant={@Constant(floatValue=1000.0f, ordinal=0), @Constant(floatValue=500.0f, ordinal=0)}, require=0)
    public float rrls$changeAnimationSpeed(float instance) {
        if (!this.rrls$getState().isRendering()) {
            return instance == 1000.0f ? RrlsConfig.animationSpeed() : RrlsConfig.animationSpeed() / 2.0f;
        }
        return instance;
    }

    public boolean isPauseScreen() {
        return super.isPauseScreen();
    }
}

