/*
 * Decompiled with CFR 0.152.
 */
package org.redlance.dima_dencep.mods.rrls.mixins;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Overlay;
import net.minecraft.client.main.GameConfig;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;
import org.redlance.dima_dencep.mods.rrls.Rrls;
import org.redlance.dima_dencep.mods.rrls.RrlsConfig;
import org.redlance.dima_dencep.mods.rrls.config.DoubleLoad;
import org.redlance.dima_dencep.mods.rrls.utils.OverlayHelper;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Minecraft.class})
public abstract class MinecraftClientMixin {
    @Shadow
    private boolean gameLoadFinished;
    @Shadow
    @Nullable
    public Overlay overlay;

    @Shadow
    protected abstract void addResourcePackLoadFailToast(@Nullable Component var1);

    @Shadow
    protected abstract CompletableFuture<Void> reloadResourcePacks(boolean var1, @Nullable Minecraft.GameLoadCookie var2);

    @Shadow
    protected abstract void onResourceLoadFinished(@Nullable Minecraft.GameLoadCookie var1);

    @Inject(method={"<init>(Lnet/minecraft/client/main/GameConfig;)V"}, at={@At(value="INVOKE", target="Lcom/mojang/jtracy/TracyClient;isAvailable()Z", shift=At.Shift.AFTER, remap=false)})
    public void rrls$init(GameConfig gameConfig, CallbackInfo ci, @Local(ordinal=0) Minecraft.GameLoadCookie gameLoadCookie) {
        if (!OverlayHelper.isCurrentRenderingState()) {
            return;
        }
        try {
            this.onResourceLoadFinished(gameLoadCookie);
        }
        catch (Throwable th) {
            Rrls.LOGGER.error("Failed to complete load early!", th);
            this.gameLoadFinished = false;
        }
    }

    @WrapWithCondition(method={"onGameLoadFinished(Lnet/minecraft/client/Minecraft$GameLoadCookie;)V"}, at={@At(value="INVOKE", target="Ljava/lang/Runnable;run()V")})
    public boolean rrls$fixDH(Runnable instance) {
        instance.run();
        return false;
    }

    @Inject(method={"clearResourcePacksOnError(Ljava/lang/Throwable;Lnet/minecraft/network/chat/Component;Lnet/minecraft/client/Minecraft$GameLoadCookie;)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void rrls$onResourceReloadFailure(Throwable throwable, Component errorMessage, Minecraft.GameLoadCookie gameLoadCookie, CallbackInfo ci) {
        if (!RrlsConfig.resetResources()) {
            ci.cancel();
            Rrls.LOGGER.error("Caught error loading resourcepacks!", throwable);
            if (RrlsConfig.doubleLoad().isLoad()) {
                this.reloadResourcePacks(RrlsConfig.doubleLoad() == DoubleLoad.FORCE_LOAD, gameLoadCookie).thenRun(() -> this.addResourcePackLoadFailToast(errorMessage));
            }
        }
    }

    @Inject(method={"clearResourcePacksOnError(Ljava/lang/Throwable;Lnet/minecraft/network/chat/Component;Lnet/minecraft/client/Minecraft$GameLoadCookie;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/Minecraft;reloadResourcePacks(ZLnet/minecraft/client/Minecraft$GameLoadCookie;)Ljava/util/concurrent/CompletableFuture;", shift=At.Shift.BEFORE)}, cancellable=true)
    public void rrls$doubleLoad(Throwable throwable, Component errorMessage, Minecraft.GameLoadCookie gameLoadCookie, CallbackInfo ci) {
        if (!RrlsConfig.doubleLoad().isLoad()) {
            ci.cancel();
        }
    }

    @ModifyArg(method={"clearResourcePacksOnError(Ljava/lang/Throwable;Lnet/minecraft/network/chat/Component;Lnet/minecraft/client/Minecraft$GameLoadCookie;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/Minecraft;reloadResourcePacks(ZLnet/minecraft/client/Minecraft$GameLoadCookie;)Ljava/util/concurrent/CompletableFuture;", ordinal=0), require=0)
    public boolean rrls$doubleLoad(boolean error) {
        return RrlsConfig.doubleLoad() == DoubleLoad.FORCE_LOAD;
    }

    @WrapOperation(method={"handleKeybinds()V"}, at={@At(value="FIELD", target="Lnet/minecraft/client/Minecraft;overlay:Lnet/minecraft/client/gui/screens/Overlay;")})
    public Overlay rrls$miniRender(Minecraft instance, Operation<Overlay> original) {
        Overlay overlay = (Overlay)original.call(new Object[]{instance});
        if (OverlayHelper.isRenderingState(overlay)) {
            return null;
        }
        return overlay;
    }

    @WrapOperation(method={"tick()V"}, at={@At(value="FIELD", target="Lnet/minecraft/client/Minecraft;overlay:Lnet/minecraft/client/gui/screens/Overlay;", ordinal=2)})
    public Overlay rrls$miniRenderTick(Minecraft instance, Operation<Overlay> original) {
        return this.rrls$miniRender(instance, original);
    }

    @WrapOperation(method={"doWorldLoad(Lnet/minecraft/world/level/storage/LevelStorageSource$LevelStorageAccess;Lnet/minecraft/server/packs/repository/PackRepository;Lnet/minecraft/server/WorldStem;Z)V"}, at={@At(value="FIELD", target="Lnet/minecraft/client/Minecraft;overlay:Lnet/minecraft/client/gui/screens/Overlay;", ordinal=0)})
    public Overlay rrls$miniRenderWorldLoad(Minecraft instance, Operation<Overlay> original) {
        return this.rrls$miniRender(instance, original);
    }

    @ModifyReturnValue(method={"getOverlay()Lnet/minecraft/client/gui/screens/Overlay;"}, at={@At(value="RETURN")})
    public Overlay rrls$blockOverlay(Overlay original) {
        if (RrlsConfig.blockOverlay() && OverlayHelper.isRenderingState(original)) {
            return null;
        }
        return original;
    }

    @WrapOperation(method={"setScreenAndShow(Lnet/minecraft/client/gui/screens/Screen;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/Minecraft;runTick(Z)V")})
    public void rrls$removeTick(Minecraft instance, boolean renderLevel, Operation<Void> original) {
        if (!OverlayHelper.isRenderingState(this.overlay)) {
            original.call(new Object[]{instance, renderLevel});
        }
    }
}

