/*
 * Decompiled with CFR 0.152.
 */
package org.redlance.dima_dencep.mods.rrls.mixins.workaround;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.font.FontManager;
import net.minecraft.client.renderer.ShaderManager;
import net.minecraft.client.resources.SplashManager;
import net.minecraft.client.resources.language.LanguageManager;
import net.minecraft.client.resources.model.AtlasManager;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.CloseableResourceManager;
import net.minecraft.server.packs.resources.MultiPackResourceManager;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ReloadInstance;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.Unit;
import org.redlance.dima_dencep.mods.rrls.Rrls;
import org.redlance.dima_dencep.mods.rrls.RrlsConfig;
import org.redlance.dima_dencep.mods.rrls.utils.OverlayHelper;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ReloadableResourceManager.class})
public class ReloadableResourceManagerMixin {
    @Shadow
    private CloseableResourceManager resources;
    @Unique
    private static final Minecraft RRLS$MINECRAFT = Minecraft.getInstance();
    @Unique
    private final Set<PreparableReloadListener> rrls$listeners = Sets.newConcurrentHashSet();

    @Inject(method={"registerReloadListener(Lnet/minecraft/server/packs/resources/PreparableReloadListener;)V"}, at={@At(value="TAIL")})
    public void rrls$initReloader(PreparableReloadListener listener, CallbackInfo ci) {
        LanguageManager languageManager;
        if (!OverlayHelper.isCurrentRenderingState()) {
            return;
        }
        if (listener instanceof FontManager) {
            FontManager fontManager = (FontManager)listener;
            if (!fontManager.fontSets.containsKey(Minecraft.DEFAULT_FONT)) {
                this.rrls$reloadListener((PreparableReloadListener)fontManager, (Executor)RRLS$MINECRAFT, (unused, throwable) -> this.rrls$refreshScreen());
            }
        }
        if (listener instanceof LanguageManager && (languageManager = (LanguageManager)listener).getLanguages().size() <= 1) {
            this.rrls$reloadListener((PreparableReloadListener)languageManager, (Executor)Util.backgroundExecutor(), (unused, throwable) -> {});
        }
        if (listener instanceof SplashManager) {
            SplashManager splashManager = (SplashManager)listener;
            if (splashManager.splashes.isEmpty()) {
                this.rrls$reloadListener((PreparableReloadListener)splashManager, (Executor)Util.backgroundExecutor(), (unused, throwable) -> this.rrls$refreshScreen());
            }
        }
        if (listener instanceof AtlasManager) {
            AtlasManager atlasManager = (AtlasManager)listener;
            if (atlasManager.materialLookup.isEmpty()) {
                this.rrls$reloadListener((PreparableReloadListener)atlasManager, (Executor)RRLS$MINECRAFT, (unused, throwable) -> {});
            }
        }
        if (listener instanceof ShaderManager) {
            ShaderManager shaderManager = (ShaderManager)listener;
            if (shaderManager.compilationCache.configs == ShaderManager.Configs.EMPTY) {
                this.rrls$reloadListener((PreparableReloadListener)shaderManager, (Executor)RRLS$MINECRAFT, (unused, throwable) -> {});
            }
        }
    }

    @Inject(method={"createReload(Ljava/util/concurrent/Executor;Ljava/util/concurrent/Executor;Ljava/util/concurrent/CompletableFuture;Ljava/util/List;)Lnet/minecraft/server/packs/resources/ReloadInstance;"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/packs/resources/SimpleReloadInstance;create(Lnet/minecraft/server/packs/resources/ResourceManager;Ljava/util/List;Ljava/util/concurrent/Executor;Ljava/util/concurrent/Executor;Ljava/util/concurrent/CompletableFuture;Z)Lnet/minecraft/server/packs/resources/ReloadInstance;")})
    private void rrls$initReloaders(Executor backgroundExecutor, Executor gameExecutor, CompletableFuture<Unit> waitingFor, List<PackResources> resourcePacks, CallbackInfoReturnable<ReloadInstance> cir) {
        for (PreparableReloadListener listener : this.rrls$listeners) {
            this.rrls$reloadListener(listener, (Executor)RRLS$MINECRAFT, (unused, throwable) -> {});
        }
        this.rrls$listeners.clear();
    }

    @Unique
    private void rrls$reloadListener(PreparableReloadListener listener, Executor gameExecutor, BiConsumer<Void, Throwable> action) {
        try {
            if (this.resources.getNamespaces().isEmpty() || this.resources.getNamespaces().size() < 2) {
                this.resources.close();
                Rrls.LOGGER.info("Creating new resource manager!");
                this.resources = new MultiPackResourceManager(PackType.CLIENT_RESOURCES, RRLS$MINECRAFT.getResourcePackRepository().openAllSelected());
            }
            Rrls.LOGGER.info("Quick reload listener '{}'", (Object)listener.getName());
            PreparableReloadListener.SharedState sharedState = new PreparableReloadListener.SharedState((ResourceManager)((ReloadableResourceManager)this));
            listener.prepareSharedState(sharedState);
            listener.reload(sharedState, (Executor)Util.backgroundExecutor(), CompletableFuture::completedFuture, gameExecutor).whenCompleteAsync(action, (Executor)RRLS$MINECRAFT);
        }
        catch (Throwable th) {
            this.rrls$listeners.add(listener);
            Rrls.LOGGER.warn("Failed to reload {}!", (Object)listener.getName(), (Object)th);
        }
    }

    @Unique
    private void rrls$refreshScreen() {
        if (RrlsConfig.reInitScreen() && ReloadableResourceManagerMixin.RRLS$MINECRAFT.screen != null) {
            ReloadableResourceManagerMixin.RRLS$MINECRAFT.screen.init(RRLS$MINECRAFT, RRLS$MINECRAFT.getWindow().getGuiScaledWidth(), RRLS$MINECRAFT.getWindow().getGuiScaledHeight());
        }
    }
}

