/*
 * Decompiled with CFR 0.152.
 */
package org.redlance.dima_dencep.mods.rrls.utils;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;
import org.redlance.dima_dencep.mods.rrls.Rrls;
import org.redlance.dima_dencep.mods.rrls.utils.DummyGuiGraphics;
import org.spongepowered.asm.util.asm.ASM;

public class GuiGraphicsGenerator
extends ClassVisitor {
    protected final ClassNode output;

    protected GuiGraphicsGenerator(ClassNode output) {
        super(ASM.API_VERSION);
        this.output = output;
    }

    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        for (MethodNode node : this.output.methods) {
            if (!node.name.equals(name) || !node.desc.equals(descriptor)) continue;
            Rrls.LOGGER.info("Skipping {}{}...", (Object)name, (Object)descriptor);
            return super.visitMethod(access, name, descriptor, signature, exceptions);
        }
        MethodNode methodNode = new MethodNode(access, name, descriptor, signature, exceptions);
        if (methodNode.invisibleAnnotations == null) {
            methodNode.invisibleAnnotations = new ArrayList();
        }
        methodNode.invisibleAnnotations.add(new AnnotationNode("Ljava/lang/Override;"));
        Rrls.LOGGER.info("Adding {}{}...", (Object)name, (Object)descriptor);
        this.output.methods.add(methodNode);
        return methodNode;
    }

    public static void main(String ... args) throws IOException {
        ClassNode guiGraphicsNode = GuiGraphicsGenerator.readClassNode(GuiGraphics.class, 5);
        ClassNode dummyGuiGraphics = GuiGraphicsGenerator.readClassNode(DummyGuiGraphics.class, 8);
        guiGraphicsNode.accept((ClassVisitor)new GuiGraphicsGenerator(dummyGuiGraphics));
        ClassWriter writer = new ClassWriter(1);
        dummyGuiGraphics.accept((ClassVisitor)writer);
        Files.write(Path.of("DummyGuiGraphics.class", new String[0]), writer.toByteArray(), new OpenOption[0]);
    }

    private static ClassNode readClassNode(Class<?> clazz, int parsingOptions) {
        ClassNode classNode = new ClassNode();
        try (InputStream is = clazz.getClassLoader().getResourceAsStream(clazz.getName().replace(".", "/") + ".class");){
            ClassReader cr = new ClassReader(Objects.requireNonNull(is));
            cr.accept((ClassVisitor)classNode, parsingOptions);
        }
        catch (IOException e) {
            Rrls.LOGGER.warn("Failed to read '{}'!", (Object)clazz.getName());
        }
        return classNode;
    }
}

