/*
 * Decompiled with CFR 0.152.
 */
package org.redlance.dima_dencep.mods.rrls.utils;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.GenericMessageScreen;
import net.minecraft.client.gui.screens.Overlay;
import net.minecraft.client.gui.screens.Screen;
import org.redlance.dima_dencep.mods.rrls.RrlsConfig;

public class OverlayHelper {
    public static State lookupState(Screen screen, boolean reloading) {
        if (!RrlsConfig.hideType().canHide(reloading)) {
            return State.DEFAULT;
        }
        if (reloading || RrlsConfig.hideType().affectInitial) {
            return State.HIDE;
        }
        if (screen instanceof GenericMessageScreen) {
            return State.WAIT;
        }
        return screen != null ? State.HIDE : State.WAIT;
    }

    public static boolean isCurrentRenderingState() {
        Overlay overlay = Minecraft.getInstance().overlay;
        if (overlay == null) {
            return RrlsConfig.hideType().affectInitial;
        }
        return OverlayHelper.isRenderingState(overlay);
    }

    public static boolean isRenderingState(Overlay overlay) {
        return overlay != null && overlay.rrls$getState().isRendering();
    }

    public static enum State {
        DEFAULT(false),
        HIDE(true),
        WAIT(false);

        private final boolean render;

        private State(boolean r) {
            this.render = r;
        }

        public boolean isRendering() {
            return this.render;
        }
    }
}

