/*
 * Decompiled with CFR 0.152.
 */
package mdsc.network;

import java.util.HashMap;
import java.util.function.Supplier;
import mdsc.MdscMod;
import mdsc.procedures.ChainsawToggleProcedure;
import mdsc.procedures.ClawsWeaponsRightProcedure;
import mdsc.procedures.LaserCanonActivateRightProcedure;
import mdsc.procedures.RightGunActivateProcedure;
import mdsc.procedures.SwordRightProcedure;
import mdsc.world.inventory.DDWeaponSelectMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class DDWeaponSelectButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public DDWeaponSelectButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public DDWeaponSelectButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(DDWeaponSelectButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(DDWeaponSelectButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            DDWeaponSelectButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = DDWeaponSelectMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            ChainsawToggleProcedure.execute((Entity)entity);
        }
        if (buttonID == 1) {
            RightGunActivateProcedure.execute((Entity)entity);
        }
        if (buttonID == 2) {
            LaserCanonActivateRightProcedure.execute((Entity)entity);
        }
        if (buttonID == 3) {
            ClawsWeaponsRightProcedure.execute((Entity)entity);
        }
        if (buttonID == 4) {
            SwordRightProcedure.execute((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        MdscMod.addNetworkMessage(DDWeaponSelectButtonMessage.class, DDWeaponSelectButtonMessage::buffer, DDWeaponSelectButtonMessage::new, DDWeaponSelectButtonMessage::handler);
    }
}

