/*
 * Decompiled with CFR 0.152.
 */
package mdsc.network;

import java.util.HashMap;
import java.util.function.Supplier;
import mdsc.MdscMod;
import mdsc.procedures.DDButtonProcedureProcedure;
import mdsc.procedures.DevMorphTestProcedure;
import mdsc.procedures.DiveTestProcedure;
import mdsc.procedures.OpenOilProcedure;
import mdsc.procedures.OpenTierSelectProcedure;
import mdsc.procedures.OpenUnlocksProcedure;
import mdsc.procedures.ResetSelfVariablesProcedure;
import mdsc.procedures.ResetTierProcedure;
import mdsc.procedures.SetDDSolveProcedure;
import mdsc.procedures.SetDevTrueProcedure;
import mdsc.procedures.SetOil100Procedure;
import mdsc.procedures.SolverDroneVariablesProcedure;
import mdsc.procedures.WorkerDroneVariableProcedure;
import mdsc.world.inventory.DevConsoleMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class DevConsoleButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public DevConsoleButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public DevConsoleButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(DevConsoleButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(DevConsoleButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            DevConsoleButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = DevConsoleMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            ResetSelfVariablesProcedure.execute((Entity)entity);
        }
        if (buttonID == 1) {
            SolverDroneVariablesProcedure.execute((Entity)entity);
        }
        if (buttonID == 2) {
            SetOil100Procedure.execute((Entity)entity);
        }
        if (buttonID == 3) {
            WorkerDroneVariableProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 4) {
            DDButtonProcedureProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 5) {
            OpenOilProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 6) {
            SetDevTrueProcedure.execute((Entity)entity);
        }
        if (buttonID == 7) {
            OpenUnlocksProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 8) {
            DevMorphTestProcedure.execute((Entity)entity);
        }
        if (buttonID == 9) {
            DiveTestProcedure.execute((Entity)entity);
        }
        if (buttonID == 10) {
            OpenTierSelectProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 11) {
            ResetTierProcedure.execute((Entity)entity);
        }
        if (buttonID == 12) {
            SetDDSolveProcedure.execute((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        MdscMod.addNetworkMessage(DevConsoleButtonMessage.class, DevConsoleButtonMessage::buffer, DevConsoleButtonMessage::new, DevConsoleButtonMessage::handler);
    }
}

