/*
 * Decompiled with CFR 0.152.
 */
package mdsc.network;

import java.util.ArrayList;
import java.util.function.Supplier;
import mdsc.MdscMod;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class MdscModVariables {
    public static ItemStack b = ItemStack.f_41583_;
    public static final Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        MdscMod.addNetworkMessage(SavedDataSyncMessage.class, SavedDataSyncMessage::buffer, SavedDataSyncMessage::new, SavedDataSyncMessage::handler);
        MdscMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        MdscMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    public static class SavedDataSyncMessage {
        private final int type;
        private SavedData data;

        public SavedDataSyncMessage(FriendlyByteBuf buffer) {
            this.type = buffer.readInt();
            CompoundTag nbt = buffer.m_130260_();
            if (nbt != null) {
                this.data = this.type == 0 ? new MapVariables() : new WorldVariables();
                SavedData savedData = this.data;
                if (savedData instanceof MapVariables) {
                    MapVariables mapVariables = (MapVariables)savedData;
                    mapVariables.read(nbt);
                } else {
                    savedData = this.data;
                    if (savedData instanceof WorldVariables) {
                        WorldVariables worldVariables = (WorldVariables)savedData;
                        worldVariables.read(nbt);
                    }
                }
            }
        }

        public SavedDataSyncMessage(int type, SavedData data) {
            this.type = type;
            this.data = data;
        }

        public static void buffer(SavedDataSyncMessage message, FriendlyByteBuf buffer) {
            buffer.writeInt(message.type);
            if (message.data != null) {
                buffer.m_130079_(message.data.m_7176_(new CompoundTag()));
            }
        }

        public static void handler(SavedDataSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer() && message.data != null) {
                    if (message.type == 0) {
                        MapVariables.clientSide = (MapVariables)message.data;
                    } else {
                        WorldVariables.clientSide = (WorldVariables)message.data;
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariablesSyncMessage {
        private final int target;
        private final PlayerVariables data;

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerVariables();
            this.data.readNBT((Tag)buffer.m_130260_());
            this.target = buffer.readInt();
        }

        public PlayerVariablesSyncMessage(PlayerVariables data, int entityid) {
            this.data = data;
            this.target = entityid;
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeNBT());
            buffer.writeInt(message.target);
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.m_91087_().f_91074_.m_9236_().m_6815_(message.target).getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.d = message.data.d;
                    variables.e = message.data.e;
                    variables.AbilityVariableKnife = message.data.AbilityVariableKnife;
                    variables.AbilityVariableNullThrow = message.data.AbilityVariableNullThrow;
                    variables.AbilityVariableSolver = message.data.AbilityVariableSolver;
                    variables.AbilityVariableSolverThrow = message.data.AbilityVariableSolverThrow;
                    variables.AbilityVariableTeleport = message.data.AbilityVariableTeleport;
                    variables.ABSOAbility = message.data.ABSOAbility;
                    variables.AngryEx = message.data.AngryEx;
                    variables.AnnoyedEx = message.data.AnnoyedEx;
                    variables.April_boss_started = message.data.April_boss_started;
                    variables.beginnerlevel = message.data.beginnerlevel;
                    variables.bootinglogic = message.data.bootinglogic;
                    variables.CanDualCommand = message.data.CanDualCommand;
                    variables.Chainsaws = message.data.Chainsaws;
                    variables.CynEntityErrVariable = message.data.CynEntityErrVariable;
                    variables.dddroneidle = message.data.dddroneidle;
                    variables.DDMurderMode = message.data.DDMurderMode;
                    variables.delay = message.data.delay;
                    variables.DevTest = message.data.DevTest;
                    variables.DisDroneHudVariable = message.data.DisDroneHudVariable;
                    variables.DisDroneVariable1 = message.data.DisDroneVariable1;
                    variables.flightanimationvariable = message.data.flightanimationvariable;
                    variables.flyIdle = message.data.flyIdle;
                    variables.flyingvariable = message.data.flyingvariable;
                    variables.GunLeft = message.data.GunLeft;
                    variables.GunRight = message.data.GunRight;
                    variables.HoverVariable = message.data.HoverVariable;
                    variables.HumanVariable = message.data.HumanVariable;
                    variables.ispatched = message.data.ispatched;
                    variables.iswalking = message.data.iswalking;
                    variables.IsWorkerDrone = message.data.IsWorkerDrone;
                    variables.LaserCannonLeft = message.data.LaserCannonLeft;
                    variables.LaserCannonRight = message.data.LaserCannonRight;
                    variables.LeftWeapon = message.data.LeftWeapon;
                    variables.LeftWeaponHand = message.data.LeftWeaponHand;
                    variables.LimeChosen = message.data.LimeChosen;
                    variables.LogicHUD1 = message.data.LogicHUD1;
                    variables.LogicHUD2 = message.data.LogicHUD2;
                    variables.LogicHUD3 = message.data.LogicHUD3;
                    variables.LogicHUD4 = message.data.LogicHUD4;
                    variables.LogicHUD5 = message.data.LogicHUD5;
                    variables.LogicHUD6 = message.data.LogicHUD6;
                    variables.LogicHUD7 = message.data.LogicHUD7;
                    variables.LogicHUD8 = message.data.LogicHUD8;
                    variables.LogicHUD9 = message.data.LogicHUD9;
                    variables.MaleDroneAssignedToPlayer = message.data.MaleDroneAssignedToPlayer;
                    variables.ModelTest = message.data.ModelTest;
                    variables.nightmode = message.data.nightmode;
                    variables.NoDronePicked = message.data.NoDronePicked;
                    variables.OilLow1 = message.data.OilLow1;
                    variables.OverlayLogicSolverTest1 = message.data.OverlayLogicSolverTest1;
                    variables.Patched = message.data.Patched;
                    variables.patchedHud = message.data.patchedHud;
                    variables.PlayerArmorLogic = message.data.PlayerArmorLogic;
                    variables.PlayerIsDrone = message.data.PlayerIsDrone;
                    variables.PurpleChosen = message.data.PurpleChosen;
                    variables.RedChosen = message.data.RedChosen;
                    variables.RightWeapon = message.data.RightWeapon;
                    variables.RightWeaponHand = message.data.RightWeaponHand;
                    variables.ScaredEx = message.data.ScaredEx;
                    variables.sethud1 = message.data.sethud1;
                    variables.sethud2 = message.data.sethud2;
                    variables.sethud3 = message.data.sethud3;
                    variables.SolverDroneVariable1 = message.data.SolverDroneVariable1;
                    variables.SolverPossessionLogic = message.data.SolverPossessionLogic;
                    variables.Stage_1_April = message.data.Stage_1_April;
                    variables.Stage_2_April = message.data.Stage_2_April;
                    variables.SurroudAbso = message.data.SurroudAbso;
                    variables.surroundvariable = message.data.surroundvariable;
                    variables.tailon = message.data.tailon;
                    variables.UnlockedControl = message.data.UnlockedControl;
                    variables.UnlockedKnife = message.data.UnlockedKnife;
                    variables.UnlockedNll = message.data.UnlockedNll;
                    variables.UnlockedSheild = message.data.UnlockedSheild;
                    variables.UnlockedTeleport = message.data.UnlockedTeleport;
                    variables.UnlockedZomb = message.data.UnlockedZomb;
                    variables.UnlockedZombFly = message.data.UnlockedZombFly;
                    variables.Unpatched = message.data.Unpatched;
                    variables.wdsolvact = message.data.wdsolvact;
                    variables.WDTamed = message.data.WDTamed;
                    variables.WingsIn = message.data.WingsIn;
                    variables.YellowChosen = message.data.YellowChosen;
                    variables.ZombHUD = message.data.ZombHUD;
                    variables.ZombieForm = message.data.ZombieForm;
                    variables.Booting = message.data.Booting;
                    variables.Distance = message.data.Distance;
                    variables.Exp_Points = message.data.Exp_Points;
                    variables.HoverTimer = message.data.HoverTimer;
                    variables.murder_coin_amount = message.data.murder_coin_amount;
                    variables.OilLevel = message.data.OilLevel;
                    variables.Possess_Numb = message.data.Possess_Numb;
                    variables.SolverPossessionNumb = message.data.SolverPossessionNumb;
                    variables.Self_Control = message.data.Self_Control;
                    variables.AniDisplay = message.data.AniDisplay;
                    variables.SolverLevel = message.data.SolverLevel;
                    variables.TKLeft = message.data.TKLeft;
                    variables.TKRight = message.data.TKRight;
                    variables.TPLeft = message.data.TPLeft;
                    variables.TPRight = message.data.TPRight;
                    variables.KnifeLeft = message.data.KnifeLeft;
                    variables.KnifeRight = message.data.KnifeRight;
                    variables.solvdis = message.data.solvdis;
                    variables.ismenuopen = message.data.ismenuopen;
                    variables.GUIOpen = message.data.GUIOpen;
                    variables.PC_OS_ACCESS = message.data.PC_OS_ACCESS;
                    variables.ERROR_NO_FLOPPY = message.data.ERROR_NO_FLOPPY;
                    variables.MineOres = message.data.MineOres;
                    variables.sy = message.data.sy;
                    variables.sz = message.data.sz;
                    variables.sx = message.data.sx;
                    variables.WingSingle = message.data.WingSingle;
                    variables.DevTest2 = message.data.DevTest2;
                    variables.IsDev = message.data.IsDev;
                    variables.ZombieWings = message.data.ZombieWings;
                    variables.DDWings = message.data.DDWings;
                    variables.WorkerDroneHUD = message.data.WorkerDroneHUD;
                    variables.SolverDroneHUD = message.data.SolverDroneHUD;
                    variables.ZombieDroneHUD = message.data.ZombieDroneHUD;
                    variables.PatchedHUD = message.data.PatchedHUD;
                    variables.SolverFought = message.data.SolverFought;
                    variables.ismorphedn = message.data.ismorphedn;
                    variables.AbilitySolverStrike = message.data.AbilitySolverStrike;
                    variables.ERROR = message.data.ERROR;
                    variables.ShieldActive = message.data.ShieldActive;
                    variables.TKCooldown = message.data.TKCooldown;
                    variables.ddsolver = message.data.ddsolver;
                    variables.SolvOverride = message.data.SolvOverride;
                    variables.WinkEx = message.data.WinkEx;
                    variables.onground = message.data.onground;
                    variables.diving = message.data.diving;
                    variables.BossTier = message.data.BossTier;
                    variables.FlightTier = message.data.FlightTier;
                    variables.GroundTeir = message.data.GroundTeir;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public ItemStack d = ItemStack.f_41583_;
        public ItemStack e = ItemStack.f_41583_;
        public boolean AbilityVariableKnife = false;
        public boolean AbilityVariableNullThrow = false;
        public boolean AbilityVariableSolver = false;
        public boolean AbilityVariableSolverThrow = false;
        public boolean AbilityVariableTeleport = false;
        public boolean ABSOAbility = false;
        public boolean AngryEx = false;
        public boolean AnnoyedEx = false;
        public boolean April_boss_started = false;
        public boolean beginnerlevel = false;
        public boolean bootinglogic = false;
        public boolean CanDualCommand = false;
        public boolean Chainsaws = false;
        public boolean CynEntityErrVariable = false;
        public boolean dddroneidle = false;
        public boolean DDMurderMode = false;
        public boolean delay = false;
        public boolean DevTest = false;
        public boolean DisDroneHudVariable = false;
        public boolean DisDroneVariable1 = false;
        public boolean flightanimationvariable = false;
        public boolean flyIdle = false;
        public boolean flyingvariable = false;
        public boolean GunLeft = false;
        public boolean GunRight = false;
        public boolean HoverVariable = false;
        public boolean HumanVariable = false;
        public boolean ispatched = false;
        public boolean iswalking = false;
        public boolean IsWorkerDrone = false;
        public boolean LaserCannonLeft = false;
        public boolean LaserCannonRight = false;
        public boolean LeftWeapon = false;
        public boolean LeftWeaponHand = false;
        public boolean LimeChosen = false;
        public boolean LogicHUD1 = false;
        public boolean LogicHUD2 = false;
        public boolean LogicHUD3 = false;
        public boolean LogicHUD4 = false;
        public boolean LogicHUD5 = false;
        public boolean LogicHUD6 = false;
        public boolean LogicHUD7 = false;
        public boolean LogicHUD8 = false;
        public boolean LogicHUD9 = false;
        public boolean MaleDroneAssignedToPlayer = false;
        public boolean ModelTest = false;
        public boolean nightmode = false;
        public boolean NoDronePicked = true;
        public boolean OilLow1 = false;
        public boolean OverlayLogicSolverTest1 = false;
        public boolean Patched = false;
        public boolean patchedHud = false;
        public boolean PlayerArmorLogic = false;
        public boolean PlayerIsDrone = false;
        public boolean PurpleChosen = false;
        public boolean RedChosen = false;
        public boolean RightWeapon = false;
        public boolean RightWeaponHand = false;
        public boolean ScaredEx = false;
        public boolean sethud1 = false;
        public boolean sethud2 = false;
        public boolean sethud3 = false;
        public boolean SolverDroneVariable1 = false;
        public boolean SolverPossessionLogic = false;
        public boolean Stage_1_April = false;
        public boolean Stage_2_April = false;
        public boolean SurroudAbso = false;
        public boolean surroundvariable = false;
        public boolean tailon = false;
        public boolean UnlockedControl = false;
        public boolean UnlockedKnife = false;
        public boolean UnlockedNll = false;
        public boolean UnlockedSheild = false;
        public boolean UnlockedTeleport = false;
        public boolean UnlockedZomb = false;
        public boolean UnlockedZombFly = false;
        public boolean Unpatched = false;
        public boolean wdsolvact = false;
        public boolean WDTamed = false;
        public boolean WingsIn = false;
        public boolean YellowChosen = false;
        public boolean ZombHUD = false;
        public boolean ZombieForm = false;
        public double Booting = 0.0;
        public double Distance = 0.0;
        public double Exp_Points = 5.0;
        public double HoverTimer = 0.0;
        public double murder_coin_amount = 0.0;
        public double OilLevel = 100.0;
        public double Possess_Numb = 0.0;
        public double SolverPossessionNumb = 0.0;
        public boolean Self_Control = false;
        public boolean AniDisplay = false;
        public double SolverLevel = 0.0;
        public boolean TKLeft = false;
        public boolean TKRight = false;
        public boolean TPLeft = false;
        public boolean TPRight = false;
        public boolean KnifeLeft = false;
        public boolean KnifeRight = false;
        public double solvdis = 100.0;
        public boolean ismenuopen = false;
        public boolean GUIOpen = false;
        public boolean PC_OS_ACCESS = false;
        public boolean ERROR_NO_FLOPPY = false;
        public boolean MineOres = false;
        public double sy = 0.0;
        public double sz = 0.0;
        public double sx = 0.0;
        public boolean WingSingle = false;
        public boolean DevTest2 = false;
        public boolean IsDev = false;
        public boolean ZombieWings = false;
        public boolean DDWings = false;
        public boolean WorkerDroneHUD = false;
        public boolean SolverDroneHUD = false;
        public boolean ZombieDroneHUD = false;
        public boolean PatchedHUD = false;
        public boolean SolverFought = false;
        public boolean ismorphedn = false;
        public boolean AbilitySolverStrike = false;
        public boolean ERROR = false;
        public boolean ShieldActive = false;
        public double TKCooldown = 10000.0;
        public boolean ddsolver = false;
        public boolean SolvOverride = false;
        public boolean WinkEx = false;
        public boolean onground = true;
        public boolean diving = false;
        public boolean BossTier = false;
        public boolean FlightTier = false;
        public boolean GroundTeir = false;

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                MdscMod.PACKET_HANDLER.send(PacketDistributor.DIMENSION.with(() -> ((Level)entity.m_9236_()).m_46472_()), (Object)new PlayerVariablesSyncMessage(this, entity.m_19879_()));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128365_("d", (Tag)this.d.m_41739_(new CompoundTag()));
            nbt.m_128365_("e", (Tag)this.e.m_41739_(new CompoundTag()));
            nbt.m_128379_("AbilityVariableKnife", this.AbilityVariableKnife);
            nbt.m_128379_("AbilityVariableNullThrow", this.AbilityVariableNullThrow);
            nbt.m_128379_("AbilityVariableSolver", this.AbilityVariableSolver);
            nbt.m_128379_("AbilityVariableSolverThrow", this.AbilityVariableSolverThrow);
            nbt.m_128379_("AbilityVariableTeleport", this.AbilityVariableTeleport);
            nbt.m_128379_("ABSOAbility", this.ABSOAbility);
            nbt.m_128379_("AngryEx", this.AngryEx);
            nbt.m_128379_("AnnoyedEx", this.AnnoyedEx);
            nbt.m_128379_("April_boss_started", this.April_boss_started);
            nbt.m_128379_("beginnerlevel", this.beginnerlevel);
            nbt.m_128379_("bootinglogic", this.bootinglogic);
            nbt.m_128379_("CanDualCommand", this.CanDualCommand);
            nbt.m_128379_("Chainsaws", this.Chainsaws);
            nbt.m_128379_("CynEntityErrVariable", this.CynEntityErrVariable);
            nbt.m_128379_("dddroneidle", this.dddroneidle);
            nbt.m_128379_("DDMurderMode", this.DDMurderMode);
            nbt.m_128379_("delay", this.delay);
            nbt.m_128379_("DevTest", this.DevTest);
            nbt.m_128379_("DisDroneHudVariable", this.DisDroneHudVariable);
            nbt.m_128379_("DisDroneVariable1", this.DisDroneVariable1);
            nbt.m_128379_("flightanimationvariable", this.flightanimationvariable);
            nbt.m_128379_("flyIdle", this.flyIdle);
            nbt.m_128379_("flyingvariable", this.flyingvariable);
            nbt.m_128379_("GunLeft", this.GunLeft);
            nbt.m_128379_("GunRight", this.GunRight);
            nbt.m_128379_("HoverVariable", this.HoverVariable);
            nbt.m_128379_("HumanVariable", this.HumanVariable);
            nbt.m_128379_("ispatched", this.ispatched);
            nbt.m_128379_("iswalking", this.iswalking);
            nbt.m_128379_("IsWorkerDrone", this.IsWorkerDrone);
            nbt.m_128379_("LaserCannonLeft", this.LaserCannonLeft);
            nbt.m_128379_("LaserCannonRight", this.LaserCannonRight);
            nbt.m_128379_("LeftWeapon", this.LeftWeapon);
            nbt.m_128379_("LeftWeaponHand", this.LeftWeaponHand);
            nbt.m_128379_("LimeChosen", this.LimeChosen);
            nbt.m_128379_("LogicHUD1", this.LogicHUD1);
            nbt.m_128379_("LogicHUD2", this.LogicHUD2);
            nbt.m_128379_("LogicHUD3", this.LogicHUD3);
            nbt.m_128379_("LogicHUD4", this.LogicHUD4);
            nbt.m_128379_("LogicHUD5", this.LogicHUD5);
            nbt.m_128379_("LogicHUD6", this.LogicHUD6);
            nbt.m_128379_("LogicHUD7", this.LogicHUD7);
            nbt.m_128379_("LogicHUD8", this.LogicHUD8);
            nbt.m_128379_("LogicHUD9", this.LogicHUD9);
            nbt.m_128379_("MaleDroneAssignedToPlayer", this.MaleDroneAssignedToPlayer);
            nbt.m_128379_("ModelTest", this.ModelTest);
            nbt.m_128379_("nightmode", this.nightmode);
            nbt.m_128379_("NoDronePicked", this.NoDronePicked);
            nbt.m_128379_("OilLow1", this.OilLow1);
            nbt.m_128379_("OverlayLogicSolverTest1", this.OverlayLogicSolverTest1);
            nbt.m_128379_("Patched", this.Patched);
            nbt.m_128379_("patchedHud", this.patchedHud);
            nbt.m_128379_("PlayerArmorLogic", this.PlayerArmorLogic);
            nbt.m_128379_("PlayerIsDrone", this.PlayerIsDrone);
            nbt.m_128379_("PurpleChosen", this.PurpleChosen);
            nbt.m_128379_("RedChosen", this.RedChosen);
            nbt.m_128379_("RightWeapon", this.RightWeapon);
            nbt.m_128379_("RightWeaponHand", this.RightWeaponHand);
            nbt.m_128379_("ScaredEx", this.ScaredEx);
            nbt.m_128379_("sethud1", this.sethud1);
            nbt.m_128379_("sethud2", this.sethud2);
            nbt.m_128379_("sethud3", this.sethud3);
            nbt.m_128379_("SolverDroneVariable1", this.SolverDroneVariable1);
            nbt.m_128379_("SolverPossessionLogic", this.SolverPossessionLogic);
            nbt.m_128379_("Stage_1_April", this.Stage_1_April);
            nbt.m_128379_("Stage_2_April", this.Stage_2_April);
            nbt.m_128379_("SurroudAbso", this.SurroudAbso);
            nbt.m_128379_("surroundvariable", this.surroundvariable);
            nbt.m_128379_("tailon", this.tailon);
            nbt.m_128379_("UnlockedControl", this.UnlockedControl);
            nbt.m_128379_("UnlockedKnife", this.UnlockedKnife);
            nbt.m_128379_("UnlockedNll", this.UnlockedNll);
            nbt.m_128379_("UnlockedSheild", this.UnlockedSheild);
            nbt.m_128379_("UnlockedTeleport", this.UnlockedTeleport);
            nbt.m_128379_("UnlockedZomb", this.UnlockedZomb);
            nbt.m_128379_("UnlockedZombFly", this.UnlockedZombFly);
            nbt.m_128379_("Unpatched", this.Unpatched);
            nbt.m_128379_("wdsolvact", this.wdsolvact);
            nbt.m_128379_("WDTamed", this.WDTamed);
            nbt.m_128379_("WingsIn", this.WingsIn);
            nbt.m_128379_("YellowChosen", this.YellowChosen);
            nbt.m_128379_("ZombHUD", this.ZombHUD);
            nbt.m_128379_("ZombieForm", this.ZombieForm);
            nbt.m_128347_("Booting", this.Booting);
            nbt.m_128347_("Distance", this.Distance);
            nbt.m_128347_("Exp_Points", this.Exp_Points);
            nbt.m_128347_("HoverTimer", this.HoverTimer);
            nbt.m_128347_("murder_coin_amount", this.murder_coin_amount);
            nbt.m_128347_("OilLevel", this.OilLevel);
            nbt.m_128347_("Possess_Numb", this.Possess_Numb);
            nbt.m_128347_("SolverPossessionNumb", this.SolverPossessionNumb);
            nbt.m_128379_("Self_Control", this.Self_Control);
            nbt.m_128379_("AniDisplay", this.AniDisplay);
            nbt.m_128347_("SolverLevel", this.SolverLevel);
            nbt.m_128379_("TKLeft", this.TKLeft);
            nbt.m_128379_("TKRight", this.TKRight);
            nbt.m_128379_("TPLeft", this.TPLeft);
            nbt.m_128379_("TPRight", this.TPRight);
            nbt.m_128379_("KnifeLeft", this.KnifeLeft);
            nbt.m_128379_("KnifeRight", this.KnifeRight);
            nbt.m_128347_("solvdis", this.solvdis);
            nbt.m_128379_("ismenuopen", this.ismenuopen);
            nbt.m_128379_("GUIOpen", this.GUIOpen);
            nbt.m_128379_("PC_OS_ACCESS", this.PC_OS_ACCESS);
            nbt.m_128379_("ERROR_NO_FLOPPY", this.ERROR_NO_FLOPPY);
            nbt.m_128379_("MineOres", this.MineOres);
            nbt.m_128347_("sy", this.sy);
            nbt.m_128347_("sz", this.sz);
            nbt.m_128347_("sx", this.sx);
            nbt.m_128379_("WingSingle", this.WingSingle);
            nbt.m_128379_("DevTest2", this.DevTest2);
            nbt.m_128379_("IsDev", this.IsDev);
            nbt.m_128379_("ZombieWings", this.ZombieWings);
            nbt.m_128379_("DDWings", this.DDWings);
            nbt.m_128379_("WorkerDroneHUD", this.WorkerDroneHUD);
            nbt.m_128379_("SolverDroneHUD", this.SolverDroneHUD);
            nbt.m_128379_("ZombieDroneHUD", this.ZombieDroneHUD);
            nbt.m_128379_("PatchedHUD", this.PatchedHUD);
            nbt.m_128379_("SolverFought", this.SolverFought);
            nbt.m_128379_("ismorphedn", this.ismorphedn);
            nbt.m_128379_("AbilitySolverStrike", this.AbilitySolverStrike);
            nbt.m_128379_("ERROR", this.ERROR);
            nbt.m_128379_("ShieldActive", this.ShieldActive);
            nbt.m_128347_("TKCooldown", this.TKCooldown);
            nbt.m_128379_("ddsolver", this.ddsolver);
            nbt.m_128379_("SolvOverride", this.SolvOverride);
            nbt.m_128379_("WinkEx", this.WinkEx);
            nbt.m_128379_("onground", this.onground);
            nbt.m_128379_("diving", this.diving);
            nbt.m_128379_("BossTier", this.BossTier);
            nbt.m_128379_("FlightTier", this.FlightTier);
            nbt.m_128379_("GroundTeir", this.GroundTeir);
            return nbt;
        }

        public void readNBT(Tag tag) {
            CompoundTag nbt;
            if (tag == null) {
                tag = this.writeNBT();
            }
            if ((nbt = (CompoundTag)tag) == null) {
                nbt = (CompoundTag)this.writeNBT();
            }
            this.d = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("d"));
            this.e = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("e"));
            this.AbilityVariableKnife = nbt.m_128471_("AbilityVariableKnife");
            this.AbilityVariableNullThrow = nbt.m_128471_("AbilityVariableNullThrow");
            this.AbilityVariableSolver = nbt.m_128471_("AbilityVariableSolver");
            this.AbilityVariableSolverThrow = nbt.m_128471_("AbilityVariableSolverThrow");
            this.AbilityVariableTeleport = nbt.m_128471_("AbilityVariableTeleport");
            this.ABSOAbility = nbt.m_128471_("ABSOAbility");
            this.AngryEx = nbt.m_128471_("AngryEx");
            this.AnnoyedEx = nbt.m_128471_("AnnoyedEx");
            this.April_boss_started = nbt.m_128471_("April_boss_started");
            this.beginnerlevel = nbt.m_128471_("beginnerlevel");
            this.bootinglogic = nbt.m_128471_("bootinglogic");
            this.CanDualCommand = nbt.m_128471_("CanDualCommand");
            this.Chainsaws = nbt.m_128471_("Chainsaws");
            this.CynEntityErrVariable = nbt.m_128471_("CynEntityErrVariable");
            this.dddroneidle = nbt.m_128471_("dddroneidle");
            this.DDMurderMode = nbt.m_128471_("DDMurderMode");
            this.delay = nbt.m_128471_("delay");
            this.DevTest = nbt.m_128471_("DevTest");
            this.DisDroneHudVariable = nbt.m_128471_("DisDroneHudVariable");
            this.DisDroneVariable1 = nbt.m_128471_("DisDroneVariable1");
            this.flightanimationvariable = nbt.m_128471_("flightanimationvariable");
            this.flyIdle = nbt.m_128471_("flyIdle");
            this.flyingvariable = nbt.m_128471_("flyingvariable");
            this.GunLeft = nbt.m_128471_("GunLeft");
            this.GunRight = nbt.m_128471_("GunRight");
            this.HoverVariable = nbt.m_128471_("HoverVariable");
            this.HumanVariable = nbt.m_128471_("HumanVariable");
            this.ispatched = nbt.m_128471_("ispatched");
            this.iswalking = nbt.m_128471_("iswalking");
            this.IsWorkerDrone = nbt.m_128471_("IsWorkerDrone");
            this.LaserCannonLeft = nbt.m_128471_("LaserCannonLeft");
            this.LaserCannonRight = nbt.m_128471_("LaserCannonRight");
            this.LeftWeapon = nbt.m_128471_("LeftWeapon");
            this.LeftWeaponHand = nbt.m_128471_("LeftWeaponHand");
            this.LimeChosen = nbt.m_128471_("LimeChosen");
            this.LogicHUD1 = nbt.m_128471_("LogicHUD1");
            this.LogicHUD2 = nbt.m_128471_("LogicHUD2");
            this.LogicHUD3 = nbt.m_128471_("LogicHUD3");
            this.LogicHUD4 = nbt.m_128471_("LogicHUD4");
            this.LogicHUD5 = nbt.m_128471_("LogicHUD5");
            this.LogicHUD6 = nbt.m_128471_("LogicHUD6");
            this.LogicHUD7 = nbt.m_128471_("LogicHUD7");
            this.LogicHUD8 = nbt.m_128471_("LogicHUD8");
            this.LogicHUD9 = nbt.m_128471_("LogicHUD9");
            this.MaleDroneAssignedToPlayer = nbt.m_128471_("MaleDroneAssignedToPlayer");
            this.ModelTest = nbt.m_128471_("ModelTest");
            this.nightmode = nbt.m_128471_("nightmode");
            this.NoDronePicked = nbt.m_128471_("NoDronePicked");
            this.OilLow1 = nbt.m_128471_("OilLow1");
            this.OverlayLogicSolverTest1 = nbt.m_128471_("OverlayLogicSolverTest1");
            this.Patched = nbt.m_128471_("Patched");
            this.patchedHud = nbt.m_128471_("patchedHud");
            this.PlayerArmorLogic = nbt.m_128471_("PlayerArmorLogic");
            this.PlayerIsDrone = nbt.m_128471_("PlayerIsDrone");
            this.PurpleChosen = nbt.m_128471_("PurpleChosen");
            this.RedChosen = nbt.m_128471_("RedChosen");
            this.RightWeapon = nbt.m_128471_("RightWeapon");
            this.RightWeaponHand = nbt.m_128471_("RightWeaponHand");
            this.ScaredEx = nbt.m_128471_("ScaredEx");
            this.sethud1 = nbt.m_128471_("sethud1");
            this.sethud2 = nbt.m_128471_("sethud2");
            this.sethud3 = nbt.m_128471_("sethud3");
            this.SolverDroneVariable1 = nbt.m_128471_("SolverDroneVariable1");
            this.SolverPossessionLogic = nbt.m_128471_("SolverPossessionLogic");
            this.Stage_1_April = nbt.m_128471_("Stage_1_April");
            this.Stage_2_April = nbt.m_128471_("Stage_2_April");
            this.SurroudAbso = nbt.m_128471_("SurroudAbso");
            this.surroundvariable = nbt.m_128471_("surroundvariable");
            this.tailon = nbt.m_128471_("tailon");
            this.UnlockedControl = nbt.m_128471_("UnlockedControl");
            this.UnlockedKnife = nbt.m_128471_("UnlockedKnife");
            this.UnlockedNll = nbt.m_128471_("UnlockedNll");
            this.UnlockedSheild = nbt.m_128471_("UnlockedSheild");
            this.UnlockedTeleport = nbt.m_128471_("UnlockedTeleport");
            this.UnlockedZomb = nbt.m_128471_("UnlockedZomb");
            this.UnlockedZombFly = nbt.m_128471_("UnlockedZombFly");
            this.Unpatched = nbt.m_128471_("Unpatched");
            this.wdsolvact = nbt.m_128471_("wdsolvact");
            this.WDTamed = nbt.m_128471_("WDTamed");
            this.WingsIn = nbt.m_128471_("WingsIn");
            this.YellowChosen = nbt.m_128471_("YellowChosen");
            this.ZombHUD = nbt.m_128471_("ZombHUD");
            this.ZombieForm = nbt.m_128471_("ZombieForm");
            this.Booting = nbt.m_128459_("Booting");
            this.Distance = nbt.m_128459_("Distance");
            this.Exp_Points = nbt.m_128459_("Exp_Points");
            this.HoverTimer = nbt.m_128459_("HoverTimer");
            this.murder_coin_amount = nbt.m_128459_("murder_coin_amount");
            this.OilLevel = nbt.m_128459_("OilLevel");
            this.Possess_Numb = nbt.m_128459_("Possess_Numb");
            this.SolverPossessionNumb = nbt.m_128459_("SolverPossessionNumb");
            this.Self_Control = nbt.m_128471_("Self_Control");
            this.AniDisplay = nbt.m_128471_("AniDisplay");
            this.SolverLevel = nbt.m_128459_("SolverLevel");
            this.TKLeft = nbt.m_128471_("TKLeft");
            this.TKRight = nbt.m_128471_("TKRight");
            this.TPLeft = nbt.m_128471_("TPLeft");
            this.TPRight = nbt.m_128471_("TPRight");
            this.KnifeLeft = nbt.m_128471_("KnifeLeft");
            this.KnifeRight = nbt.m_128471_("KnifeRight");
            this.solvdis = nbt.m_128459_("solvdis");
            this.ismenuopen = nbt.m_128471_("ismenuopen");
            this.GUIOpen = nbt.m_128471_("GUIOpen");
            this.PC_OS_ACCESS = nbt.m_128471_("PC_OS_ACCESS");
            this.ERROR_NO_FLOPPY = nbt.m_128471_("ERROR_NO_FLOPPY");
            this.MineOres = nbt.m_128471_("MineOres");
            this.sy = nbt.m_128459_("sy");
            this.sz = nbt.m_128459_("sz");
            this.sx = nbt.m_128459_("sx");
            this.WingSingle = nbt.m_128471_("WingSingle");
            this.DevTest2 = nbt.m_128471_("DevTest2");
            this.IsDev = nbt.m_128471_("IsDev");
            this.ZombieWings = nbt.m_128471_("ZombieWings");
            this.DDWings = nbt.m_128471_("DDWings");
            this.WorkerDroneHUD = nbt.m_128471_("WorkerDroneHUD");
            this.SolverDroneHUD = nbt.m_128471_("SolverDroneHUD");
            this.ZombieDroneHUD = nbt.m_128471_("ZombieDroneHUD");
            this.PatchedHUD = nbt.m_128471_("PatchedHUD");
            this.SolverFought = nbt.m_128471_("SolverFought");
            this.ismorphedn = nbt.m_128471_("ismorphedn");
            this.AbilitySolverStrike = nbt.m_128471_("AbilitySolverStrike");
            this.ERROR = nbt.m_128471_("ERROR");
            this.ShieldActive = nbt.m_128471_("ShieldActive");
            this.TKCooldown = nbt.m_128459_("TKCooldown");
            this.ddsolver = nbt.m_128471_("ddsolver");
            this.SolvOverride = nbt.m_128471_("SolvOverride");
            this.WinkEx = nbt.m_128471_("WinkEx");
            this.onground = nbt.m_128471_("onground");
            this.diving = nbt.m_128471_("diving");
            this.BossTier = nbt.m_128471_("BossTier");
            this.FlightTier = nbt.m_128471_("FlightTier");
            this.GroundTeir = nbt.m_128471_("GroundTeir");
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("mdsc", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerVariables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readNBT(nbt);
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "mdsc_mapvars";
        public ItemStack a = ItemStack.f_41583_;
        public boolean LogicHUD10 = false;
        public double Local = 0.0;
        public double test2 = 0.0;
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag) {
            MapVariables data = new MapVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
            if (nbt == null) {
                nbt = this.m_7176_(new CompoundTag());
            }
            this.a = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("a"));
            this.LogicHUD10 = nbt.m_128471_("LogicHUD10");
            this.Local = nbt.m_128459_("Local");
            this.test2 = nbt.m_128459_("test2");
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            nbt.m_128365_("a", (Tag)this.a.m_41739_(new CompoundTag()));
            nbt.m_128379_("LogicHUD10", this.LogicHUD10);
            nbt.m_128347_("Local", this.Local);
            nbt.m_128347_("test2", this.test2);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.m_77762_();
            if (world instanceof Level && !world.m_5776_()) {
                MdscMod.PACKET_HANDLER.send(PacketDistributor.ALL.noArg(), (Object)new SavedDataSyncMessage(0, this));
            }
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.m_6018_().m_7654_().m_129880_(Level.f_46428_).m_8895_().m_164861_(e -> MapVariables.load(e), MapVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "mdsc_worldvars";
        public ItemStack c = ItemStack.f_41583_;
        public boolean ribsin = false;
        public double DeadOilLvl = 0.0;
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag) {
            WorldVariables data = new WorldVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
            this.c = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("c"));
            this.ribsin = nbt.m_128471_("ribsin");
            this.DeadOilLvl = nbt.m_128459_("DeadOilLvl");
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            nbt.m_128365_("c", (Tag)this.c.m_41739_(new CompoundTag()));
            nbt.m_128379_("ribsin", this.ribsin);
            nbt.m_128347_("DeadOilLvl", this.DeadOilLvl);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            Level level;
            this.m_77762_();
            if (world instanceof Level && !(level = (Level)world).m_5776_()) {
                MdscMod.PACKET_HANDLER.send(PacketDistributor.DIMENSION.with(() -> ((Level)level).m_46472_()), (Object)new SavedDataSyncMessage(1, this));
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.m_8895_().m_164861_(e -> WorldVariables.load(e), WorldVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                for (Entity entityiterator : new ArrayList(event.getEntity().m_9236_().m_6907_())) {
                    ((PlayerVariables)entityiterator.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables(entityiterator);
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                for (Entity entityiterator : new ArrayList(event.getEntity().m_9236_().m_6907_())) {
                    ((PlayerVariables)entityiterator.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables(entityiterator);
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                for (Entity entityiterator : new ArrayList(event.getEntity().m_9236_().m_6907_())) {
                    ((PlayerVariables)entityiterator.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables(entityiterator);
                }
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            clone.e = original.e;
            clone.AbilityVariableKnife = original.AbilityVariableKnife;
            clone.AbilityVariableNullThrow = original.AbilityVariableNullThrow;
            clone.AbilityVariableSolver = original.AbilityVariableSolver;
            clone.AbilityVariableSolverThrow = original.AbilityVariableSolverThrow;
            clone.AbilityVariableTeleport = original.AbilityVariableTeleport;
            clone.ABSOAbility = original.ABSOAbility;
            clone.AngryEx = original.AngryEx;
            clone.AnnoyedEx = original.AnnoyedEx;
            clone.beginnerlevel = original.beginnerlevel;
            clone.bootinglogic = original.bootinglogic;
            clone.CanDualCommand = original.CanDualCommand;
            clone.CynEntityErrVariable = original.CynEntityErrVariable;
            clone.dddroneidle = original.dddroneidle;
            clone.DDMurderMode = original.DDMurderMode;
            clone.delay = original.delay;
            clone.DevTest = original.DevTest;
            clone.DisDroneHudVariable = original.DisDroneHudVariable;
            clone.DisDroneVariable1 = original.DisDroneVariable1;
            clone.flightanimationvariable = original.flightanimationvariable;
            clone.flyIdle = original.flyIdle;
            clone.flyingvariable = original.flyingvariable;
            clone.GunLeft = original.GunLeft;
            clone.GunRight = original.GunRight;
            clone.HoverVariable = original.HoverVariable;
            clone.HumanVariable = original.HumanVariable;
            clone.ispatched = original.ispatched;
            clone.IsWorkerDrone = original.IsWorkerDrone;
            clone.LaserCannonLeft = original.LaserCannonLeft;
            clone.LaserCannonRight = original.LaserCannonRight;
            clone.LeftWeapon = original.LeftWeapon;
            clone.LeftWeaponHand = original.LeftWeaponHand;
            clone.LimeChosen = original.LimeChosen;
            clone.LogicHUD1 = original.LogicHUD1;
            clone.LogicHUD2 = original.LogicHUD2;
            clone.LogicHUD3 = original.LogicHUD3;
            clone.LogicHUD4 = original.LogicHUD4;
            clone.LogicHUD5 = original.LogicHUD5;
            clone.LogicHUD6 = original.LogicHUD6;
            clone.LogicHUD7 = original.LogicHUD7;
            clone.LogicHUD8 = original.LogicHUD8;
            clone.LogicHUD9 = original.LogicHUD9;
            clone.MaleDroneAssignedToPlayer = original.MaleDroneAssignedToPlayer;
            clone.ModelTest = original.ModelTest;
            clone.NoDronePicked = original.NoDronePicked;
            clone.OilLow1 = original.OilLow1;
            clone.OverlayLogicSolverTest1 = original.OverlayLogicSolverTest1;
            clone.Patched = original.Patched;
            clone.patchedHud = original.patchedHud;
            clone.PlayerArmorLogic = original.PlayerArmorLogic;
            clone.PlayerIsDrone = original.PlayerIsDrone;
            clone.PurpleChosen = original.PurpleChosen;
            clone.RedChosen = original.RedChosen;
            clone.RightWeapon = original.RightWeapon;
            clone.RightWeaponHand = original.RightWeaponHand;
            clone.ScaredEx = original.ScaredEx;
            clone.sethud1 = original.sethud1;
            clone.sethud2 = original.sethud2;
            clone.sethud3 = original.sethud3;
            clone.SolverDroneVariable1 = original.SolverDroneVariable1;
            clone.SolverPossessionLogic = original.SolverPossessionLogic;
            clone.SurroudAbso = original.SurroudAbso;
            clone.surroundvariable = original.surroundvariable;
            clone.tailon = original.tailon;
            clone.UnlockedControl = original.UnlockedControl;
            clone.UnlockedKnife = original.UnlockedKnife;
            clone.UnlockedNll = original.UnlockedNll;
            clone.UnlockedSheild = original.UnlockedSheild;
            clone.UnlockedTeleport = original.UnlockedTeleport;
            clone.UnlockedZomb = original.UnlockedZomb;
            clone.UnlockedZombFly = original.UnlockedZombFly;
            clone.Unpatched = original.Unpatched;
            clone.wdsolvact = original.wdsolvact;
            clone.WingsIn = original.WingsIn;
            clone.YellowChosen = original.YellowChosen;
            clone.ZombHUD = original.ZombHUD;
            clone.ZombieForm = original.ZombieForm;
            clone.Booting = original.Booting;
            clone.Exp_Points = original.Exp_Points;
            clone.HoverTimer = original.HoverTimer;
            clone.murder_coin_amount = original.murder_coin_amount;
            clone.OilLevel = original.OilLevel;
            clone.Possess_Numb = original.Possess_Numb;
            clone.SolverPossessionNumb = original.SolverPossessionNumb;
            clone.Self_Control = original.Self_Control;
            clone.SolverLevel = original.SolverLevel;
            clone.TKLeft = original.TKLeft;
            clone.TKRight = original.TKRight;
            clone.TPLeft = original.TPLeft;
            clone.TPRight = original.TPRight;
            clone.KnifeLeft = original.KnifeLeft;
            clone.KnifeRight = original.KnifeRight;
            clone.ismenuopen = original.ismenuopen;
            clone.PC_OS_ACCESS = original.PC_OS_ACCESS;
            clone.MineOres = original.MineOres;
            clone.WingSingle = original.WingSingle;
            clone.DevTest2 = original.DevTest2;
            clone.IsDev = original.IsDev;
            clone.ZombieWings = original.ZombieWings;
            clone.DDWings = original.DDWings;
            clone.WorkerDroneHUD = original.WorkerDroneHUD;
            clone.SolverDroneHUD = original.SolverDroneHUD;
            clone.ZombieDroneHUD = original.ZombieDroneHUD;
            clone.PatchedHUD = original.PatchedHUD;
            clone.SolverFought = original.SolverFought;
            clone.ismorphedn = original.ismorphedn;
            clone.AbilitySolverStrike = original.AbilitySolverStrike;
            clone.TKCooldown = original.TKCooldown;
            clone.ddsolver = original.ddsolver;
            clone.SolvOverride = original.SolvOverride;
            clone.WinkEx = original.WinkEx;
            clone.onground = original.onground;
            clone.diving = original.diving;
            clone.BossTier = original.BossTier;
            clone.FlightTier = original.FlightTier;
            clone.GroundTeir = original.GroundTeir;
            if (!event.isWasDeath()) {
                clone.d = original.d;
                clone.April_boss_started = original.April_boss_started;
                clone.Chainsaws = original.Chainsaws;
                clone.iswalking = original.iswalking;
                clone.nightmode = original.nightmode;
                clone.Stage_1_April = original.Stage_1_April;
                clone.Stage_2_April = original.Stage_2_April;
                clone.WDTamed = original.WDTamed;
                clone.Distance = original.Distance;
                clone.AniDisplay = original.AniDisplay;
                clone.solvdis = original.solvdis;
                clone.GUIOpen = original.GUIOpen;
                clone.ERROR_NO_FLOPPY = original.ERROR_NO_FLOPPY;
                clone.sy = original.sy;
                clone.sz = original.sz;
                clone.sx = original.sx;
                clone.ERROR = original.ERROR;
                clone.ShieldActive = original.ShieldActive;
            }
            if (!event.getEntity().m_9236_().m_5776_()) {
                for (Entity entityiterator : new ArrayList(event.getEntity().m_9236_().m_6907_())) {
                    ((PlayerVariables)entityiterator.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables(entityiterator);
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().m_9236_());
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_());
                if (mapdata != null) {
                    MdscMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(0, mapdata));
                }
                if (worlddata != null) {
                    MdscMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            WorldVariables worlddata;
            if (!event.getEntity().m_9236_().m_5776_() && (worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_())) != null) {
                MdscMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
            }
        }
    }
}

