/*
 * Decompiled with CFR 0.152.
 */
package mdsc.network;

import java.util.HashMap;
import java.util.function.Supplier;
import mdsc.MdscMod;
import mdsc.procedures.SetOil100Procedure;
import mdsc.procedures.SetOil15Procedure;
import mdsc.procedures.SetOil80Procedure;
import mdsc.procedures.SetOil85Procedure;
import mdsc.procedures.SetOil90Procedure;
import mdsc.procedures.SetOil95Procedure;
import mdsc.world.inventory.OilMeniuMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class OilMeniuButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public OilMeniuButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public OilMeniuButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(OilMeniuButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(OilMeniuButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            OilMeniuButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = OilMeniuMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            SetOil100Procedure.execute((Entity)entity);
        }
        if (buttonID == 1) {
            SetOil90Procedure.execute((Entity)entity);
        }
        if (buttonID == 2) {
            SetOil85Procedure.execute((Entity)entity);
        }
        if (buttonID == 3) {
            SetOil80Procedure.execute((Entity)entity);
        }
        if (buttonID == 4) {
            SetOil15Procedure.execute((Entity)entity);
        }
        if (buttonID == 5) {
            SetOil95Procedure.execute((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        MdscMod.addNetworkMessage(OilMeniuButtonMessage.class, OilMeniuButtonMessage::buffer, OilMeniuButtonMessage::new, OilMeniuButtonMessage::handler);
    }
}

