/*
 * Decompiled with CFR 0.152.
 */
package mdsc;

import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class EntityGetter {
    private static final Predicate<Entity> IS_VISIBLE = e -> !e.m_5833_() && e.m_6087_();

    @OnlyIn(value=Dist.CLIENT)
    public static LivingEntity getEntityInCrosshair(float partialTicks) {
        Entity entity;
        Vec3 look;
        Vec3 max;
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null || mc.f_91074_ == null) {
            return null;
        }
        Entity viewer = mc.m_91288_();
        if (viewer == null) {
            return null;
        }
        double reachDistance = mc.f_91072_.m_105286_();
        Vec3 position = viewer.m_20299_(partialTicks);
        EntityHitResult result = ProjectileUtil.m_37287_((Entity)viewer, (Vec3)position, (Vec3)(max = position.m_82549_((look = viewer.m_20252_(1.0f)).m_82490_(reachDistance))), (AABB)viewer.m_20191_().m_82369_(look.m_82490_(reachDistance)).m_82400_(1.0), IS_VISIBLE, (double)(reachDistance * reachDistance));
        if (result == null || !((entity = result.m_82443_()) instanceof LivingEntity)) {
            return null;
        }
        LivingEntity target = (LivingEntity)entity;
        BlockHitResult blockHit = mc.f_91073_.m_45547_(EntityGetter.setupRayTraceContext((Player)mc.f_91074_, reachDistance, ClipContext.Fluid.NONE));
        if (blockHit.m_6662_() == HitResult.Type.MISS || blockHit.m_82450_().m_82554_(position) > (double)target.m_20270_((Entity)mc.f_91074_)) {
            return target;
        }
        return null;
    }

    private static ClipContext setupRayTraceContext(Player player, double distance, ClipContext.Fluid fluidHandling) {
        Vec3 fromPos = player.m_20299_(1.0f);
        Vec3 toPos = fromPos.m_82549_(Vec3.m_82498_((float)player.m_146909_(), (float)player.m_146908_()).m_82490_(distance));
        return new ClipContext(fromPos, toPos, ClipContext.Block.OUTLINE, fluidHandling, (Entity)player);
    }
}

