/*
 * Decompiled with CFR 0.152.
 */
package mdsc.network;

import java.util.HashMap;
import java.util.function.Supplier;
import mdsc.MdscMod;
import mdsc.procedures.DisasemblyRequiredProcedure;
import mdsc.procedures.EternalDreamPlayProcedure;
import mdsc.procedures.IntroPlayProcedure;
import mdsc.procedures.LetMeInPlayProcedure;
import mdsc.procedures.MurderOnMyMindPlayProcedure;
import mdsc.world.inventory.IpodnoriMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class IpodnoriButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public IpodnoriButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public IpodnoriButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(IpodnoriButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(IpodnoriButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            IpodnoriButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = IpodnoriMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 1) {
            EternalDreamPlayProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 2) {
            DisasemblyRequiredProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 4) {
            LetMeInPlayProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 9) {
            IntroPlayProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 10) {
            MurderOnMyMindPlayProcedure.execute((LevelAccessor)world, x, y, z);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        MdscMod.addNetworkMessage(IpodnoriButtonMessage.class, IpodnoriButtonMessage::buffer, IpodnoriButtonMessage::new, IpodnoriButtonMessage::handler);
    }
}

