/*
 * Decompiled with CFR 0.152.
 */
package mdsc.network;

import java.util.HashMap;
import java.util.function.Supplier;
import mdsc.MdscMod;
import mdsc.procedures.PageNextSolverProcedure;
import mdsc.procedures.SetClearSolverBothProcedure;
import mdsc.procedures.SetKnifeLeftProcedure;
import mdsc.procedures.SetKnifeRightProcedure;
import mdsc.procedures.SetNullLeftProcedure;
import mdsc.procedures.SetNullRightProcedure;
import mdsc.procedures.SetSolverStrikeFalseProcedure;
import mdsc.procedures.SetSolverStrikeTrueProcedure;
import mdsc.procedures.SetSolverThrowFalseProcedure;
import mdsc.procedures.SetSolverThrowTrueProcedure;
import mdsc.procedures.SetTKLeftProcedure;
import mdsc.procedures.SetTKRightProcedure;
import mdsc.procedures.SetTPLeftProcedure;
import mdsc.procedures.SetTPRightProcedure;
import mdsc.procedures.SetupZombieProcedure;
import mdsc.world.inventory.RainbowSolverMenuMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class RainbowSolverMenuButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public RainbowSolverMenuButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public RainbowSolverMenuButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(RainbowSolverMenuButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(RainbowSolverMenuButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            RainbowSolverMenuButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = RainbowSolverMenuMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            PageNextSolverProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 1) {
            SetTKLeftProcedure.execute((Entity)entity);
        }
        if (buttonID == 2) {
            SetTKRightProcedure.execute((Entity)entity);
        }
        if (buttonID == 3) {
            SetTPLeftProcedure.execute((Entity)entity);
        }
        if (buttonID == 4) {
            SetTPRightProcedure.execute((Entity)entity);
        }
        if (buttonID == 5) {
            SetNullRightProcedure.execute((Entity)entity);
        }
        if (buttonID == 6) {
            SetNullLeftProcedure.execute((Entity)entity);
        }
        if (buttonID == 7) {
            SetKnifeLeftProcedure.execute((Entity)entity);
        }
        if (buttonID == 8) {
            SetKnifeRightProcedure.execute((Entity)entity);
        }
        if (buttonID == 9) {
            SetSolverThrowTrueProcedure.execute((Entity)entity);
        }
        if (buttonID == 10) {
            SetSolverThrowFalseProcedure.execute((Entity)entity);
        }
        if (buttonID == 11) {
            SetSolverStrikeTrueProcedure.execute((Entity)entity);
        }
        if (buttonID == 12) {
            SetSolverStrikeFalseProcedure.execute((Entity)entity);
        }
        if (buttonID == 13) {
            SetupZombieProcedure.execute((Entity)entity);
        }
        if (buttonID == 14) {
            SetClearSolverBothProcedure.execute((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        MdscMod.addNetworkMessage(RainbowSolverMenuButtonMessage.class, RainbowSolverMenuButtonMessage::buffer, RainbowSolverMenuButtonMessage::new, RainbowSolverMenuButtonMessage::handler);
    }
}

