/*
 * Decompiled with CFR 0.152.
 */
package mdsc.network;

import java.util.HashMap;
import java.util.function.Supplier;
import mdsc.MdscMod;
import mdsc.procedures.AngryExpressionProcedure;
import mdsc.procedures.AnnoyedExpressionProcedure;
import mdsc.procedures.GlassesExpressionProcedure;
import mdsc.procedures.NormalExpressionProcedure;
import mdsc.procedures.ScaredExpressionProcedure;
import mdsc.procedures.WinkExpressionProcedure;
import mdsc.world.inventory.TaskManagerBlueMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class TaskManagerBlueButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public TaskManagerBlueButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public TaskManagerBlueButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(TaskManagerBlueButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(TaskManagerBlueButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            TaskManagerBlueButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = TaskManagerBlueMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            NormalExpressionProcedure.execute((Entity)entity);
        }
        if (buttonID == 1) {
            ScaredExpressionProcedure.execute((Entity)entity);
        }
        if (buttonID == 2) {
            AngryExpressionProcedure.execute((Entity)entity);
        }
        if (buttonID == 3) {
            AnnoyedExpressionProcedure.execute((Entity)entity);
        }
        if (buttonID == 4) {
            WinkExpressionProcedure.execute((Entity)entity);
        }
        if (buttonID == 5) {
            GlassesExpressionProcedure.execute((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        MdscMod.addNetworkMessage(TaskManagerBlueButtonMessage.class, TaskManagerBlueButtonMessage::buffer, TaskManagerBlueButtonMessage::new, TaskManagerBlueButtonMessage::handler);
    }
}

