/*
 * Decompiled with CFR 0.152.
 */
package vonsnake.swayaway;

import com.mojang.serialization.Codec;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.client.OptionInstance;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;
import vonsnake.swayaway.CamBobOptions;

@EventBusSubscriber(modid="swayaway", value={Dist.CLIENT})
public class SwayAwayConfig {
    private static final ModConfigSpec.Builder BUILDER = new ModConfigSpec.Builder();
    public static final ModConfigSpec.BooleanValue BOB_CAM = BUILDER.comment(" Whether the camera bob is enabled. This works in conjunction with the game's bobView setting to determine the mods behaviour.").define("bobCam", true);
    public static final ModConfigSpec SPEC = BUILDER.build();
    public static boolean bobCam;
    public static OptionInstance<CamBobOptions> vanillaBobCamOption;

    public static void setBobCam(boolean value) {
        bobCam = value;
        BOB_CAM.set((Object)value);
        BOB_CAM.save();
    }

    public static CamBobOptions getCurrentCamBobOption() {
        Minecraft instance = Minecraft.getInstance();
        boolean bobView = (Boolean)instance.options.bobView().get();
        boolean camBob = bobCam;
        if (!bobView && !camBob) {
            return CamBobOptions.DISABLED;
        }
        if (bobView && !camBob) {
            return CamBobOptions.MODELONLY;
        }
        if (bobView && camBob) {
            return CamBobOptions.FULL;
        }
        return CamBobOptions.FULL;
    }

    public static void applyCamBobOption(CamBobOptions option) {
        Minecraft instance = Minecraft.getInstance();
        instance.options.bobView().set((Object)(option.getId() > 0 ? 1 : 0));
        SwayAwayConfig.setBobCam(option == CamBobOptions.FULL);
    }

    private static void createCamBobOptionInstance() {
        if (vanillaBobCamOption != null) {
            return;
        }
        vanillaBobCamOption = new OptionInstance("options.viewBobbing", OptionInstance.noTooltip(), OptionInstance.forOptionEnum(), (OptionInstance.ValueSet)new OptionInstance.Enum(Arrays.asList(CamBobOptions.values()), Codec.INT.xmap(CamBobOptions::byId, CamBobOptions::getId)), (Object)SwayAwayConfig.getCurrentCamBobOption(), val -> SwayAwayConfig.applyCamBobOption(val));
    }

    @SubscribeEvent
    protected static void onLoad(ModConfigEvent event) {
        bobCam = (Boolean)BOB_CAM.get();
        SwayAwayConfig.createCamBobOptionInstance();
    }
}

