/*
 * Decompiled with CFR 0.152.
 */
package vonsnake.swayaway;

import com.mojang.serialization.Codec;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.client.OptionInstance;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import vonsnake.swayaway.CamBobOptions;

@Mod.EventBusSubscriber(modid="swayaway", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class SwayAwayConfig {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec.BooleanValue BOB_CAM = BUILDER.comment(" Whether the camera bob is enabled. This works in conjunction with the game's bobView setting to determine the mods behaviour.").define("bobCam", true);
    public static final ForgeConfigSpec SPEC = BUILDER.build();
    public static boolean bobCam;
    public static OptionInstance<CamBobOptions> vanillaBobCamOption;

    public static void setBobCam(boolean value) {
        bobCam = value;
        BOB_CAM.set((Object)value);
        BOB_CAM.save();
    }

    public static CamBobOptions getCurrentCamBobOption() {
        Minecraft instance = Minecraft.m_91087_();
        boolean bobView = (Boolean)instance.f_91066_.m_231830_().m_231551_();
        boolean camBob = bobCam;
        if (!bobView && !camBob) {
            return CamBobOptions.DISABLED;
        }
        if (bobView && !camBob) {
            return CamBobOptions.MODELONLY;
        }
        if (bobView && camBob) {
            return CamBobOptions.FULL;
        }
        return CamBobOptions.FULL;
    }

    public static void applyCamBobOption(CamBobOptions option) {
        Minecraft instance = Minecraft.m_91087_();
        instance.f_91066_.m_231830_().m_231514_((Object)(option.m_35965_() > 0 ? 1 : 0));
        SwayAwayConfig.setBobCam(option == CamBobOptions.FULL);
    }

    private static void createCamBobOptionInstance() {
        if (vanillaBobCamOption != null) {
            return;
        }
        vanillaBobCamOption = new OptionInstance("options.viewBobbing", OptionInstance.m_231498_(), OptionInstance.m_231546_(), (OptionInstance.ValueSet)new OptionInstance.Enum(Arrays.asList(CamBobOptions.values()), Codec.INT.xmap(CamBobOptions::byId, CamBobOptions::m_35965_)), (Object)SwayAwayConfig.getCurrentCamBobOption(), val -> SwayAwayConfig.applyCamBobOption(val));
    }

    @SubscribeEvent
    protected static void onLoad(ModConfigEvent event) {
        bobCam = (Boolean)BOB_CAM.get();
        SwayAwayConfig.createCamBobOptionInstance();
    }
}

