/*
 * Decompiled with CFR 0.152.
 */
package fr.gallonemilien.speed;

import fr.gallonemilien.DopedHorses;
import fr.gallonemilien.cache.CacheManager;
import fr.gallonemilien.items.ShoeItem;
import fr.gallonemilien.persistence.DopedHorseEntity;
import fr.gallonemilien.speed.BlockSpeed;
import java.util.function.Function;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1496;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_5134;

public class HorseSpeedManager {
    public static final double DEFAULT_SPEED_MODIFIER = 0.0;
    private static final class_2960 HORSE_SPEED_BOOST_ID = DopedHorses.id("horse_speed_boost_modifier");
    private static final class_2960 HORSE_SHOES_BOOST_ID = DopedHorses.id("horse_shoes_boost_modifier");
    private static final class_2960 HORSE_SHOES_ARMOR_ID = DopedHorses.id("horse_shoes_armor_modifier");
    private static final class_2960 HORSE_SHOES_JUMP_ID = DopedHorses.id("horse_shoes_jump_modifier");
    private static final class_2960 HORSE_SHOES_STEP_HEIGHT_ID = DopedHorses.id("horse_shoes_step_height_modifier");
    private static final class_2960 HORSE_SHOES_SAFE_FALL_ID = DopedHorses.id("horse_shoes_safe_fall_modifier");
    private static final CacheManager cacheManager = CacheManager.getInstance();
    private static final BlockSpeed blockSpeedManager = BlockSpeed.getInstance();

    private static boolean serverMiddleware(class_1309 entity) {
        return !entity.method_37908().field_9236;
    }

    public static class_1324 getSpeedAttribute(class_1496 horse) {
        return horse.method_5996(class_5134.field_23719);
    }

    public static class_1324 getStepHeight(class_1496 horse) {
        return horse.method_5996(class_5134.field_47761);
    }

    public static class_1324 getArmorAttribute(class_1496 horse) {
        return horse.method_5996(class_5134.field_23724);
    }

    public static class_1324 getJumpAttribute(class_1496 horse) {
        return horse.method_5996(class_5134.field_23728);
    }

    public static class_1324 getSafeFallAttribute(class_1496 horse) {
        return horse.method_5996(class_5134.field_49079);
    }

    public static void updateHorseShoes(class_1496 horse, class_1792 item) {
        if (HorseSpeedManager.serverMiddleware((class_1309)horse)) {
            HorseSpeedManager.applyShoeModifier(horse, item, HorseSpeedManager.getSpeedAttribute(horse), HORSE_SHOES_BOOST_ID, ShoeItem::getSpeedModifier);
            HorseSpeedManager.applyShoeModifier(horse, item, HorseSpeedManager.getStepHeight(horse), HORSE_SHOES_STEP_HEIGHT_ID, ShoeItem::getStepHeightModifier);
            HorseSpeedManager.applyShoeModifier(horse, item, HorseSpeedManager.getJumpAttribute(horse), HORSE_SHOES_JUMP_ID, ShoeItem::getJumpModifier);
            HorseSpeedManager.applyShoeModifier(horse, item, HorseSpeedManager.getArmorAttribute(horse), HORSE_SHOES_ARMOR_ID, ShoeItem::getArmorModifier);
            HorseSpeedManager.applyShoeModifier(horse, item, HorseSpeedManager.getSafeFallAttribute(horse), HORSE_SHOES_SAFE_FALL_ID, ShoeItem::calculateSafeFallBonus);
        }
    }

    public static void updateHorseSpeed(class_1496 horse) {
        if (HorseSpeedManager.serverMiddleware((class_1309)horse)) {
            DopedHorseEntity container;
            class_1792 class_17922;
            if (horse instanceof DopedHorseEntity && (class_17922 = (container = (DopedHorseEntity)horse).dopedhorses$getShoeContainer().method_5438(0).method_7909()) instanceof ShoeItem) {
                ShoeItem item = (ShoeItem)class_17922;
                HorseSpeedManager.updateHorseShoes(horse, item);
            }
            class_2338 horsePosition = horse.method_23312();
            class_2248 blockBeneathHorse = horse.method_37908().method_8320(horsePosition).method_26204();
            if (horse instanceof DopedHorseEntity) {
                DopedHorseEntity dopedHorseEntity = (DopedHorseEntity)horse;
                dopedHorseEntity.dopedhorses$setBlockUnder(blockBeneathHorse);
            }
            if (!HorseSpeedManager.isLastBlockComputedTheSame(horse, blockBeneathHorse)) {
                cacheManager.putLastWalkedOnBlockId(horse.method_5667(), blockBeneathHorse.method_63499());
                double blockSpeed = blockSpeedManager.getBlockSpeed(blockBeneathHorse);
                if (cacheManager.getHorseMultiplier(horse.method_5667()) != blockSpeed) {
                    HorseSpeedManager.applySpeedModifier(horse, blockSpeed);
                }
            }
        }
    }

    private static boolean isLastBlockComputedTheSame(class_1496 horse, class_2248 block) {
        return cacheManager.getLastWalkedOnBlockId(horse.method_5667()).equals(block.method_63499());
    }

    private static void applyShoeModifier(class_1496 horse, class_1792 item, class_1324 attribute, class_2960 modifierId, Function<ShoeItem, Double> modifierFunction) {
        if (HorseSpeedManager.serverMiddleware((class_1309)horse)) {
            if (item instanceof ShoeItem) {
                ShoeItem shoes = (ShoeItem)item;
                Double lastValue = cacheManager.getHorseShoeAttribute(horse.method_5667(), modifierId);
                double newValue = modifierFunction.apply(shoes);
                if (lastValue == null || lastValue != newValue) {
                    attribute.method_6200(modifierId);
                    attribute.method_26835(new class_1322(modifierId, newValue, class_1322.class_1323.field_6328));
                    cacheManager.putHorseShoeAttribute(horse.method_5667(), modifierId, newValue);
                }
            } else {
                attribute.method_6200(modifierId);
                cacheManager.removeHorseShoeAttribute(horse.method_5667());
            }
        }
    }

    private static void applySpeedModifier(class_1496 horse, double speedMultiplier) {
        if (HorseSpeedManager.serverMiddleware((class_1309)horse)) {
            HorseSpeedManager.getSpeedAttribute(horse).method_6200(HORSE_SPEED_BOOST_ID);
            HorseSpeedManager.getSpeedAttribute(horse).method_26835(new class_1322(HORSE_SPEED_BOOST_ID, speedMultiplier, class_1322.class_1323.field_6330));
            cacheManager.putHorseMultiplier(horse.method_5667(), speedMultiplier);
        }
    }
}

