/*
 * Decompiled with CFR 0.152.
 */
package fr.gallonemilien.cache;

import fr.gallonemilien.cache.Resetable;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.resources.ResourceLocation;

public class CacheManager
implements Resetable {
    private final ConcurrentHashMap<UUID, Double> horsesMultiplierCache = new ConcurrentHashMap();
    private final ConcurrentHashMap<UUID, String> lastWalkedOnBlockId = new ConcurrentHashMap();
    private final Map<UUID, Map<ResourceLocation, Double>> horseShoeAttributes = new ConcurrentHashMap<UUID, Map<ResourceLocation, Double>>();

    private CacheManager() {
    }

    public Double getHorseShoeAttribute(UUID horseId, ResourceLocation modifierId) {
        Map<ResourceLocation, Double> attrMap = this.horseShoeAttributes.get(horseId);
        if (attrMap == null) {
            return null;
        }
        return attrMap.get(modifierId);
    }

    public void putHorseShoeAttribute(UUID horseId, ResourceLocation modifierId, double value) {
        this.horseShoeAttributes.computeIfAbsent(horseId, uuid -> new HashMap()).put(modifierId, value);
    }

    public void removeHorseShoeAttribute(UUID horseId) {
        this.horseShoeAttributes.remove(horseId);
    }

    public static CacheManager getInstance() {
        return Holder.INSTANCE;
    }

    public void putLastWalkedOnBlockId(UUID uuid, String blockId) {
        this.lastWalkedOnBlockId.put(uuid, blockId);
    }

    public String getLastWalkedOnBlockId(UUID uuid) {
        return this.lastWalkedOnBlockId.getOrDefault(uuid, "");
    }

    public void putHorseMultiplier(UUID uuid, double value) {
        this.horsesMultiplierCache.put(uuid, value);
    }

    public double getHorseMultiplier(UUID uuid) {
        return this.horsesMultiplierCache.getOrDefault(uuid, 0.0);
    }

    @Override
    public void reset() {
        this.horsesMultiplierCache.clear();
        this.lastWalkedOnBlockId.clear();
        this.horseShoeAttributes.clear();
    }

    private static class Holder {
        private static final CacheManager INSTANCE = new CacheManager();

        private Holder() {
        }
    }
}

