/*
 * Decompiled with CFR 0.152.
 */
package fr.gallonemilien.items;

import fr.gallonemilien.DopedHorses;
import fr.gallonemilien.config.ConfigDataType;
import fr.gallonemilien.config.ConfigMaterialType;
import fr.gallonemilien.config.ModConfig;
import fr.gallonemilien.items.DopedHorsesTypes;
import fr.gallonemilien.items.ShoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.equipment.ArmorMaterial;
import net.minecraft.world.item.equipment.ArmorMaterials;
import org.apache.commons.lang3.tuple.Pair;

public enum ShoeType implements DopedHorsesTypes<ShoeItem>
{
    IRON("iron_horse_shoes", ArmorMaterials.IRON, 0),
    GOLD("gold_horse_shoes", ArmorMaterials.GOLD, 1),
    DIAMOND("diamond_horse_shoes", ArmorMaterials.DIAMOND, 2),
    NETHERITE("netherite_horse_shoes", ArmorMaterials.NETHERITE, 3);

    private final String name;
    private final ArmorMaterial material;
    private final int identifier;
    private double speedModifier;
    private double jumpModifier;
    private double armorModifier;
    private double stepHeightModifier;

    private ShoeType(String name, ArmorMaterial material, int identifier) {
        this.name = name;
        this.material = material;
        this.identifier = identifier;
    }

    @Override
    public ShoeItem getItem() {
        return new ShoeItem(this.getItemProperties(), this);
    }

    @Override
    public Item.Properties getItemProperties() {
        Item.Properties prop = new Item.Properties().stacksTo(1).setId(this.getResourceKey()).enchantable(1).arch$tab(DopedHorses.TAB);
        if (this.material == ArmorMaterials.NETHERITE) {
            prop.fireResistant();
        }
        return prop;
    }

    public static void refreshValues() {
        ModConfig config = DopedHorses.getConfig();
        for (ShoeType type : ShoeType.values()) {
            ConfigMaterialType matType = ConfigMaterialType.valueOf(type.name().toUpperCase());
            type.speedModifier = config.getModifier((Pair<ConfigDataType, ConfigMaterialType>)Pair.of((Object)((Object)ConfigDataType.SHOE), (Object)((Object)matType)));
            type.jumpModifier = config.getModifier((Pair<ConfigDataType, ConfigMaterialType>)Pair.of((Object)((Object)ConfigDataType.JUMP), (Object)((Object)matType)));
            type.armorModifier = config.getModifier((Pair<ConfigDataType, ConfigMaterialType>)Pair.of((Object)((Object)ConfigDataType.ARMOR), (Object)((Object)matType)));
            type.stepHeightModifier = config.getModifier((Pair<ConfigDataType, ConfigMaterialType>)Pair.of((Object)((Object)ConfigDataType.STEP_HEIGHT), (Object)((Object)matType)));
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    public ArmorMaterial getMaterial() {
        return this.material;
    }

    public int getIdentifier() {
        return this.identifier;
    }

    public double getSpeedModifier() {
        return this.speedModifier;
    }

    public double getJumpModifier() {
        return this.jumpModifier;
    }

    public double getArmorModifier() {
        return this.armorModifier;
    }

    public double getStepHeightModifier() {
        return this.stepHeightModifier;
    }
}

