/*
 * Decompiled with CFR 0.152.
 */
package fr.gallonemilien.mixin;

import fr.gallonemilien.DopedHorses;
import fr.gallonemilien.helper.GuiPosHelper;
import fr.gallonemilien.items.ShoeItem;
import fr.gallonemilien.persistence.DopedHorseEntity;
import fr.gallonemilien.speed.HorseSpeedManager;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.HorseInventoryMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={HorseInventoryMenu.class})
public abstract class HorseInventoryMenuMixin
extends AbstractContainerMenu {
    @Unique
    private static final ResourceLocation SHOE_LOCATION = DopedHorses.id("horse_shoe");

    protected HorseInventoryMenuMixin(@Nullable MenuType<?> menuType, int i) {
        super(menuType, i);
    }

    @Inject(method={"<init>(ILnet/minecraft/world/entity/player/Inventory;Lnet/minecraft/world/Container;Lnet/minecraft/world/entity/animal/horse/AbstractHorse;I)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/inventory/HorseInventoryMenu;addSlot(Lnet/minecraft/world/inventory/Slot;)Lnet/minecraft/world/inventory/Slot;")})
    public void constructor(int i, Inventory inventory, Container container, final AbstractHorse abstractHorse, int j, CallbackInfo ci) {
        if (abstractHorse instanceof DopedHorseEntity) {
            final DopedHorseEntity dopedHorseEntity = (DopedHorseEntity)abstractHorse;
            GuiPosHelper.Position pos = GuiPosHelper.getSlotPosition(abstractHorse);
            this.addSlot(new Slot(this, dopedHorseEntity.dopedhorses$getShoeContainer(), 0, pos.x(), pos.y()){

                public boolean mayPlace(ItemStack itemStack) {
                    if (itemStack.getItem() instanceof ShoeItem && dopedHorseEntity.dopedhorses$getShoeContainer().isEmpty()) {
                        abstractHorse.playSound((SoundEvent)SoundEvents.HORSE_ARMOR.value(), 0.5f, 1.0f);
                        return true;
                    }
                    return false;
                }

                public boolean mayPickup(Player player) {
                    if (!dopedHorseEntity.dopedhorses$canPickUp()) {
                        player.displayClientMessage((Component)Component.translatable((String)"dopedhorses.soulsand_error"), false);
                    }
                    return dopedHorseEntity.dopedhorses$canPickUp();
                }

                public void setChanged() {
                    this.container.setChanged();
                    HorseSpeedManager.updateHorseShoes(abstractHorse, dopedHorseEntity.dopedhorses$getShoeContainer().getItem(0).getItem());
                }

                public boolean isActive() {
                    return abstractHorse.canUseSlot(EquipmentSlot.FEET);
                }

                public ResourceLocation getNoItemIcon() {
                    return SHOE_LOCATION;
                }
            });
        }
    }
}

