/*
 * Decompiled with CFR 0.152.
 */
package fr.gallonemilien.neoforge.config;

import eu.midnightdust.lib.config.MidnightConfig;
import fr.gallonemilien.cache.CacheManager;
import fr.gallonemilien.items.ShoeType;
import fr.gallonemilien.speed.BlockSpeed;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class NeoForgeConfig
extends MidnightConfig {
    public static final String SERVER = "Server";
    @MidnightConfig.Comment(category="Server")
    public static MidnightConfig.Comment explainComment1;
    @MidnightConfig.Comment(category="Server")
    public static MidnightConfig.Comment explainComment2;
    @MidnightConfig.Entry(category="Server", name="Faster Blocks")
    public static List<String> fasterBlocks;
    @MidnightConfig.Comment(category="Server")
    public static MidnightConfig.Comment shoeModifierComment;
    @MidnightConfig.Entry(category="Server")
    public static double ironShoeSpeedModifier;
    @MidnightConfig.Entry(category="Server")
    public static double goldShoeSpeedModifier;
    @MidnightConfig.Entry(category="Server")
    public static double diamondShoeSpeedModifier;
    @MidnightConfig.Entry(category="Server")
    public static double netheriteShoeSpeedModifier;
    @MidnightConfig.Comment(category="Server")
    public static MidnightConfig.Comment stepHeightModifierComment;
    @MidnightConfig.Entry(category="Server")
    public static double ironShoeStepHeightModifier;
    @MidnightConfig.Entry(category="Server")
    public static double goldShoeStepHeightModifier;
    @MidnightConfig.Entry(category="Server")
    public static double diamondShoeStepHeightModifier;
    @MidnightConfig.Entry(category="Server")
    public static double netheriteShoeStepHeightModifier;
    @MidnightConfig.Comment(category="Server")
    public static MidnightConfig.Comment jumpModifierComment;
    @MidnightConfig.Entry(category="Server")
    public static double ironShoeJumpModifier;
    @MidnightConfig.Entry(category="Server")
    public static double goldShoeJumpModifier;
    @MidnightConfig.Entry(category="Server")
    public static double diamondShoeJumpModifier;
    @MidnightConfig.Entry(category="Server")
    public static double netheriteShoeJumpModifier;
    @MidnightConfig.Comment(category="Server")
    public static MidnightConfig.Comment armorModifierComment;
    @MidnightConfig.Entry(category="Server")
    public static double ironShoeArmorModifier;
    @MidnightConfig.Entry(category="Server")
    public static double goldShoeArmorModifier;
    @MidnightConfig.Entry(category="Server")
    public static double diamondShoeArmorModifier;
    @MidnightConfig.Entry(category="Server")
    public static double netheriteShoeArmorModifier;
    @MidnightConfig.Comment(category="Server")
    public static MidnightConfig.Comment shoeLootComment;
    @MidnightConfig.Entry(category="Server", min=0.0, max=1.0, isSlider=true)
    public static double ironShoeLootChance;
    @MidnightConfig.Entry(category="Server", min=0.0, max=1.0, isSlider=true)
    public static double goldShoeLootChance;
    @MidnightConfig.Entry(category="Server", min=0.0, max=1.0, isSlider=true)
    public static double diamondShoeLootChance;
    @MidnightConfig.Entry(category="Server", min=0.0, max=1.0, isSlider=true)
    public static double netheriteShoeLootChance;
    private static List<String> fasterBlocksCache;
    private static double[] shoeCache;

    public void writeChanges(String modid) {
        if (!fasterBlocksCache.equals(fasterBlocks)) {
            BlockSpeed.getInstance().reset();
            CacheManager.getInstance().reset();
            fasterBlocksCache = NeoForgeConfig.cloneList(fasterBlocks);
        }
        if (NeoForgeConfig.isShoeCacheDifferent()) {
            CacheManager.getInstance().reset();
            ShoeType.refreshValues();
        }
        super.writeChanges(modid);
    }

    private static boolean isShoeCacheDifferent() {
        return !Arrays.equals(shoeCache, NeoForgeConfig.setShoeCache());
    }

    private static double[] setShoeCache() {
        shoeCache = new double[]{ironShoeSpeedModifier, goldShoeSpeedModifier, diamondShoeSpeedModifier, netheriteShoeSpeedModifier, ironShoeArmorModifier, goldShoeArmorModifier, diamondShoeArmorModifier, netheriteShoeArmorModifier, ironShoeJumpModifier, goldShoeJumpModifier, diamondShoeJumpModifier, netheriteShoeJumpModifier, ironShoeLootChance, goldShoeLootChance, diamondShoeLootChance, netheriteShoeLootChance, ironShoeStepHeightModifier, goldShoeStepHeightModifier, diamondShoeStepHeightModifier, netheriteShoeStepHeightModifier};
        return shoeCache;
    }

    private static List<String> cloneList(List<String> list) {
        return new ArrayList<String>(list);
    }

    static {
        fasterBlocks = List.of("dirt_path=0.3", ".*concrete=0.5");
        ironShoeSpeedModifier = 0.04;
        goldShoeSpeedModifier = 0.06;
        diamondShoeSpeedModifier = 0.8;
        netheriteShoeSpeedModifier = 0.12;
        ironShoeStepHeightModifier = 0.5;
        goldShoeStepHeightModifier = 1.0;
        diamondShoeStepHeightModifier = 1.5;
        netheriteShoeStepHeightModifier = 2.0;
        ironShoeJumpModifier = 0.1;
        goldShoeJumpModifier = 0.2;
        diamondShoeJumpModifier = 0.3;
        netheriteShoeJumpModifier = 0.6;
        ironShoeArmorModifier = 5.0;
        goldShoeArmorModifier = 2.5;
        diamondShoeArmorModifier = 7.0;
        netheriteShoeArmorModifier = 10.0;
        ironShoeLootChance = 0.15;
        goldShoeLootChance = 0.1;
        diamondShoeLootChance = 0.06;
        netheriteShoeLootChance = 0.03;
        fasterBlocksCache = NeoForgeConfig.cloneList(fasterBlocks);
        shoeCache = NeoForgeConfig.setShoeCache();
    }
}

