/*
 * Decompiled with CFR 0.152.
 */
package fr.gallonemilien.config;

import fr.gallonemilien.config.ConfigDataType;
import fr.gallonemilien.config.ConfigMaterialType;
import fr.gallonemilien.config.ModConfigLoader;
import fr.gallonemilien.items.ShoeType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public abstract class ModConfig
implements ModConfigLoader {
    @NotNull
    private Map<String, Double> fasterBlocks = new HashMap<String, Double>();
    private final Map<Pair<ConfigDataType, ConfigMaterialType>, Double> modifiers = new HashMap<Pair<ConfigDataType, ConfigMaterialType>, Double>();
    private int userUnit = 0;
    private final Map<ShoeType, Double> shoeLoot = new HashMap<ShoeType, Double>();

    public void setUserUnit(int userUnit) {
        this.userUnit = userUnit >= 0 && userUnit <= 2 ? userUnit : 0;
    }

    @NotNull
    public Map<String, Double> getFasterBlocks() {
        return this.fasterBlocks;
    }

    public void setModifier(Pair<ConfigDataType, ConfigMaterialType> key, double value) {
        this.modifiers.put(key, value);
    }

    public Double getModifier(Pair<ConfigDataType, ConfigMaterialType> key) {
        return this.modifiers.get(key);
    }

    public float getShoeLoot(ShoeType key) {
        return (float)this.shoeLoot.get(key).doubleValue();
    }

    public void setShoeLoot(ShoeType key, double value) {
        this.shoeLoot.put(key, value);
    }

    public void setFasterBlocks(@NotNull List<String> fasterBlocksList) {
        this.fasterBlocks = fasterBlocksList.stream().map(entry -> entry.split("=")).filter(parts -> ((String[])parts).length == 2).collect(Collectors.toMap(parts -> parts[0], parts -> {
            try {
                return Double.parseDouble(parts[1]);
            }
            catch (NumberFormatException e) {
                System.err.println("Invalid number format in entry: " + Arrays.toString(parts));
                return 0.0;
            }
        }, (existing, replacement) -> existing, HashMap::new));
    }

    public int getUserUnit() {
        return this.userUnit;
    }
}

