/*
 * Decompiled with CFR 0.152.
 */
package fr.gallonemilien.items;

import fr.gallonemilien.items.ShoeType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ShoeItem
extends Item {
    private final ShoeType type;

    public ShoeItem(Item.Properties properties, ShoeType type) {
        super(properties);
        this.type = type;
    }

    public boolean isEnchantable(ItemStack stack) {
        return true;
    }

    public int getEnchantmentValue() {
        return 1;
    }

    public double getSpeedModifier() {
        return this.type.getSpeedModifier();
    }

    public double getArmorModifier() {
        return this.type.getArmorModifier();
    }

    public double getJumpModifier() {
        return this.type.getJumpModifier();
    }

    public double getStepHeightModifier() {
        return this.type.getStepHeightModifier();
    }

    public static Double calculateSafeFallBonus(ShoeItem shoeItem) {
        double jumpModifier = shoeItem.getJumpModifier();
        if (jumpModifier > 1.4) {
            return Double.MAX_VALUE;
        }
        return jumpModifier * 5.0;
    }
}

