/*
 * Decompiled with CFR 0.152.
 */
package fr.gallonemilien.items;

import fr.gallonemilien.DopedHorses;
import fr.gallonemilien.config.ConfigDataType;
import fr.gallonemilien.config.ConfigMaterialType;
import fr.gallonemilien.config.ModConfig;
import fr.gallonemilien.items.DopedHorsesTypes;
import fr.gallonemilien.items.ShoeItem;
import net.minecraft.core.Holder;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.Item;
import org.apache.commons.lang3.tuple.Pair;

public enum ShoeType implements DopedHorsesTypes<ShoeItem>
{
    IRON("iron_horse_shoes", (Holder<ArmorMaterial>)ArmorMaterials.IRON),
    GOLD("gold_horse_shoes", (Holder<ArmorMaterial>)ArmorMaterials.GOLD),
    DIAMOND("diamond_horse_shoes", (Holder<ArmorMaterial>)ArmorMaterials.DIAMOND),
    NETHERITE("netherite_horse_shoes", (Holder<ArmorMaterial>)ArmorMaterials.NETHERITE);

    private final String name;
    private final Holder<ArmorMaterial> material;
    private double speedModifier;
    private double jumpModifier;
    private double armorModifier;
    private double stepHeightModifier;

    private ShoeType(String name, Holder<ArmorMaterial> material) {
        this.name = name;
        this.material = material;
    }

    @Override
    public ShoeItem getItem() {
        return new ShoeItem(this.getItemProperties(), this);
    }

    @Override
    public Item.Properties getItemProperties() {
        Item.Properties prop = new Item.Properties().stacksTo(1).arch$tab(DopedHorses.TAB);
        if (this.material == ArmorMaterials.NETHERITE) {
            prop.fireResistant();
        }
        return prop;
    }

    public static void refreshValues(ModConfig config) {
        for (ShoeType type : ShoeType.values()) {
            ConfigMaterialType matType = ConfigMaterialType.valueOf(type.name().toUpperCase());
            type.speedModifier = config.getModifier((Pair<ConfigDataType, ConfigMaterialType>)Pair.of((Object)((Object)ConfigDataType.SHOE), (Object)((Object)matType)));
            type.jumpModifier = config.getModifier((Pair<ConfigDataType, ConfigMaterialType>)Pair.of((Object)((Object)ConfigDataType.JUMP), (Object)((Object)matType)));
            type.armorModifier = config.getModifier((Pair<ConfigDataType, ConfigMaterialType>)Pair.of((Object)((Object)ConfigDataType.ARMOR), (Object)((Object)matType)));
            type.stepHeightModifier = config.getModifier((Pair<ConfigDataType, ConfigMaterialType>)Pair.of((Object)((Object)ConfigDataType.STEP_HEIGHT), (Object)((Object)matType)));
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Holder<ArmorMaterial> getMaterial() {
        return this.material;
    }

    public double getSpeedModifier() {
        return this.speedModifier;
    }

    public double getJumpModifier() {
        return this.jumpModifier;
    }

    public double getArmorModifier() {
        return this.armorModifier;
    }

    public double getStepHeightModifier() {
        return this.stepHeightModifier;
    }
}

