/*
 * Decompiled with CFR 0.152.
 */
package fr.gallonemilien.mixin;

import fr.gallonemilien.items.ShoeItem;
import fr.gallonemilien.persistence.ShoeContainer;
import fr.gallonemilien.speed.HorseSpeedManager;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AbstractHorse.class})
public abstract class AbstractHorseMixin
extends Animal
implements ShoeContainer {
    @Unique
    SimpleContainer shoe_container = new SimpleContainer(1);
    private boolean isOnSoulSand = false;

    @Override
    public Container getShoeContainer() {
        return this.shoe_container;
    }

    @Override
    public boolean canPickUp() {
        return !this.isOnSoulSand;
    }

    @Override
    public void setBlockUnder(Block block) {
        this.isOnSoulSand = block.defaultBlockState().is(BlockTags.SOUL_SPEED_BLOCKS);
    }

    protected AbstractHorseMixin(EntityType<? extends Animal> entityType, Level level) {
        super(entityType, level);
    }

    protected boolean hasShoes() {
        return !this.shoe_container.isEmpty() && !this.shoe_container.getItem(0).isEmpty() && this.shoe_container.getItem(0).getItem() instanceof ShoeItem;
    }

    @Inject(method={"addAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V"}, at={@At(value="TAIL")})
    public void saveData(CompoundTag compoundTag, CallbackInfo ci) {
        if (this.hasShoes()) {
            compoundTag.put("ShoeItem", this.shoe_container.getItem(0).save((HolderLookup.Provider)this.registryAccess()));
        }
    }

    @Inject(method={"readAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/nbt/CompoundTag;contains(Ljava/lang/String;I)Z")})
    public void readData(CompoundTag compoundTag, CallbackInfo ci) {
        ItemStack itemStack;
        if (compoundTag.contains("ShoeItem", 10) && (itemStack = ItemStack.parse((HolderLookup.Provider)this.registryAccess(), (Tag)compoundTag.getCompound("ShoeItem")).orElse(ItemStack.EMPTY)).getItem() instanceof ShoeItem) {
            this.shoe_container.setItem(0, itemStack);
        }
    }

    @Shadow
    protected abstract void doPlayerRide(Player var1);

    @Inject(method={"mobInteract(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/InteractionResult;"}, at={@At(value="HEAD")}, cancellable=true)
    private void mobInteract(Player player, InteractionHand interactionHand, CallbackInfoReturnable<InteractionResult> cir) {
        AbstractHorse horse = (AbstractHorse)this;
        if (!horse.isTamed() && player.isCreative()) {
            horse.tameWithName(player);
            cir.setReturnValue((Object)InteractionResult.SUCCESS);
        }
        if (horse.isVehicle()) {
            this.doPlayerRide(player);
            player.startRiding((Entity)horse, true);
            cir.setReturnValue((Object)InteractionResult.SUCCESS);
        }
    }

    @Inject(method={"tickRidden(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/phys/Vec3;)V"}, at={@At(value="HEAD")})
    private void tickRidden(Player arg, Vec3 arg2, CallbackInfo ci) {
        AbstractHorse horse = (AbstractHorse)this;
        HorseSpeedManager.updateHorseSpeed(horse);
    }

    @Inject(method={"doPlayerRide(Lnet/minecraft/world/entity/player/Player;)V"}, at={@At(value="HEAD")})
    private void doPlayerRide(Player arg, CallbackInfo ci) {
        HorseSpeedManager.playerRiding(arg);
    }

    @Inject(method={"getDismountLocationForPassenger(Lnet/minecraft/world/entity/LivingEntity;)Lnet/minecraft/world/phys/Vec3;"}, at={@At(value="HEAD")})
    private void getDismountLocationForPassenger(LivingEntity livingEntity, CallbackInfoReturnable<Vec3> cir) {
        AbstractHorse horse = (AbstractHorse)this;
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            HorseSpeedManager.playerDismount(player);
        }
        HorseSpeedManager.updateHorseSpeed(horse);
    }
}

