/*
 * Decompiled with CFR 0.152.
 */
package fr.gallonemilien.mixin;

import fr.gallonemilien.helper.GuiPosHelper;
import fr.gallonemilien.items.ShoeItem;
import fr.gallonemilien.persistence.ShoeContainer;
import fr.gallonemilien.speed.HorseSpeedManager;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.HorseInventoryMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={HorseInventoryMenu.class})
public abstract class HorseInventoryMenuMixin
extends AbstractContainerMenu {
    protected HorseInventoryMenuMixin(@Nullable MenuType<?> menuType, int i) {
        super(menuType, i);
    }

    @Inject(method={"<init>(ILnet/minecraft/world/entity/player/Inventory;Lnet/minecraft/world/Container;Lnet/minecraft/world/entity/animal/horse/AbstractHorse;I)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/inventory/HorseInventoryMenu;addSlot(Lnet/minecraft/world/inventory/Slot;)Lnet/minecraft/world/inventory/Slot;")})
    public void constructor(int i, Inventory inventory, Container container, final AbstractHorse abstractHorse, int j, CallbackInfo ci) {
        if (abstractHorse instanceof ShoeContainer) {
            final ShoeContainer shoeContainer = (ShoeContainer)abstractHorse;
            GuiPosHelper.Position pos = GuiPosHelper.getSlotPosition(abstractHorse);
            this.addSlot(new Slot(this, shoeContainer.getShoeContainer(), 0, pos.x() + 1, pos.y()){

                public boolean mayPlace(ItemStack itemStack) {
                    if (itemStack.getItem() instanceof ShoeItem && shoeContainer.getShoeContainer().isEmpty()) {
                        abstractHorse.playSound(SoundEvents.HORSE_ARMOR, 0.5f, 1.0f);
                        return true;
                    }
                    return false;
                }

                public boolean mayPickup(Player player) {
                    if (!shoeContainer.canPickUp()) {
                        player.displayClientMessage((Component)Component.translatable((String)"dopedhorses.soulsand_error"), false);
                    }
                    return shoeContainer.canPickUp();
                }

                public void setChanged() {
                    this.container.setChanged();
                    HorseSpeedManager.updateHorseShoes(abstractHorse, shoeContainer.getShoeContainer().getItem(0).getItem());
                }

                public boolean isActive() {
                    return abstractHorse.canUseSlot(EquipmentSlot.FEET);
                }
            });
        }
    }
}

