/*
 * Decompiled with CFR 0.152.
 */
package fr.gallonemilien.speed;

import fr.gallonemilien.DopedHorses;
import fr.gallonemilien.cache.Resetable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import net.minecraft.world.level.block.Block;

public class BlockSpeed
implements Resetable {
    private final Map<String, Double> blockSpeedCache = new HashMap<String, Double>();
    private static BlockSpeed INSTANCE;

    private BlockSpeed() {
    }

    public static BlockSpeed getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new BlockSpeed();
        }
        return INSTANCE;
    }

    public Double getBlockSpeed(Block block) {
        String descriptionId = block.getDescriptionId();
        this.blockSpeedCache.computeIfAbsent(descriptionId, id -> {
            String[] split = id.split("\\.");
            AtomicReference<Double> speedModifier = new AtomicReference<Double>(0.0);
            DopedHorses.getConfig().getFasterBlocks().forEach((key, value) -> {
                if (this.matchesWithRegex((String)key, split[split.length - 1])) {
                    speedModifier.set((Double)value);
                }
            });
            return speedModifier.get();
        });
        return this.blockSpeedCache.get(descriptionId);
    }

    private boolean matchesWithRegex(String key, String blockValue) {
        try {
            return Pattern.compile(key, 2).matcher(blockValue).find();
        }
        catch (Exception e) {
            System.out.println("REGEX ERROR ! Please read the doc ! You need to fix the configuration file where you set the blocks, you can be helped with ChatGPT :)");
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public void reset() {
        this.blockSpeedCache.clear();
    }
}

