/*
 * Decompiled with CFR 0.152.
 */
package fr.gallonemilien.speed;

import fr.gallonemilien.DopedHorses;
import fr.gallonemilien.cache.CacheManager;
import fr.gallonemilien.items.ShoeItem;
import fr.gallonemilien.items.ShoeType;
import fr.gallonemilien.network.RideHorsePayload;
import fr.gallonemilien.persistence.ShoeContainer;
import fr.gallonemilien.speed.BlockSpeed;
import fr.gallonemilien.utils.SpeedUtils;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public class HorseSpeedManager {
    public static final double DEFAULT_SPEED_MODIFIER = 0.0;
    private static final ResourceLocation HORSE_SPEED_BOOST_ID = DopedHorses.id("horse_speed_boost_modifier");
    private static final ResourceLocation HORSE_SHOES_BOOST_ID = DopedHorses.id("horse_shoes_boost_modifier");
    private static final ResourceLocation HORSE_SHOES_ARMOR_ID = DopedHorses.id("horse_shoes_armor_modifier");
    private static final ResourceLocation HORSE_SHOES_JUMP_ID = DopedHorses.id("horse_shoes_jump_modifier");
    private static final ResourceLocation HORSE_SHOES_STEP_HEIGHT_ID = DopedHorses.id("horse_shoes_step_height_modifier");
    private static final ResourceLocation HORSE_SHOES_SAFE_FALL_ID = DopedHorses.id("horse_shoes_safe_fall_modifier");
    private static final CacheManager cacheManager = CacheManager.getInstance();
    private static final BlockSpeed blockSpeedManager = BlockSpeed.getInstance();

    private static boolean serverMiddleware(LivingEntity entity) {
        return !entity.level().isClientSide;
    }

    public static AttributeInstance getSpeedAttribute(AbstractHorse horse) {
        return horse.getAttribute(Attributes.MOVEMENT_SPEED);
    }

    public static AttributeInstance getStepHeight(AbstractHorse horse) {
        return horse.getAttribute(Attributes.STEP_HEIGHT);
    }

    public static AttributeInstance getArmorAttribute(AbstractHorse horse) {
        return horse.getAttribute(Attributes.ARMOR);
    }

    public static AttributeInstance getJumpAttribute(AbstractHorse horse) {
        return horse.getAttribute(Attributes.JUMP_STRENGTH);
    }

    public static AttributeInstance getSafeFallAttribute(AbstractHorse horse) {
        return horse.getAttribute(Attributes.SAFE_FALL_DISTANCE);
    }

    public static void updateHorseShoes(AbstractHorse horse, Item item) {
        if (HorseSpeedManager.serverMiddleware((LivingEntity)horse)) {
            ShoeType.refreshValues(DopedHorses.getConfig());
            HorseSpeedManager.applyShoeModifier(horse, item, HorseSpeedManager.getSpeedAttribute(horse), HORSE_SHOES_BOOST_ID, ShoeItem::getSpeedModifier);
            HorseSpeedManager.applyShoeModifier(horse, item, HorseSpeedManager.getStepHeight(horse), HORSE_SHOES_STEP_HEIGHT_ID, ShoeItem::getStepHeightModifier);
            HorseSpeedManager.applyShoeModifier(horse, item, HorseSpeedManager.getJumpAttribute(horse), HORSE_SHOES_JUMP_ID, ShoeItem::getJumpModifier);
            HorseSpeedManager.applyShoeModifier(horse, item, HorseSpeedManager.getArmorAttribute(horse), HORSE_SHOES_ARMOR_ID, ShoeItem::getArmorModifier);
            HorseSpeedManager.applyShoeModifier(horse, item, HorseSpeedManager.getSafeFallAttribute(horse), HORSE_SHOES_SAFE_FALL_ID, ShoeItem::calculateSafeFallBonus);
        }
    }

    public static void updateHorseSpeed(AbstractHorse horse) {
        if (HorseSpeedManager.serverMiddleware((LivingEntity)horse)) {
            SpeedUtils.updateHudSpeed(horse);
            if (!cacheManager.getInitializedHorse(horse.getUUID()) && horse instanceof ShoeContainer) {
                ShoeContainer container = (ShoeContainer)horse;
                cacheManager.putInitializedHorse(horse.getUUID(), true);
                Item item = container.getShoeContainer().getItem(0).getItem();
                if (item instanceof ShoeItem) {
                    ShoeItem item2 = (ShoeItem)item;
                    HorseSpeedManager.updateHorseShoes(horse, item2);
                }
            }
            BlockPos horsePosition = horse.getOnPos();
            Block blockBeneathHorse = horse.level().getBlockState(horsePosition).getBlock();
            if (horse instanceof ShoeContainer) {
                ShoeContainer shoeContainer = (ShoeContainer)horse;
                shoeContainer.setBlockUnder(blockBeneathHorse);
            }
            if (!HorseSpeedManager.isLastBlockComputedTheSame(horse, blockBeneathHorse)) {
                cacheManager.putLastWalkedOnBlockId(horse.getUUID(), blockBeneathHorse.getDescriptionId());
                Double blockSpeed = blockSpeedManager.getBlockSpeed(blockBeneathHorse);
                if (cacheManager.getHorseMultiplier(horse.getUUID()) != blockSpeed.doubleValue()) {
                    HorseSpeedManager.applySpeedModifier(horse, blockSpeed);
                }
            }
        }
    }

    private static boolean isLastBlockComputedTheSame(AbstractHorse horse, Block block) {
        return cacheManager.getLastWalkedOnBlockId(horse.getUUID()).equals(block.getDescriptionId());
    }

    private static void applyShoeModifier(AbstractHorse horse, Item item, AttributeInstance attribute, ResourceLocation modifierId, Function<ShoeItem, Double> modifierFunction) {
        if (HorseSpeedManager.serverMiddleware((LivingEntity)horse)) {
            attribute.removeModifier(modifierId);
            if (item instanceof ShoeItem) {
                ShoeItem shoes = (ShoeItem)item;
                attribute.addTransientModifier(new AttributeModifier(modifierId, modifierFunction.apply(shoes).doubleValue(), AttributeModifier.Operation.ADD_VALUE));
            }
        }
    }

    private static void applySpeedModifier(AbstractHorse horse, double speedMultiplier) {
        if (HorseSpeedManager.serverMiddleware((LivingEntity)horse)) {
            HorseSpeedManager.getSpeedAttribute(horse).removeModifier(HORSE_SPEED_BOOST_ID);
            HorseSpeedManager.getSpeedAttribute(horse).addTransientModifier(new AttributeModifier(HORSE_SPEED_BOOST_ID, speedMultiplier, AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
            cacheManager.putHorseMultiplier(horse.getUUID(), speedMultiplier);
        }
    }

    public static void playerRiding(Player player) {
        if (HorseSpeedManager.serverMiddleware((LivingEntity)player) && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            DopedHorses.PACKET_HANDLER.sendToPlayer(serverPlayer, new RideHorsePayload(true));
        }
    }

    public static void playerDismount(Player player) {
        if (HorseSpeedManager.serverMiddleware((LivingEntity)player) && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            DopedHorses.PACKET_HANDLER.sendToPlayer(serverPlayer, new RideHorsePayload(false));
        }
    }
}

