/*
 * Decompiled with CFR 0.152.
 */
package fr.gallonemilien.items;

import dev.architectury.event.events.common.LootEvent;
import dev.architectury.registry.level.entity.trade.TradeRegistry;
import dev.architectury.registry.registries.RegistrySupplier;
import fr.gallonemilien.DopedHorses;
import fr.gallonemilien.config.ModConfig;
import fr.gallonemilien.items.DopedHorsesItems;
import fr.gallonemilien.items.ShoeItem;
import fr.gallonemilien.items.ShoeType;
import java.util.List;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public class ItemLoot {
    public static void register() {
        ItemLoot.registerIron();
        ItemLoot.registerGold();
        ItemLoot.registerDiamond();
        ItemLoot.registerNetherite();
        ItemLoot.registerLootTable();
    }

    private static void registerIron() {
        ItemLoot.registerVillager((ResourceKey<VillagerProfession>)VillagerProfession.ARMORER, 1, 12, DopedHorsesItems.IRON_HORSE_SHOES, 12, 5, 0.05f);
    }

    private static void registerGold() {
        ItemLoot.registerVillager((ResourceKey<VillagerProfession>)VillagerProfession.ARMORER, 3, 19, DopedHorsesItems.GOLD_HORSE_SHOES, 12, 8, 0.05f);
    }

    private static void registerDiamond() {
        ItemLoot.registerVillager((ResourceKey<VillagerProfession>)VillagerProfession.ARMORER, 4, 31, DopedHorsesItems.GOLD_HORSE_SHOES, 12, 10, 0.05f);
    }

    private static void registerNetherite() {
    }

    private static void registerLootTable() {
        LootEvent.MODIFY_LOOT_TABLE.register((lootTableId, context, builtin) -> {
            List<String> netherLootTables = List.of("minecraft:chests/nether_bridge", "minecraft:chests/bastion_treasure", "minecraft:chests/bastion_other", "minecraft:chests/bastion_bridge", "minecraft:chests/ruined_portal");
            if (builtin) {
                ModConfig config = DopedHorses.getConfig();
                netherLootTables.forEach(netherLootTable -> {
                    if (lootTableId.toString().contains((CharSequence)netherLootTable)) {
                        LootPool.Builder pool = LootPool.lootPool().add(LootItem.lootTableItem((ItemLike)((ItemLike)DopedHorsesItems.IRON_HORSE_SHOES.get())).when(LootItemRandomChanceCondition.randomChance((float)config.getShoeLoot(ShoeType.IRON)))).add(LootItem.lootTableItem((ItemLike)((ItemLike)DopedHorsesItems.GOLD_HORSE_SHOES.get())).when(LootItemRandomChanceCondition.randomChance((float)config.getShoeLoot(ShoeType.GOLD)))).add(LootItem.lootTableItem((ItemLike)((ItemLike)DopedHorsesItems.DIAMOND_HORSE_SHOES.get())).when(LootItemRandomChanceCondition.randomChance((float)config.getShoeLoot(ShoeType.DIAMOND)))).add(LootItem.lootTableItem((ItemLike)((ItemLike)DopedHorsesItems.NETHERITE_HORSE_SHOES.get())).when(LootItemRandomChanceCondition.randomChance((float)config.getShoeLoot(ShoeType.NETHERITE)))).setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).setBonusRolls((NumberProvider)ConstantValue.exactly((float)0.0f));
                        context.addPool(pool);
                    }
                });
            }
        });
    }

    private static void registerVillager(ResourceKey<VillagerProfession> profession, int lvl, int price, RegistrySupplier<ShoeItem> item, int maxUses, int experience, float multiplier) {
        TradeRegistry.registerVillagerTrade(profession, (int)lvl, (VillagerTrades.ItemListing[])new VillagerTrades.ItemListing[]{(entity, randomSource) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, price), ((ShoeItem)((Object)((Object)item.get()))).getDefaultInstance(), maxUses, experience, multiplier)});
    }
}

