/*
 * Decompiled with CFR 0.152.
 */
package fr.gallonemilien.mixin;

import fr.gallonemilien.items.ShoeItem;
import fr.gallonemilien.persistence.DopedHorseEntity;
import fr.gallonemilien.speed.HorseSpeedManager;
import java.util.Optional;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AbstractHorse.class})
public abstract class AbstractHorseMixin
extends Animal
implements DopedHorseEntity {
    @Unique
    SimpleContainer shoe_container = new SimpleContainer(1);
    @Unique
    private boolean dopedhorses$isOnSoulSand = false;

    protected AbstractHorseMixin(EntityType<? extends Animal> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    public Container dopedhorses$getShoeContainer() {
        return this.shoe_container;
    }

    @Override
    public boolean dopedhorses$canPickUp() {
        return !this.dopedhorses$isOnSoulSand;
    }

    @Override
    public void dopedhorses$setBlockUnder(Block block) {
        this.dopedhorses$isOnSoulSand = block.defaultBlockState().is(BlockTags.SOUL_SPEED_BLOCKS);
    }

    @Unique
    protected Optional<ItemStack> dopedhorses$getShoes() {
        if (!this.shoe_container.isEmpty() && !this.shoe_container.getItem(0).isEmpty() && this.shoe_container.getItem(0).getItem() instanceof ShoeItem) {
            return Optional.of(this.shoe_container.getItem(0));
        }
        return Optional.empty();
    }

    @Inject(method={"dropEquipment(Lnet/minecraft/server/level/ServerLevel;)V"}, at={@At(value="TAIL")})
    private void dropShoeContainer(CallbackInfo ci) {
        if (!this.shoe_container.isEmpty()) {
            Level world = this.level();
            for (int i = 0; i < this.shoe_container.getContainerSize(); ++i) {
                ItemStack stack = this.shoe_container.getItem(i);
                if (stack.isEmpty()) continue;
                ItemEntity entity = new ItemEntity(world, this.getX(), this.getY(), this.getZ(), stack);
                world.addFreshEntity((Entity)entity);
            }
            this.shoe_container.clearContent();
        }
    }

    @Inject(method={"addAdditionalSaveData(Lnet/minecraft/world/level/storage/ValueOutput;)V"}, at={@At(value="TAIL")})
    public void saveData(ValueOutput valueOutput, CallbackInfo ci) {
        this.dopedhorses$getShoes().ifPresent(stack -> valueOutput.store("ShoeItem", ItemStack.CODEC, stack));
    }

    @Inject(method={"readAdditionalSaveData(Lnet/minecraft/world/level/storage/ValueInput;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/animal/horse/AbstractHorse;setEating(Z)V")})
    public void readData(ValueInput valueInput, CallbackInfo ci) {
        valueInput.read("ShoeItem", ItemStack.CODEC).ifPresent(itemStack -> {
            if (itemStack.getItem() instanceof ShoeItem) {
                this.shoe_container.setItem(0, itemStack);
            } else {
                this.shoe_container.setItem(0, ItemStack.EMPTY);
            }
        });
    }

    @Inject(method={"tickRidden(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/phys/Vec3;)V"}, at={@At(value="HEAD")})
    private void tickRidden(Player player, Vec3 arg2, CallbackInfo ci) {
        AbstractHorse horse = (AbstractHorse)this;
        HorseSpeedManager.updateHorseSpeed(horse);
    }

    @Shadow
    protected abstract void doPlayerRide(Player var1);

    @Inject(method={"mobInteract(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/InteractionResult;"}, at={@At(value="HEAD")}, cancellable=true)
    private void mobInteract(Player player, InteractionHand interactionHand, CallbackInfoReturnable<InteractionResult> cir) {
        AbstractHorse horse = (AbstractHorse)this;
        if (!horse.isTamed() && player.isCreative()) {
            horse.tameWithName(player);
            cir.setReturnValue((Object)InteractionResult.SUCCESS);
        }
        if (horse.isVehicle()) {
            this.doPlayerRide(player);
            player.startRiding((Entity)horse, true, false);
            cir.setReturnValue((Object)InteractionResult.SUCCESS);
        }
    }
}

