/*
 * Decompiled with CFR 0.152.
 */
package fr.gallonemilien.mixin;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class})
public abstract class EntityMixin {
    @Inject(at={@At(value="HEAD")}, method={"canAddPassenger(Lnet/minecraft/world/entity/Entity;)Z"}, cancellable=true)
    protected void canAddPassenger(Entity entity, CallbackInfoReturnable<Boolean> cir) {
        EntityMixin entityMixin = this;
        if (entityMixin instanceof AbstractHorse) {
            AbstractHorse abstractHorse = (AbstractHorse)entityMixin;
            cir.setReturnValue((Object)(abstractHorse.getPassengers().size() < 2 ? 1 : 0));
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"positionRider(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/entity/Entity$MoveFunction;)V"}, cancellable=true)
    protected void positionRider(Entity entity, Entity.MoveFunction moveFunction, CallbackInfo ci) {
        AbstractHorse abstractHorse;
        EntityMixin entityMixin = this;
        if (entityMixin instanceof AbstractHorse && (abstractHorse = (AbstractHorse)entityMixin).getPassengers().indexOf(entity) == 1) {
            Vec3 vec3 = abstractHorse.getPassengerRidingPosition(entity);
            float yawRad = (float)Math.toRadians(-abstractHorse.getYRot());
            double backX = Math.sin(yawRad) * 0.5;
            double backZ = Math.cos(yawRad) * 0.5;
            Vec3 riderPos = vec3.add(-backX, 0.0, -backZ);
            Vec3 vec32 = entity.getVehicleAttachmentPoint((Entity)abstractHorse);
            moveFunction.accept(entity, riderPos.x - vec32.x, riderPos.y - vec32.y, riderPos.z - vec32.z);
            ci.cancel();
        }
    }
}

