/*
 * Decompiled with CFR 0.152.
 */
package fr.gallonemilien.speed;

import fr.gallonemilien.DopedHorses;
import fr.gallonemilien.cache.Resetable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import net.minecraft.world.level.block.Block;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockSpeed
implements Resetable {
    private static final Logger LOGGER = LoggerFactory.getLogger(BlockSpeed.class);
    private final Map<String, Double> blockSpeedCache = new ConcurrentHashMap<String, Double>();

    private BlockSpeed() {
    }

    public static BlockSpeed getInstance() {
        return Holder.INSTANCE;
    }

    @Override
    public void reset() {
        LOGGER.debug("Resetting block speed cache.");
        this.blockSpeedCache.clear();
    }

    public double getBlockSpeed(Block block) {
        String descriptionId = block.getDescriptionId();
        return this.blockSpeedCache.computeIfAbsent(descriptionId, this::computeSpeedForBlock);
    }

    private double computeSpeedForBlock(String blockId) {
        String blockName = this.extractBlockName(blockId);
        return DopedHorses.getConfig().getFasterBlocks().entrySet().stream().filter(entry -> this.matchesWithRegex((String)entry.getKey(), blockName)).map(Map.Entry::getValue).findFirst().orElse(0.0);
    }

    private String extractBlockName(String fullId) {
        String[] parts = fullId.split("\\.");
        return parts[parts.length - 1];
    }

    private boolean matchesWithRegex(String regex, String blockValue) {
        try {
            return Pattern.compile(regex, 2).matcher(blockValue).find();
        }
        catch (Exception e) {
            LOGGER.error("REGEX ERROR in configuration: \"{}\" is invalid.", (Object)regex, (Object)e);
            return false;
        }
    }

    private static class Holder {
        private static final BlockSpeed INSTANCE = new BlockSpeed();

        private Holder() {
        }
    }
}

