/*
 * Decompiled with CFR 0.152.
 */
package net.querz.nbt.io;

import java.io.Closeable;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.querz.io.Deserializer;
import net.querz.nbt.io.LittleEndianNBTInputStream;
import net.querz.nbt.io.NBTInput;
import net.querz.nbt.io.NBTInputStream;
import net.querz.nbt.io.NamedTag;

@Environment(value=EnvType.CLIENT)
public class NBTDeserializer
implements Deserializer<NamedTag> {
    private boolean compressed;
    private boolean littleEndian;

    public NBTDeserializer() {
        this(true);
    }

    public NBTDeserializer(boolean compressed) {
        this.compressed = compressed;
    }

    public NBTDeserializer(boolean compressed, boolean littleEndian) {
        this.compressed = compressed;
        this.littleEndian = littleEndian;
    }

    @Override
    public NamedTag fromStream(InputStream stream) throws Exception {
        InputStream input = this.compressed ? new GZIPInputStream(stream) : stream;
        Closeable nbtIn = this.littleEndian ? new LittleEndianNBTInputStream(input) : new NBTInputStream(input);
        return ((NBTInput)((Object)nbtIn)).readTag(512);
    }
}

