/*
 * Decompiled with CFR 0.152.
 */
package net.querz.nbt.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.util.zip.GZIPInputStream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.querz.nbt.io.NBTDeserializer;
import net.querz.nbt.io.NBTSerializer;
import net.querz.nbt.io.NamedTag;
import net.querz.nbt.tag.Tag;

@Environment(value=EnvType.CLIENT)
public final class NBTUtil {
    private NBTUtil() {
    }

    public static void write(NamedTag tag, File file, boolean compressed) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(file);){
            new NBTSerializer(compressed).toStream(tag, (OutputStream)fos);
        }
    }

    public static void write(NamedTag tag, String file, boolean compressed) throws IOException {
        NBTUtil.write(tag, new File(file), compressed);
    }

    public static void write(NamedTag tag, File file) throws IOException {
        NBTUtil.write(tag, file, true);
    }

    public static void write(NamedTag tag, String file) throws IOException {
        NBTUtil.write(tag, new File(file), true);
    }

    public static void write(Tag<?> tag, File file, boolean compressed) throws IOException {
        NBTUtil.write(new NamedTag(null, tag), file, compressed);
    }

    public static void write(Tag<?> tag, String file, boolean compressed) throws IOException {
        NBTUtil.write(new NamedTag(null, tag), new File(file), compressed);
    }

    public static void write(Tag<?> tag, File file) throws IOException {
        NBTUtil.write(new NamedTag(null, tag), file, true);
    }

    public static void write(Tag<?> tag, String file) throws IOException {
        NBTUtil.write(new NamedTag(null, tag), new File(file), true);
    }

    public static void writeLE(NamedTag tag, File file, boolean compressed) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(file);){
            new NBTSerializer(compressed, true).toStream(tag, (OutputStream)fos);
        }
    }

    public static void writeLE(NamedTag tag, String file, boolean compressed) throws IOException {
        NBTUtil.writeLE(tag, new File(file), compressed);
    }

    public static void writeLE(NamedTag tag, File file) throws IOException {
        NBTUtil.writeLE(tag, file, true);
    }

    public static void writeLE(NamedTag tag, String file) throws IOException {
        NBTUtil.writeLE(tag, new File(file), true);
    }

    public static void writeLE(Tag<?> tag, File file, boolean compressed) throws IOException {
        NBTUtil.writeLE(new NamedTag(null, tag), file, compressed);
    }

    public static void writeLE(Tag<?> tag, String file, boolean compressed) throws IOException {
        NBTUtil.writeLE(new NamedTag(null, tag), new File(file), compressed);
    }

    public static void writeLE(Tag<?> tag, File file) throws IOException {
        NBTUtil.writeLE(new NamedTag(null, tag), file, true);
    }

    public static void writeLE(Tag<?> tag, String file) throws IOException {
        NBTUtil.writeLE(new NamedTag(null, tag), new File(file), true);
    }

    public static NamedTag read(File file, boolean compressed) throws Exception {
        NamedTag var4;
        try (FileInputStream fis = new FileInputStream(file);){
            var4 = new NBTDeserializer(compressed).fromStream(fis);
        }
        return var4;
    }

    public static NamedTag read(String file, boolean compressed) throws Exception {
        return NBTUtil.read(new File(file), compressed);
    }

    public static NamedTag read(File file) throws Exception {
        NamedTag var3;
        try (FileInputStream fis = new FileInputStream(file);){
            var3 = new NBTDeserializer(false).fromStream(NBTUtil.detectDecompression(fis));
        }
        return var3;
    }

    public static NamedTag read(String file) throws Exception {
        return NBTUtil.read(new File(file));
    }

    public static NamedTag readLE(File file, boolean compressed) throws Exception {
        NamedTag var4;
        try (FileInputStream fis = new FileInputStream(file);){
            var4 = new NBTDeserializer(compressed, true).fromStream(fis);
        }
        return var4;
    }

    public static NamedTag readLE(String file, boolean compressed) throws Exception {
        return NBTUtil.readLE(new File(file), compressed);
    }

    public static NamedTag readLE(File file) throws Exception {
        NamedTag var3;
        try (FileInputStream fis = new FileInputStream(file);){
            var3 = new NBTDeserializer(false, true).fromStream(NBTUtil.detectDecompression(fis));
        }
        return var3;
    }

    public static NamedTag readLE(String file) throws Exception {
        return NBTUtil.readLE(new File(file));
    }

    private static InputStream detectDecompression(InputStream is) throws IOException {
        PushbackInputStream pbis = new PushbackInputStream(is, 2);
        int signature = (pbis.read() & 0xFF) + (pbis.read() << 8);
        pbis.unread(signature >> 8);
        pbis.unread(signature & 0xFF);
        return signature == 35615 ? new GZIPInputStream(pbis) : pbis;
    }
}

