package cc.dvitski.enchantedsails.mixin;

import cc.dvitski.enchantedsails.BoatHandler;
import cc.dvitski.enchantedsails.EnchantedSails;
import cc.dvitski.enchantedsails.entity.BoatAccessor;
import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import net.minecraft.class_10255;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1299;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_8836;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_10255.class)
public abstract class AbstractBoatMixin extends class_8836 implements BoatAccessor {
    @Shadow
    private boolean inputUp;
    @Shadow
    private boolean inputDown;
    @Shadow
    private float deltaRotation;
    @Shadow
    private boolean inputLeft;
    @Shadow
    private boolean inputRight;
    @Unique
    private static String ITEM_STACK_KEY = class_2960.method_60655(EnchantedSails.MOD_ID, "stack").toString();

    @NotNull
    @Unique
    private class_1799 itemStack = class_1799.field_8037;

    private AbstractBoatMixin(class_1299<?> type, class_1937 level) {
        super(type, level);
    }

    @WrapMethod(method = "getPickResult")
    private class_1799 onPickItem(Operation<class_1799> original) {
        return BoatHandler.INSTANCE.modifyDroppedBoat(this.getItemStack(), original.call());
    }

    @Inject(method = "addAdditionalSaveData", at = @At("TAIL"))
    private void onSave(class_11372 values, CallbackInfo ci) {
        class_1799 stack = this.getItemStack();
        values.method_71468(ITEM_STACK_KEY, class_1799.field_49266, stack);
    }

    @Inject(method = "readAdditionalSaveData", at = @At("TAIL"))
    private void onRead(class_11368 values, CallbackInfo ci) {
        values.method_71426(ITEM_STACK_KEY, class_1799.field_24671).ifPresent(this::setItemStack);
    }

    @ModifyVariable(method = "controlBoat", at = @At(value = "STORE", ordinal = 0))
    private float onControlBoat(float original) {
        return original + BoatHandler.INSTANCE.addBoatSpeed((class_10255) (Object) this, this.itemStack, this.inputUp, this.inputDown);
    }

    @Inject(method = "floatBoat", at = @At("TAIL"))
    private void endFloatBoat(CallbackInfo ci) {
        this.deltaRotation = BoatHandler.INSTANCE.modifyBoatRotation((class_10255) (Object) this, this.itemStack, this.deltaRotation, this.inputLeft, this.inputRight);
    }

    @Unique
    @Override
    public @NotNull class_1799 getItemStack() {
        return this.itemStack;
    }

    @Unique
    @Override
    public void setItemStack(@NotNull class_1799 stack) {
        this.itemStack = stack.method_7972();
        BoatHandler.INSTANCE.sendBoatStackPayload(this, stack);
    }
}
