package cc.dvitski.enchantedsails.mixin;

import cc.dvitski.enchantedsails.entity.BoatAccessor;
import cc.dvitski.enchantedsails.network.BoatItemStackPayload;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_3222;
import net.minecraft.class_3231;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_3231.class)
public class ServerEntityMixin {
    @Shadow
    @Final
    private class_1297 entity;

    @Inject(method = "addPairing", at = @At("TAIL"))
    private void onAddPairing(class_3222 player, CallbackInfo ci) {
        if (this.entity instanceof BoatAccessor accessor) {
            class_1799 stack = accessor.getItemStack();
            ServerPlayNetworking.send(player, new BoatItemStackPayload(this.entity.method_5628(), stack));
        }
    }
}
