package cc.dvitski.enchantedsails.mixin;

import cc.dvitski.enchantedsails.BoatHandler;
import cc.dvitski.enchantedsails.entity.BoatAccessor;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_8836;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(class_8836.class)
public class VehicleEntityMixin {
    @WrapOperation(
            method = "destroy(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/item/Item;)V",
            at = @At(
                    value = "NEW",
                    target = "(Lnet/minecraft/world/level/ItemLike;)Lnet/minecraft/world/item/ItemStack;"
            )
    )
    private class_1799 onBoatItem(class_1935 itemLike, Operation<class_1799> original) {
        class_1799 originalStack = original.call(itemLike);

        if (this instanceof BoatAccessor accessor) {
            return BoatHandler.INSTANCE.modifyDroppedBoat(accessor.getItemStack(), originalStack);
        }

        return originalStack;
    }
}
