/*
 * Decompiled with CFR 0.152.
 */
package com.mongenscave.mcchatgame.hooks.plugins;

import com.mongenscave.mcchatgame.McChatGame;
import com.mongenscave.mcchatgame.identifiers.GameState;
import com.mongenscave.mcchatgame.identifiers.keys.ConfigKeys;
import com.mongenscave.mcchatgame.managers.StreakManager;
import com.mongenscave.mcchatgame.models.GameHandler;
import java.util.Optional;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlaceholderAPI {
    public static boolean isRegistered = false;

    public static void registerHook() {
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            new PlaceholderIntegration().register();
            isRegistered = true;
        }
    }

    private static class PlaceholderIntegration
    extends PlaceholderExpansion {
        private PlaceholderIntegration() {
        }

        @NotNull
        public String getIdentifier() {
            return "mcchatgame";
        }

        @NotNull
        public String getAuthor() {
            return "coma112";
        }

        @NotNull
        public String getVersion() {
            return McChatGame.getInstance().getDescription().getVersion();
        }

        public boolean canRegister() {
            return true;
        }

        public boolean persist() {
            return true;
        }

        public String onPlaceholderRequest(@NotNull Player player, @NotNull String params) {
            if (params.startsWith("fastest_time_player_")) {
                return this.getFastestTimePlayer(params);
            }
            if (params.startsWith("fastest_time_")) {
                return this.getFastestTime(params);
            }
            if (params.startsWith("most_win_player_")) {
                return this.getMostWinPlayer(params);
            }
            if (params.startsWith("most_win_")) {
                return this.getMostWin(params);
            }
            switch (params) {
                case "current_game": {
                    return this.getCurrentGamePlaceholder();
                }
                case "fastest_time": {
                    double time = McChatGame.getInstance().getDatabase().getTime(player).join();
                    if (time >= 999999.99) {
                        return "00.00";
                    }
                    return String.format("%.2f", time);
                }
                case "wins": {
                    return String.valueOf(McChatGame.getInstance().getDatabase().getWins(player).join());
                }
                case "streak": {
                    return String.valueOf(StreakManager.getInstance().getPlayerStreak(player).join());
                }
                case "best_streak": {
                    return String.valueOf(StreakManager.getInstance().getPlayerBestStreak(player).join());
                }
            }
            return "---";
        }

        private String getCurrentGamePlaceholder() {
            GameHandler activeGame = GameHandler.getCurrentActiveGame();
            if (activeGame == null || activeGame.getState() != GameState.ACTIVE) {
                return ConfigKeys.PLACEHOLDER_NO_GAMES.getString();
            }
            String gameType = activeGame.getClass().getSimpleName();
            String placeholder = this.getPlaceholderForGameType(gameType);
            if (placeholder == null) {
                return ConfigKeys.PLACEHOLDER_NO_GAMES.getString();
            }
            String gameWord = activeGame.getGameData();
            String timeRemaining = this.getTimeRemaining(activeGame);
            if (gameWord == null) {
                return ConfigKeys.PLACEHOLDER_NO_GAMES.getString();
            }
            return placeholder.replace("{word}", gameWord).replace("{time}", timeRemaining);
        }

        @Nullable
        private String getPlaceholderForGameType(@NotNull String gameType) {
            return switch (gameType) {
                case "GameFillOut" -> ConfigKeys.PLACEHOLDER_FILL_OUT.getString();
                case "GameMath" -> ConfigKeys.PLACEHOLDER_MATH.getString();
                case "GameRandomCharacters" -> ConfigKeys.PLACEHOLDER_RANDOM.getString();
                case "GameReverse" -> ConfigKeys.PLACEHOLDER_REVERSE.getString();
                case "GameWhoAmI" -> ConfigKeys.PLACEHOLDER_WHO_AM_I.getString();
                case "GameWordGuess" -> ConfigKeys.PLACEHOLDER_WORD_GUESS.getString();
                case "GameWordStop" -> ConfigKeys.PLACEHOLDER_WORD_STOP.getString();
                case "GameCrafting" -> ConfigKeys.PLACEHOLDER_CRAFTING.getString();
                default -> null;
            };
        }

        @NotNull
        private String getTimeRemaining(@NotNull GameHandler game) {
            long currentTime;
            long elapsedTime;
            long startTime = game.getStartTime();
            if (startTime == 0L) {
                return "---";
            }
            int gameTimeout = this.getGameTimeout(game.getClass().getSimpleName());
            long remainingTime = (long)gameTimeout * 1000L - (elapsedTime = (currentTime = System.currentTimeMillis()) - startTime);
            if (remainingTime <= 0L) {
                return "0";
            }
            return String.format("%d", remainingTime / 1000L);
        }

        private int getGameTimeout(@NotNull String gameType) {
            return switch (gameType) {
                case "GameFillOut" -> ConfigKeys.FILL_OUT_TIME.getInt();
                case "GameMath" -> ConfigKeys.MATH_TIME.getInt();
                case "GameRandomCharacters" -> ConfigKeys.RANDOM_CHARACTERS_TIME.getInt();
                case "GameReverse" -> ConfigKeys.REVERSE_TIME.getInt();
                case "GameWhoAmI" -> ConfigKeys.WHO_AM_I_TIME.getInt();
                case "GameWordGuess" -> ConfigKeys.WORD_GUESSER_TIME.getInt();
                case "GameWordStop" -> ConfigKeys.WORD_STOP_TIME.getInt();
                case "GameCrafting" -> ConfigKeys.CRAFTING_TIME.getInt();
                default -> 60;
            };
        }

        private String getFastestTimePlayer(@NotNull String params) {
            return this.parsePosition(params, "fastest_time_player_").map(position -> Optional.ofNullable(McChatGame.getInstance().getDatabase().getFastestTimePlayer((int)position).join()).orElse("---")).orElse("");
        }

        private String getFastestTime(@NotNull String params) {
            return this.parsePosition(params, "fastest_time_").map(position -> {
                double time = McChatGame.getInstance().getDatabase().getFastestTime((int)position).join();
                return time != 0.0 ? String.valueOf(time) : "---";
            }).orElse("");
        }

        private String getMostWinPlayer(@NotNull String params) {
            return this.parsePosition(params, "most_win_player_").map(position -> Optional.ofNullable(McChatGame.getInstance().getDatabase().getMostWinsPlayer((int)position).join()).orElse("---")).orElse("");
        }

        private String getMostWin(@NotNull String params) {
            return this.parsePosition(params, "most_win_").map(position -> {
                int time = McChatGame.getInstance().getDatabase().getMostWins((int)position).join();
                return time != 0 ? String.valueOf(time) : "---";
            }).orElse("");
        }

        private Optional<Integer> parsePosition(@NotNull String params, @NotNull String prefix) {
            try {
                return Optional.of(Integer.parseInt(params.substring(prefix.length())));
            }
            catch (NumberFormatException exception) {
                return Optional.empty();
            }
        }
    }
}

